/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.base;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import it.hurts.sskirillss.octolib.config.data.ConfigContext;
import it.hurts.sskirillss.octolib.config.data.OctoConfig;
import it.hurts.sskirillss.relics.client.particles.circle.CircleTintData;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.config.ConfigHelper;
import it.hurts.sskirillss.relics.items.ItemBase;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicAttributeModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicSlotModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.AbilityCastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.AbilityCastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.utils.AbilityUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.ResearchUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public abstract class RelicItem
extends ItemBase
implements ICurioItem {
    private RelicData relicData;

    public RelicItem(Item.Properties properties) {
        super(properties);
        this.setRelicData(this.constructRelicData());
    }

    public RelicItem() {
        super(new Item.Properties().m_41497_(Rarity.RARE).m_41487_(1));
        this.setRelicData(this.constructRelicData());
    }

    public final OctoConfig getConfig() {
        return ConfigHelper.getConfig(this);
    }

    public void appendConfig(ConfigContext context) {
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        LinkedHashMultimap modifiers = LinkedHashMultimap.create();
        RelicAttributeModifier attributes = this.getAttributeModifiers(stack);
        RelicSlotModifier slots = this.getSlotModifiers(stack);
        if (attributes != null) {
            attributes.getAttributes().forEach(arg_0 -> RelicItem.lambda$getAttributeModifiers$0((Multimap)modifiers, uuid, stack, arg_0));
        }
        if (slots != null) {
            slots.getModifiers().forEach(arg_0 -> RelicItem.lambda$getAttributeModifiers$1((Multimap)modifiers, uuid, arg_0));
        }
        return modifiers;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        Vec3 pos = entity.m_20182_();
        RandomSource random = entity.m_20193_().m_213780_();
        if (this.getStyle(stack) != null) {
            String hex = this.getStyle(stack).getParticles();
            Color color = hex == null || hex.isEmpty() ? new Color(stack.m_41791_().f_43022_.m_126665_()) : Color.decode(hex);
            entity.m_20193_().m_7106_((ParticleOptions)new CircleTintData(color, random.m_188501_() * 0.025f + 0.04f, 25, 0.97f, true), pos.m_7096_() + (double)(MathUtils.randomFloat(random) * 0.25f), pos.m_7098_() + (double)0.1f, pos.m_7094_() + (double)(MathUtils.randomFloat(random) * 0.25f), 0.0, (double)random.m_188501_() * 0.05, 0.0);
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        if (!level.m_5776_()) {
            for (Map.Entry<String, RelicAbilityEntry> entry : AbilityUtils.getRelicAbilityData(stack.m_41720_()).getAbilities().entrySet()) {
                String ability = entry.getKey();
                int cooldown = AbilityUtils.getAbilityCooldown(stack, ability);
                if (cooldown <= 0) continue;
                AbilityUtils.addAbilityCooldown(stack, ability, -1);
            }
        }
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        return new ArrayList<Component>();
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public RelicStyleData getStyle(ItemStack stack) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (level == null || !level.m_5776_()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        tooltip.add((Component)Component.m_237113_((String)" "));
        if (ResearchUtils.isItemResearched((Player)player, stack.m_41720_())) {
            if (Screen.m_96638_()) {
                RelicData relicData = this.getRelicData();
                if (relicData == null) {
                    return;
                }
                RelicAbilityData abilityData = relicData.getAbilityData();
                if (abilityData == null) {
                    return;
                }
                Map<String, RelicAbilityEntry> abilities = abilityData.getAbilities();
                tooltip.add((Component)Component.m_237113_((String)"\u25b6 ").m_130940_(ChatFormatting.DARK_GREEN).m_7220_((Component)Component.m_237115_((String)"tooltip.relics.relic.tooltip.abilities").m_130940_(ChatFormatting.GREEN)));
                for (Map.Entry<String, RelicAbilityEntry> entry : abilities.entrySet()) {
                    String item = ForgeRegistries.ITEMS.getKey((Object)this).m_135815_();
                    String name = entry.getKey();
                    if (!AbilityUtils.canUseAbility(stack, name)) continue;
                    tooltip.add((Component)Component.m_237113_((String)"   \u25c6 ").m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237115_((String)("tooltip.relics." + item + ".ability." + name)).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)" - ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237115_((String)("tooltip.relics." + item + ".ability." + name + ".description")).m_130940_(ChatFormatting.GRAY)));
                }
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.relics.relic.tooltip.shift").m_130940_(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.relics.relic.tooltip.table").m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.m_237113_((String)" "));
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, AbilityCastType type, AbilityCastStage stage) {
    }

    public void tickActiveAbilitySelection(ItemStack stack, Player player, String ability) {
    }

    public RelicAttributeModifier getAttributeModifiers(ItemStack stack) {
        return null;
    }

    public RelicSlotModifier getSlotModifiers(ItemStack stack) {
        return null;
    }

    @Nullable
    public RelicData constructRelicData() {
        return null;
    }

    public RelicData getRelicData() {
        return this.relicData;
    }

    public void setRelicData(RelicData relicData) {
        this.relicData = relicData;
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$1(Multimap modifiers, UUID uuid, Pair slot) {
        CuriosApi.addSlotModifier((Multimap)modifiers, (String)((String)slot.getLeft()), (UUID)uuid, (double)((Integer)slot.getRight()).intValue(), (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$0(Multimap modifiers, UUID uuid, ItemStack stack, RelicAttributeModifier.Modifier attribute) {
        modifiers.put((Object)attribute.getAttribute(), (Object)new AttributeModifier(uuid, ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_() + "_" + ForgeRegistries.ATTRIBUTES.getKey((Object)attribute.getAttribute()).m_135815_(), (double)attribute.getMultiplier(), attribute.getOperation()));
    }
}

