/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.back;

import it.hurts.sskirillss.relics.client.particles.circle.CircleTintData;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.items.relics.base.utils.AbilityUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.LevelingUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.awt.Color;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

public class MidnightRobeItem
extends RelicItem {
    private static final String TAG_TARGET = "target";

    @Override
    public RelicData constructRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("vanish", RelicAbilityEntry.builder().requiredPoints(2).stat("light", RelicAbilityStat.builder().initialValue(1.0, 2.0).upgradeModifier(RelicAbilityStat.Operation.ADD, 1.0).formatValue(value -> (int)MathUtils.round(value, 0)).build()).stat("speed", RelicAbilityStat.builder().initialValue(0.1, 0.35).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.35).formatValue(value -> (int)(MathUtils.round(value, 3) * 100.0)).build()).build()).ability("backstab", RelicAbilityEntry.builder().stat("damage", RelicAbilityStat.builder().initialValue(1.25, 1.75).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)(100.0 * MathUtils.round(value - 1.0, 1))).build()).stat("distance", RelicAbilityStat.builder().initialValue(15.0, 20.0).upgradeModifier(RelicAbilityStat.Operation.ADD, -0.5).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).levelingData(new RelicLevelingData(100, 10, 100)).styleData(RelicStyleData.builder().borders("#00071f", "#001974").build()).build();
    }

    public void curioTick(String identifier, int index, LivingEntity entity, ItemStack stack) {
        Level level = entity.m_20193_();
        if (level.m_5776_()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        LivingEntity target = MidnightRobeItem.getTarget((Level)serverLevel, stack);
        if (target != null) {
            double radius = AbilityUtils.getAbilityValue(stack, "backstab", "distance");
            double step = 0.25;
            int offset = 16;
            double len = (float)(Math.PI * 2 * radius);
            int num = (int)(len / step);
            for (int i = 0; i < num; ++i) {
                int tries;
                double angle = Math.toRadians((double)(360.0f / (float)num * (float)i) + 360.0 * ((len / step - (double)num) / (double)num / len));
                double extraX = radius * Math.sin(angle) + target.m_20185_();
                double extraZ = radius * Math.cos(angle) + target.m_20189_();
                double extraY = target.m_20186_() + (double)(target.m_20206_() * 0.5f);
                boolean foundPos = false;
                for (tries = 0; tries < offset * 2; ++tries) {
                    Vec3 vec = new Vec3(extraX, extraY, extraZ);
                    BlockPos pos = new BlockPos((int)vec.f_82479_, (int)vec.f_82480_, (int)vec.f_82481_);
                    BlockState state = serverLevel.m_8055_(pos);
                    VoxelShape shape = state.m_60812_((BlockGetter)serverLevel, pos);
                    if (shape.m_83281_()) {
                        if (!foundPos) {
                            extraY -= 1.0;
                            continue;
                        }
                    } else {
                        foundPos = true;
                    }
                    if (shape.m_83281_()) break;
                    AABB aabb = shape.m_83215_();
                    if (!aabb.m_82338_(pos).m_82390_(vec)) {
                        if (!(aabb.f_82292_ >= 1.0)) break;
                        extraY += 1.0;
                        continue;
                    }
                    extraY += step;
                }
                if (tries >= offset * 2) continue;
                serverLevel.m_8767_((ParticleOptions)new CircleTintData(new Color(50 + serverLevel.m_213780_().m_188503_(50), 0, 255), 0.2f, 3, 0.75f, true), extraX, extraY + (double)0.1f, extraZ, 1, 0.05, 0.05, 0.05, 0.025);
            }
        }
        if (!MidnightRobeItem.canHide(entity)) {
            EntityUtils.removeAttribute(entity, stack, Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_TOTAL);
            if (target != null && (target.m_21224_() || target.m_20182_().m_82554_(entity.m_20182_()) >= AbilityUtils.getAbilityValue(stack, "backstab", "distance"))) {
                NBTUtils.clearTag(stack, TAG_TARGET);
            }
        } else {
            entity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.VANISHING.get(), 5, 0, false, false));
            EntityUtils.applyAttribute(entity, stack, Attributes.f_22279_, (float)AbilityUtils.getAbilityValue(stack, "vanish", "speed"), AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
    }

    @Nullable
    private static LivingEntity getTarget(Level level, ItemStack stack) {
        LivingEntity target;
        if (level.m_5776_()) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        String string = NBTUtils.getString(stack, TAG_TARGET, "");
        if (string.isEmpty()) {
            return null;
        }
        Entity entity = serverLevel.m_8791_(UUID.fromString(string));
        if (!(entity instanceof LivingEntity) || (target = (LivingEntity)entity).m_21224_()) {
            NBTUtils.clearTag(stack, TAG_TARGET);
            return null;
        }
        return target;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean canHide(LivingEntity entity) {
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)entity, (Item)ItemRegistry.MIDNIGHT_ROBE.get());
        Level world = entity.m_20193_();
        BlockPos position = entity.m_20183_().m_7494_();
        double light = AbilityUtils.getAbilityValue(stack, "vanish", "light");
        if (stack.m_41619_()) return false;
        if (!NBTUtils.getString(stack, TAG_TARGET, "").isEmpty()) return false;
        double d = (double)world.m_45517_(LightLayer.BLOCK, position) + (double)world.m_45517_(LightLayer.SKY, position) / 2.0;
        double d2 = world.m_46462_() ? light * 1.5 : light;
        if (!(d <= d2)) return false;
        return true;
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        EntityUtils.removeAttribute(slotContext.entity(), stack, Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    @Mod.EventBusSubscriber
    public static class ServerEvents {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            ItemStack stack;
            Player player;
            LivingEntity target;
            block7: {
                block6: {
                    block5: {
                        block4: {
                            target = event.getEntity();
                            Level level = target.m_20193_();
                            Entity entity = event.getSource().m_7639_();
                            if (!(entity instanceof Player)) break block4;
                            player = (Player)entity;
                            if (!level.m_5776_() && !target.m_20149_().equals(player.m_20149_())) break block5;
                        }
                        return;
                    }
                    stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.MIDNIGHT_ROBE.get());
                    if (stack.m_41619_() || !MidnightRobeItem.canHide((LivingEntity)player)) break block6;
                    Vec3 vec3 = new Vec3(target.m_20185_(), player.m_20186_(), target.m_20189_());
                    if (!(player.m_20182_().m_82554_(vec3) > AbilityUtils.getAbilityValue(stack, "backstab", "distance"))) break block7;
                }
                return;
            }
            LevelingUtils.addExperience((Entity)player, stack, Math.round(event.getAmount() * 0.5f));
            event.setAmount((float)((double)event.getAmount() * AbilityUtils.getAbilityValue(stack, "backstab", "damage")));
            NBTUtils.setString(stack, MidnightRobeItem.TAG_TARGET, target.m_20149_());
        }
    }
}

