/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.back;

import it.hurts.sskirillss.relics.api.events.common.ContainerSlotClickEvent;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.AbilityCastPredicate;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.AbilityCastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.AbilityCastType;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.data.PredicateInfo;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.items.relics.base.utils.AbilityUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.LevelingUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ElytraBoosterItem
extends RelicItem {
    public static final String TAG_FUEL = "fuel";
    public static final String TAG_SPEED = "speed";

    @Override
    public RelicData constructRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("boost", RelicAbilityEntry.builder().maxLevel(10).active(AbilityCastType.CYCLICAL, AbilityCastPredicate.builder().predicate(TAG_FUEL, data -> PredicateInfo.builder().condition(NBTUtils.getInt(data.getStack(), TAG_FUEL, 0) > 0).build()).predicate("elytra", data -> PredicateInfo.builder().condition(data.getPlayer().m_21255_()).build())).stat("capacity", RelicAbilityStat.builder().initialValue(50.0, 100.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.25).formatValue(value -> (int)MathUtils.round(value, 0)).build()).stat(TAG_SPEED, RelicAbilityStat.builder().initialValue(1.1, 1.5).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round(value * 16.0, 1)).build()).build()).build()).levelingData(new RelicLevelingData(100, 10, 100)).styleData(RelicStyleData.builder().borders("#b8b8d6", "#6e6e8f").build()).build();
    }

    public int getBreathCapacity(ItemStack stack) {
        return (int)Math.round(AbilityUtils.getAbilityValue(stack, "boost", "capacity"));
    }

    @Override
    public void castActiveAbility(ItemStack stack, Player player, String ability, AbilityCastType type, AbilityCastStage stage) {
        if (ability.equals("boost") && stage == AbilityCastStage.TICK) {
            int fuel = NBTUtils.getInt(stack, TAG_FUEL, 0);
            if (fuel > 0 && player.f_19797_ % 20 == 0) {
                NBTUtils.setInt(stack, TAG_FUEL, --fuel);
            }
            double speed = NBTUtils.getDouble(stack, TAG_SPEED, 1.0);
            if (player.f_19797_ % 3 == 0) {
                double maxSpeed = AbilityUtils.getAbilityValue(stack, "boost", TAG_SPEED);
                if (speed < maxSpeed) {
                    speed = Math.min(maxSpeed, speed + (maxSpeed - 1.0) / 100.0);
                    NBTUtils.setDouble(stack, TAG_SPEED, speed);
                } else {
                    player.m_204079_(5);
                }
            }
            Vec3 look = player.m_20154_();
            Vec3 motion = player.m_20184_();
            Level world = player.m_20193_();
            RandomSource random = world.m_213780_();
            player.m_20256_(motion.m_82520_(look.f_82479_ * 0.1 + (look.f_82479_ * speed - motion.f_82479_) * 0.5, look.f_82480_ * 0.1 + (look.f_82480_ * speed - motion.f_82480_) * 0.5, look.f_82481_ * 0.1 + (look.f_82481_ * speed - motion.f_82481_) * 0.5));
            int i = 0;
            while ((double)i < speed * 3.0) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, player.m_20185_() + (double)(MathUtils.randomFloat(random) * 0.4f), player.m_20186_() + (double)(MathUtils.randomFloat(random) * 0.4f), player.m_20189_() + (double)(MathUtils.randomFloat(random) * 0.4f), 0.0, 0.0, 0.0);
                ++i;
            }
            if (player.f_19797_ % Math.max(1, (int)Math.round((10.0 - speed * 2.0) / (double)(player.m_20070_() ? 2 : 1))) == 0) {
                NBTUtils.setInt(stack, TAG_FUEL, --fuel);
            }
        }
    }

    @Override
    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        super.m_6883_(stack, level, entity, slot, isSelected);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        double speed = NBTUtils.getDouble(stack, TAG_SPEED, 1.0);
        int fuel = NBTUtils.getInt(stack, TAG_FUEL, 0);
        if (speed > 1.0 && (fuel <= 0 || !player.m_21255_())) {
            NBTUtils.setDouble(stack, TAG_SPEED, 1.0);
        }
    }

    @SubscribeEvent
    public static void onSlotClick(ContainerSlotClickEvent event) {
        if (event.getAction() != ClickAction.PRIMARY) {
            return;
        }
        Player player = event.getEntity();
        ItemStack heldStack = event.getHeldStack();
        ItemStack slotStack = event.getSlotStack();
        Item item = slotStack.m_41720_();
        if (!(item instanceof ElytraBoosterItem)) {
            return;
        }
        ElytraBoosterItem booster = (ElytraBoosterItem)item;
        int time = ForgeHooks.getBurnTime((ItemStack)heldStack, (RecipeType)RecipeType.f_44108_) / 20;
        int amount = NBTUtils.getInt(slotStack, TAG_FUEL, 0);
        int capacity = booster.getBreathCapacity(slotStack);
        int sum = amount + time;
        if (time <= 0) {
            return;
        }
        NBTUtils.setInt(slotStack, TAG_FUEL, Math.min(capacity, sum));
        int left = sum > capacity ? time - (sum - capacity) : time;
        LevelingUtils.addExperience((Entity)player, slotStack, (int)Math.floor((float)left / 10.0f));
        ItemStack result = heldStack.getCraftingRemainingItem();
        heldStack.m_41774_(1);
        if (!result.m_41619_()) {
            if (heldStack.m_41619_()) {
                player.f_36096_.m_142503_(result);
            } else {
                player.m_150109_().m_36054_(result);
            }
        }
        player.m_5496_(SoundEvents.f_11705_, 0.75f, 2.0f / ((float)time * 0.025f));
        event.setCanceled(true);
    }
}

