/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.back;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.api.events.common.ContainerSlotClickEvent;
import it.hurts.sskirillss.relics.client.particles.circle.CircleTintData;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.entities.ArrowRainEntity;
import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.init.SoundRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.AbilityCastPredicate;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.AbilityCastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.AbilityCastType;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.data.PredicateInfo;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.items.relics.base.utils.AbilityUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.LevelingUtils;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.PacketPlayerMotion;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingGetProjectileEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ArrowQuiverItem
extends RelicItem {
    private static final String TAG_LEAP = "leap";
    private static final String TAG_ARROWS = "arrows";

    @Override
    public RelicData constructRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("receptacle", RelicAbilityEntry.builder().maxLevel(10).stat("slots", RelicAbilityStat.builder().initialValue(2.0, 5.0).upgradeModifier(RelicAbilityStat.Operation.ADD, 1.0).formatValue(value -> (int)Math.round(value)).build()).build()).ability(TAG_LEAP, RelicAbilityEntry.builder().requiredLevel(5).maxLevel(10).active(AbilityCastType.INSTANTANEOUS, AbilityCastPredicate.builder().predicate("target", data -> {
            Player player = data.getPlayer();
            Level level = player.m_9236_();
            double maxDistance = player.getBlockReach() + 1.0;
            Vec3 view = player.m_20252_(0.0f);
            Vec3 eyeVec = player.m_20299_(0.0f);
            BlockHitResult ray = level.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * maxDistance, view.f_82480_ * maxDistance, view.f_82481_ * maxDistance), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
            boolean isCorrect = ray.m_6662_() != HitResult.Type.MISS && ray.m_82450_().m_7098_() < player.m_146892_().m_7098_();
            return PredicateInfo.builder().condition(isCorrect).build();
        })).stat("multiplier", RelicAbilityStat.builder().initialValue(0.1, 0.5).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_TOTAL, 0.15).formatValue(value -> (int)(MathUtils.round(value, 2) * 100.0)).build()).stat("duration", RelicAbilityStat.builder().initialValue(4.0, 6.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round(value, 1)).build()).stat("cooldown", RelicAbilityStat.builder().initialValue(15.0, 12.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_TOTAL, -0.1).formatValue(value -> MathUtils.round(value, 1)).build()).build()).ability("agility", RelicAbilityEntry.builder().requiredLevel(10).requiredPoints(2).maxLevel(5).stat("modifier", RelicAbilityStat.builder().initialValue(1.0, 1.0).upgradeModifier(RelicAbilityStat.Operation.ADD, 1.0).formatValue(value -> (int)(1.0 + MathUtils.round(value, 0)) * 100).build()).build()).ability("rain", RelicAbilityEntry.builder().requiredLevel(15).maxLevel(10).active(AbilityCastType.INSTANTANEOUS, AbilityCastPredicate.builder().predicate("arrow", data -> {
            int count = 0;
            for (ItemStack stack : ArrowQuiverItem.getArrows(data.getStack())) {
                count += stack.m_41613_();
            }
            return PredicateInfo.builder().condition(count > 0).build();
        })).stat("radius", RelicAbilityStat.builder().initialValue(3.0, 5.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.15).formatValue(value -> MathUtils.round(value, 1)).build()).stat("duration", RelicAbilityStat.builder().initialValue(10.0, 15.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.25).formatValue(value -> MathUtils.round(value, 1)).build()).stat("delay", RelicAbilityStat.builder().initialValue(1.0, 0.75).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_TOTAL, -0.15).formatValue(value -> MathUtils.round(value, 2)).build()).build()).build()).levelingData(new RelicLevelingData(100, 20, 100)).styleData(RelicStyleData.builder().borders("#eed551", "#dcbe1d").build()).build();
    }

    @Override
    public void castActiveAbility(ItemStack stack, Player player, String ability, AbilityCastType type, AbilityCastStage stage) {
        BlockHitResult ray;
        Vec3 eyeVec;
        Vec3 view;
        double maxDistance;
        Level level = player.m_20193_();
        RandomSource random = level.m_213780_();
        if (ability.equals("rain")) {
            if (ArrowQuiverItem.getArrows(stack).isEmpty()) {
                return;
            }
            maxDistance = 32.0;
            view = player.m_20252_(0.0f);
            eyeVec = player.m_20299_(0.0f);
            ray = level.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * maxDistance, view.f_82480_ * maxDistance, view.f_82481_ * maxDistance), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
            Vec3 target = ray.m_82450_();
            int duration = (int)Math.round(AbilityUtils.getAbilityValue(stack, "rain", "duration") * 20.0);
            ArrowRainEntity rain = new ArrowRainEntity((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.ARROW_RAIN.get()), level);
            rain.setDelay((int)Math.round(AbilityUtils.getAbilityValue(stack, "rain", "delay") * 20.0));
            rain.setRadius((float)AbilityUtils.getAbilityValue(stack, "rain", "radius"));
            rain.setQuiver(stack.m_41777_());
            rain.setDuration(duration);
            rain.m_5602_((Entity)player);
            rain.m_146884_(target);
            level.m_7967_((Entity)rain);
            AbilityUtils.setAbilityCooldown(stack, "rain", duration);
        }
        if (ability.equals(TAG_LEAP)) {
            maxDistance = player.getBlockReach() + 1.0;
            view = player.m_20252_(0.0f);
            eyeVec = player.m_20299_(0.0f);
            ray = level.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * maxDistance, view.f_82480_ * maxDistance, view.f_82481_ * maxDistance), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
            if (ray.m_6662_() != HitResult.Type.MISS && ray.m_82450_().m_7098_() < player.m_146892_().m_7098_()) {
                Vec3 motion = player.m_20154_().m_82490_(-1.0).m_82541_().m_82490_(2.0);
                for (int i = 0; i < 100; ++i) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123764_, player.m_20185_(), player.m_20186_(), player.m_20189_(), motion.m_7096_() + (double)(MathUtils.randomFloat(random) * 0.1f), motion.m_7098_() + (double)(MathUtils.randomFloat(random) * 0.25f), motion.m_7094_() + (double)(MathUtils.randomFloat(random) * 0.1f));
                }
                if (!level.m_5776_()) {
                    NetworkHandler.sendToClient(new PacketPlayerMotion(motion.f_82479_, motion.f_82480_, motion.f_82481_), (ServerPlayer)player);
                    NBTUtils.setInt(stack, TAG_LEAP, 0);
                    AbilityUtils.setAbilityCooldown(stack, TAG_LEAP, (int)Math.round(AbilityUtils.getAbilityValue(stack, TAG_LEAP, "cooldown") * 20.0));
                    level.m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.LEAP.get(), SoundSource.MASTER, 1.0f, 1.0f + random.m_188501_() * 0.5f);
                }
            }
        }
    }

    @Override
    public void tickActiveAbilitySelection(ItemStack stack, Player player, String ability) {
        Level level = player.m_20193_();
        if (ability.equals("rain")) {
            double maxDistance = 32.0;
            Vec3 view = player.m_20252_(0.0f);
            Vec3 eyeVec = player.m_20299_(0.0f);
            BlockHitResult ray = level.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * maxDistance, view.f_82480_ * maxDistance, view.f_82481_ * maxDistance), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
            Vec3 target = ray.m_82450_();
            ParticleUtils.createCyl(new CircleTintData(new Color(255, 255, 255), 0.2f, 0, 1.0f, false), target, level, AbilityUtils.getAbilityValue(stack, "rain", "radius"), 0.2f);
        }
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        int leap;
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Level level = player.m_9236_();
        if (AbilityUtils.canUseAbility(stack, TAG_LEAP) && (leap = NBTUtils.getInt(stack, TAG_LEAP, -1)) >= 0) {
            if (!level.m_5776_()) {
                NBTUtils.setInt(stack, TAG_LEAP, ++leap);
                player.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.VANISHING.get(), 5, 0, false, false));
                player.f_19789_ = 0.0f;
                if (leap >= 5 && (player.m_20096_() || player.m_150110_().f_35935_ || player.m_21255_() || player.m_20069_() || player.m_20077_() || (double)leap >= AbilityUtils.getAbilityValue(stack, TAG_LEAP, "duration") * 20.0)) {
                    NBTUtils.clearTag(stack, TAG_LEAP);
                }
            }
            if (player.m_6117_() && player.m_21205_().m_41720_() instanceof BowItem) {
                player.m_20256_(player.m_20184_().m_82542_((double)0.975f, player.m_20184_().m_7098_() > 0.0 ? (double)0.9f : 0.0, (double)0.975f));
            }
        }
        if (AbilityUtils.canUseAbility(stack, "agility") && player.m_6117_() && player.m_21205_().m_41720_() instanceof BowItem) {
            for (int i = 0; i < 1; ++i) {
                player.m_21329_();
            }
        }
    }

    public static int getSlotsAmount(ItemStack stack) {
        return (int)Math.round(AbilityUtils.getAbilityValue(stack, "receptacle", "slots"));
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        return Optional.of(new ArrowQuiverTooltip(ArrowQuiverItem.getArrows(stack), ArrowQuiverItem.getSlotsAmount(stack)));
    }

    public static List<ItemStack> getArrows(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag == null ? new ArrayList<ItemStack>() : tag.m_128437_(TAG_ARROWS, 10).stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_).collect(Collectors.toList());
    }

    public static int insertStack(ItemStack stack, ItemStack arrow) {
        if (!arrow.m_41720_().m_142095_()) {
            return 0;
        }
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(TAG_ARROWS)) {
            tag.m_128365_(TAG_ARROWS, (Tag)new ListTag());
        }
        ListTag list = tag.m_128437_(TAG_ARROWS, 10);
        List<CompoundTag> entries = list.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).filter(nbt -> ItemStack.m_150942_((ItemStack)ItemStack.m_41712_((CompoundTag)nbt), (ItemStack)arrow)).filter(nbt -> {
            ItemStack item = ItemStack.m_41712_((CompoundTag)nbt);
            return item.m_41613_() < item.m_41741_();
        }).toList();
        int amount = 0;
        if (!entries.isEmpty()) {
            for (CompoundTag entry : entries) {
                ItemStack s = ItemStack.m_41712_((CompoundTag)entry);
                int count = s.m_41613_() + arrow.m_41613_();
                if (count <= s.m_41741_()) {
                    arrow.m_41764_(0);
                    s.m_41769_(amount += arrow.m_41613_());
                    s.m_41739_(entry);
                    list.remove((Object)entry);
                    list.add(0, (Tag)entry);
                    break;
                }
                int step = s.m_41741_() - s.m_41613_();
                amount += step;
                arrow.m_41774_(step);
                s.m_41769_(step);
                s.m_41739_(entry);
                list.remove((Object)entry);
                list.add(0, (Tag)entry);
            }
        }
        if (!arrow.m_41619_()) {
            if (ArrowQuiverItem.getSlotsAmount(stack) <= ArrowQuiverItem.getArrows(stack).size()) {
                return 0;
            }
            amount += arrow.m_41613_();
            CompoundTag entry = new CompoundTag();
            arrow.m_41777_().m_41739_(entry);
            list.add(0, (Tag)entry);
        }
        return amount;
    }

    public static Optional<ItemStack> takeStack(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(TAG_ARROWS)) {
            return Optional.empty();
        }
        ListTag list = tag.m_128437_(TAG_ARROWS, 10);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        ItemStack s = ItemStack.m_41712_((CompoundTag)list.m_128728_(0));
        list.remove(0);
        if (list.isEmpty()) {
            stack.m_41749_(TAG_ARROWS);
        }
        return Optional.of(s);
    }

    public static void takeArrow(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(TAG_ARROWS)) {
            return;
        }
        ListTag list = tag.m_128437_(TAG_ARROWS, 10);
        if (list.isEmpty()) {
            return;
        }
        CompoundTag entry = list.m_128728_(0);
        ItemStack s = ItemStack.m_41712_((CompoundTag)entry);
        s.m_41774_(1);
        s.m_41739_(entry);
        list.remove(0);
        if (!s.m_41619_()) {
            list.add(0, (Tag)entry);
        }
        if (list.isEmpty()) {
            stack.m_41749_(TAG_ARROWS);
        }
    }

    public record ArrowQuiverTooltip(List<ItemStack> items, int maxAmount) implements TooltipComponent
    {
        public List<ItemStack> getItems() {
            return this.items;
        }

        public int getMaxAmount() {
            return this.maxAmount;
        }
    }

    @Mod.EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onSlotClick(ContainerSlotClickEvent event) {
            Player player = event.getEntity();
            ItemStack heldStack = event.getHeldStack();
            ItemStack slotStack = event.getSlotStack();
            if (slotStack.m_41720_() != ItemRegistry.ARROW_QUIVER.get() || !AbilityUtils.canUseAbility(slotStack, "receptacle")) {
                return;
            }
            if (event.getAction() == ClickAction.PRIMARY) {
                if (!(heldStack.m_41720_() instanceof ArrowItem)) {
                    return;
                }
                int amount = ArrowQuiverItem.insertStack(slotStack, heldStack);
                if (amount <= 0) {
                    return;
                }
                heldStack.m_41774_(amount);
                player.m_5496_(SoundEvents.f_184215_, 1.0f, 1.0f);
                event.setCanceled(true);
            } else {
                if (!heldStack.m_41619_()) {
                    return;
                }
                ArrowQuiverItem.takeStack(slotStack).ifPresent(stack -> {
                    event.getContainer().m_142503_(stack);
                    player.m_5496_(SoundEvents.f_184216_, 1.0f, 1.0f);
                    event.setCanceled(true);
                });
            }
        }

        @SubscribeEvent
        public static void onArrowLoose(ArrowLooseEvent event) {
            Player player = event.getEntity();
            ItemStack relic = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.ARROW_QUIVER.get());
            if (relic.m_41619_() || !AbilityUtils.canUseAbility(relic, "receptacle") || ArrowQuiverItem.getArrows(relic).isEmpty() || player.m_7500_()) {
                return;
            }
            ArrowQuiverItem.takeArrow(relic);
        }

        @SubscribeEvent
        public static void onGettingProjectile(LivingGetProjectileEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            ItemStack weapon = event.getProjectileWeaponItemStack();
            if (!(weapon.m_41720_() instanceof BowItem) || weapon.m_41720_() instanceof CrossbowItem) {
                return;
            }
            ItemStack relic = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.ARROW_QUIVER.get());
            if (relic.m_41619_() || !AbilityUtils.canUseAbility(relic, "receptacle")) {
                return;
            }
            List<ItemStack> arrows = ArrowQuiverItem.getArrows(relic);
            if (!arrows.isEmpty()) {
                event.setProjectileItemStack(arrows.get(0));
            }
        }

        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            int amount;
            AbstractArrow arrow;
            Entity entity = event.getSource().m_7640_();
            if (!(entity instanceof AbstractArrow) || !((entity = (arrow = (AbstractArrow)entity).m_19749_()) instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.ARROW_QUIVER.get());
            if (stack.m_41619_()) {
                return;
            }
            if (AbilityUtils.canUseAbility(stack, "receptacle") && (amount = (int)Math.min(10L, Math.round(player.m_20182_().m_82554_(new Vec3(arrow.m_20185_(), player.m_20186_(), arrow.m_20189_())) * 0.1))) > 0) {
                LevelingUtils.addExperience((Entity)player, stack, amount);
            }
            if (AbilityUtils.canUseAbility(stack, ArrowQuiverItem.TAG_LEAP) && arrow.getPersistentData().m_128441_("arrow_quiver_multiplier")) {
                event.setAmount((float)((double)event.getAmount() + (double)event.getAmount() * AbilityUtils.getAbilityValue(stack, ArrowQuiverItem.TAG_LEAP, "multiplier")));
            }
        }

        @SubscribeEvent
        public static void onEntitySpawned(EntityJoinLevelEvent event) {
            Player player;
            AbstractArrow arrow;
            block7: {
                block6: {
                    Entity entity;
                    if (event.getLevel().m_5776_() || !((entity = event.getEntity()) instanceof AbstractArrow) || !((entity = (arrow = (AbstractArrow)entity).m_19749_()) instanceof Player)) break block6;
                    player = (Player)entity;
                    if (!(arrow.m_20182_().m_82554_(player.m_20182_()) > 16.0) && arrow.f_36697_ <= 0) break block7;
                }
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.ARROW_QUIVER.get());
            if (stack.m_41619_() || !AbilityUtils.canUseAbility(stack, ArrowQuiverItem.TAG_LEAP) || NBTUtils.getInt(stack, ArrowQuiverItem.TAG_LEAP, -1) < 0) {
                return;
            }
            NBTUtils.clearTag(stack, ArrowQuiverItem.TAG_LEAP);
            if (!arrow.m_36792_()) {
                return;
            }
            Level level = player.m_20193_();
            level.m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.POWERED_ARROW.get(), SoundSource.MASTER, 1.0f, 1.0f + player.m_217043_().m_188501_() * 0.5f);
            arrow.getPersistentData().m_128379_("arrow_quiver_multiplier", true);
            arrow.m_20242_(true);
            Vec3 motion = player.m_20154_().m_82490_(-1.0).m_82541_();
            if (!level.m_5776_()) {
                NetworkHandler.sendToClient(new PacketPlayerMotion(motion.f_82479_, motion.f_82480_, motion.f_82481_), (ServerPlayer)player);
            }
        }

        @SubscribeEvent
        public static void onProjectileImpact(ProjectileImpactEvent event) {
            AbstractArrow arrow;
            Entity entity;
            if (event.getRayTraceResult().m_6662_() != HitResult.Type.BLOCK || !((entity = event.getEntity()) instanceof AbstractArrow) || !((entity = (arrow = (AbstractArrow)entity).m_19749_()) instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.ARROW_QUIVER.get());
            if (stack.m_41619_() || !AbilityUtils.canUseAbility(stack, ArrowQuiverItem.TAG_LEAP)) {
                return;
            }
            CompoundTag data = arrow.getPersistentData();
            if (data.m_128441_("arrow_quiver_multiplier")) {
                data.m_128473_("arrow_quiver_multiplier");
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record ClientArrowQuiverTooltip(ArrowQuiverTooltip tooltip) implements ClientTooltipComponent
    {
        public static final ResourceLocation TEXTURE = new ResourceLocation("relics", "textures/gui/tooltip/arrow_quiver/empty_arrow.png");

        public int m_142103_() {
            return 26;
        }

        public int m_142069_(Font font) {
            return this.tooltip.getMaxAmount() * 11;
        }

        public void m_183452_(Font font, int mouseX, int mouseY, GuiGraphics guiGraphics) {
            Minecraft MC = Minecraft.m_91087_();
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 410.0f);
            int step = 0;
            for (ItemStack stack : this.tooltip.getItems()) {
                guiGraphics.m_280480_(stack, mouseX + step, mouseY);
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                guiGraphics.m_280488_(MC.f_91062_, String.valueOf(stack.m_41613_()), (mouseX + step) * 2 + (16 - font.m_92895_(String.valueOf(stack.m_41613_()))) / 2, (mouseY + 16) * 2, 0xFFFFFF);
                poseStack.m_85841_(2.0f, 2.0f, 2.0f);
                step += 10;
            }
            for (int i = step / 10; i < this.tooltip.getMaxAmount(); ++i) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
                Minecraft.m_91087_().m_91097_().m_118506_(TEXTURE).m_117966_();
                guiGraphics.m_280411_(TEXTURE, mouseX + step, mouseY, 16, 16, 0.0f, 0.0f, 16, 16, 16, 16);
                step += 10;
            }
            poseStack.m_252880_(0.0f, 0.0f, -410.0f);
            poseStack.m_85849_();
        }

        public ArrowQuiverTooltip getTooltip() {
            return this.tooltip;
        }
    }
}

