/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import it.hurts.sskirillss.relics.client.particles.circle.CircleTintData;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.entities.DissectionEntity;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.items.relics.base.utils.AbilityUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.LevelingUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.UUID;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;

public class SpaceDissectorItem
extends RelicItem {
    public static final String TAG_PORTAL = "portal";

    @Override
    public RelicData constructRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("dissection", RelicAbilityEntry.builder().stat("distance", RelicAbilityStat.builder().initialValue(16.0, 32.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.25).formatValue(value -> MathUtils.round(value, 1)).build()).stat("time", RelicAbilityStat.builder().initialValue(5.0, 10.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.5).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).levelingData(new RelicLevelingData(100, 10, 200)).styleData(RelicStyleData.builder().borders("#008cd7", "#0a3484").build()).build();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand handIn) {
        ItemStack stack = player.m_21120_(handIn);
        String stringUUID = NBTUtils.getString(stack, TAG_PORTAL, "");
        if (!stringUUID.isEmpty()) {
            UUID uuid = UUID.fromString(stringUUID);
            if (!world.m_5776_()) {
                ServerLevel serverLevel = (ServerLevel)world;
                DissectionEntity startPortal = (DissectionEntity)serverLevel.m_8791_(uuid);
                if (startPortal != null) {
                    startPortal.setLifeTime(20);
                } else {
                    LevelingUtils.addExperience((Entity)player, stack, 1);
                }
            }
        } else {
            LevelingUtils.addExperience((Entity)player, stack, 1);
        }
        Vec3 view = player.m_20252_(0.0f);
        Vec3 eyeVec = player.m_20299_(0.0f);
        float distance = Math.round(AbilityUtils.getAbilityValue(stack, "dissection", "distance"));
        BlockHitResult ray = world.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * (double)distance, view.f_82480_ * (double)distance, view.f_82481_ * (double)distance), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        DissectionEntity portal = new DissectionEntity(world);
        int time = (int)Math.round(AbilityUtils.getAbilityValue(stack, "dissection", "time")) * 20;
        portal.m_146884_(ray.m_82450_());
        portal.setMaxLifeTime(time);
        portal.setLifeTime(time);
        portal.setMaster(true);
        world.m_7967_((Entity)portal);
        NBTUtils.setString(stack, TAG_PORTAL, portal.m_20149_());
        player.m_6672_(handIn);
        return super.m_7203_(world, player, handIn);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity pLivingEntity, int pTimeCharged) {
        if (!(pLivingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)pLivingEntity;
        Vec3 view = player.m_20252_(0.0f);
        Vec3 eyeVec = player.m_20299_(0.0f);
        float distance = Math.round(AbilityUtils.getAbilityValue(stack, "dissection", "distance"));
        BlockHitResult ray = world.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * (double)distance, view.f_82480_ * (double)distance, view.f_82481_ * (double)distance), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        Vec3 targetVec = ray.m_82450_();
        String stringUUID = NBTUtils.getString(stack, TAG_PORTAL, "");
        if (stringUUID.isEmpty()) {
            return;
        }
        UUID uuid = UUID.fromString(stringUUID);
        if (world.m_5776_()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        DissectionEntity startPortal = (DissectionEntity)serverLevel.m_8791_(uuid);
        if (startPortal == null) {
            return;
        }
        DissectionEntity endPortal = new DissectionEntity(world);
        endPortal.m_146884_(targetVec);
        endPortal.setMaster(false);
        world.m_7967_((Entity)endPortal);
        startPortal.setPair(endPortal);
        endPortal.setPair(startPortal);
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int count) {
        RandomSource random = level.m_213780_();
        Vec3 view = entity.m_20252_(0.0f);
        Vec3 eyeVec = entity.m_20299_(0.0f);
        float distance = Math.round(AbilityUtils.getAbilityValue(stack, "dissection", "distance"));
        BlockHitResult ray = level.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * (double)distance, view.f_82480_ * (double)distance, view.f_82481_ * (double)distance), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)entity));
        Vec3 targetVec = ray.m_82450_();
        ParticleUtils.createBall(new CircleTintData(new Color(150 + random.m_188503_(100), 100, 0), 0.2f + random.m_188501_() * 0.1f, 10 + random.m_188503_(20), 0.9f, true), targetVec, level, 1, 0.25f);
        String stringUUID = NBTUtils.getString(stack, TAG_PORTAL, "");
        if (stringUUID.isEmpty()) {
            return;
        }
        UUID uuid = UUID.fromString(stringUUID);
        if (level.m_5776_()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        DissectionEntity startPortal = (DissectionEntity)serverLevel.m_8791_(uuid);
        if (startPortal == null) {
            return;
        }
        startPortal.m_7618_(EntityAnchorArgument.Anchor.FEET, targetVec);
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    @Override
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }
}

