/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.items.relics.base.utils.AbilityUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.LevelingUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;

public class HorseFluteItem
extends RelicItem {
    public static final String TAG_ENTITY = "entity";
    private static final String TAG_UUID = "uuid";

    @Override
    public RelicData constructRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("paddock", RelicAbilityEntry.builder().maxLevel(0).build()).ability("heal", RelicAbilityEntry.builder().requiredLevel(5).stat("amount", RelicAbilityStat.builder().initialValue(0.01, 0.1).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 1.0).formatValue(value -> MathUtils.round(value, 2)).build()).build()).build()).levelingData(new RelicLevelingData(100, 10, 100)).styleData(RelicStyleData.builder().borders("#eed551", "#dcbe1d").build()).build();
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (!(entity instanceof AbstractHorse)) {
            return InteractionResult.FAIL;
        }
        AbstractHorse horse = (AbstractHorse)entity;
        CompoundTag nbt = stack.m_41737_(TAG_ENTITY);
        if (nbt != null) {
            this.releaseHorse(stack, (Entity)player);
            this.catchHorse(horse, (Entity)player, stack);
            return InteractionResult.SUCCESS;
        }
        this.catchHorse(horse, (Entity)player, stack);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        CompoundTag nbt = stack.m_41737_(TAG_ENTITY);
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (nbt == null) {
            if (player.m_6144_()) {
                NBTUtils.clearTag(stack, TAG_UUID);
            } else {
                this.catchHorse(stack, (Entity)player);
            }
            return InteractionResult.SUCCESS;
        }
        this.releaseHorse(stack, (Entity)player);
        if (player.m_6144_()) {
            NBTUtils.clearTag(stack, TAG_UUID);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag nbt = stack.m_41737_(TAG_ENTITY);
        if (nbt == null) {
            if (player.m_6144_()) {
                NBTUtils.clearTag(stack, TAG_UUID);
            } else {
                this.catchHorse(stack, (Entity)player);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        this.releaseHorse(stack, (Entity)player);
        if (player.m_6144_()) {
            NBTUtils.clearTag(stack, TAG_UUID);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    @Override
    public void m_6883_(ItemStack stack, Level level, Entity entityIn, int itemSlot, boolean isSelected) {
        AbstractHorse horse;
        if (entityIn.f_19797_ % 20 == 0 && (horse = this.decodeHorseData(stack, level)) != null && AbilityUtils.canUseAbility(stack, "heal")) {
            horse.m_5634_((float)AbilityUtils.getAbilityValue(stack, "heal", "amount"));
            CompoundTag nbt = new CompoundTag();
            horse.m_20223_(nbt);
            stack.m_41700_(TAG_ENTITY, (Tag)nbt);
        }
        if ((horse = this.findHorse(level, stack)) != null && entityIn.m_20270_((Entity)horse) > 16.0f) {
            this.catchHorse(horse, entityIn, stack);
        }
    }

    @Nullable
    private AbstractHorse findHorse(Level world, ItemStack stack) {
        if (world.m_5776_()) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        String uuid = NBTUtils.getString(stack, TAG_UUID, "");
        if (uuid.equals("")) {
            return null;
        }
        Entity entity = serverLevel.m_8791_(UUID.fromString(uuid));
        return entity instanceof AbstractHorse ? (AbstractHorse)entity : null;
    }

    public void catchHorse(AbstractHorse horse, Entity player, ItemStack stack) {
        if (horse.m_21224_() || horse.m_21805_() != null && !horse.m_21805_().equals(player.m_20148_()) || horse.m_21805_() == null && !horse.m_30614_()) {
            return;
        }
        Level world = horse.m_20193_();
        CompoundTag nbt = new CompoundTag();
        Vec3 pos = horse.m_20182_();
        if (NBTUtils.getString(stack, TAG_UUID, "").equals(horse.m_20148_().toString()) && horse.f_19787_ > 25.0f) {
            LevelingUtils.addExperience(player, stack, Math.round(horse.f_19787_ / 25.0f));
            horse.f_19787_ = 0.0f;
        }
        horse.m_20223_(nbt);
        NBTUtils.setCompound(stack, TAG_ENTITY, nbt);
        NBTUtils.clearTag(stack, TAG_UUID);
        horse.m_142687_(Entity.RemovalReason.KILLED);
        if (!world.m_5776_()) {
            ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123813_, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        world.m_5594_(null, horse.m_20183_(), SoundEvents.f_11752_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void catchHorse(ItemStack stack, Entity player) {
        Level world = player.m_20193_();
        AbstractHorse horse = this.findHorse(world, stack);
        if (horse != null) {
            this.catchHorse(horse, player, stack);
        }
    }

    public void releaseHorse(ItemStack stack, Entity player) {
        Level world = player.m_20193_();
        Vec3 pos = player.m_20182_();
        AbstractHorse horse = this.decodeHorseData(stack, world);
        if (horse == null) {
            return;
        }
        horse.m_6034_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
        world.m_7967_((Entity)horse);
        horse.m_20256_(player.m_20252_(1.0f).m_82541_());
        horse.f_19789_ = 0.0f;
        NBTUtils.clearTag(stack, TAG_ENTITY);
        NBTUtils.setString(stack, TAG_UUID, horse.m_20148_().toString());
        if (!world.m_5776_()) {
            ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123813_, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        world.m_5594_(null, horse.m_20183_(), SoundEvents.f_11696_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Nullable
    private AbstractHorse decodeHorseData(ItemStack stack, Level level) {
        CompoundTag data = stack.m_41783_();
        if (data == null) {
            return null;
        }
        Optional type = EntityType.m_20637_((CompoundTag)data.m_128469_(TAG_ENTITY));
        if (type.isEmpty()) {
            return null;
        }
        Entity entity = ((EntityType)type.get()).m_20615_(level);
        if (!(entity instanceof AbstractHorse)) {
            return null;
        }
        AbstractHorse horse = (AbstractHorse)entity;
        horse.m_20258_(data.m_128469_(TAG_ENTITY));
        return horse;
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41737_(TAG_ENTITY) != null;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @Override
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }
}

