/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.init;

import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.hud.abilities.AbilitiesRenderHandler;
import it.hurts.sskirillss.relics.client.models.items.back.MidnightRobeModel;
import it.hurts.sskirillss.relics.client.models.items.belt.DrownedBeltModel;
import it.hurts.sskirillss.relics.client.models.items.belt.HunterBeltModel;
import it.hurts.sskirillss.relics.client.models.items.belt.LeatherBeltModel;
import it.hurts.sskirillss.relics.client.models.items.necklace.HolyLocketModel;
import it.hurts.sskirillss.relics.client.models.items.necklace.JellyfishNecklaceModel;
import it.hurts.sskirillss.relics.client.models.items.necklace.ReflectionNecklaceModel;
import it.hurts.sskirillss.relics.client.particles.circle.CircleTintFactory;
import it.hurts.sskirillss.relics.client.particles.spark.SparkTintFactory;
import it.hurts.sskirillss.relics.client.renderer.entities.BlockSimulationRenderer;
import it.hurts.sskirillss.relics.client.renderer.entities.DissectionRenderer;
import it.hurts.sskirillss.relics.client.renderer.entities.NullRenderer;
import it.hurts.sskirillss.relics.client.renderer.entities.ShadowGlaiveRenderer;
import it.hurts.sskirillss.relics.client.renderer.entities.ShadowSawRenderer;
import it.hurts.sskirillss.relics.client.renderer.entities.SolidSnowballRenderer;
import it.hurts.sskirillss.relics.client.renderer.entities.SporeRenderer;
import it.hurts.sskirillss.relics.client.renderer.entities.StalactiteRenderer;
import it.hurts.sskirillss.relics.client.renderer.items.items.back.MidnightRobeRenderer;
import it.hurts.sskirillss.relics.client.renderer.items.items.belt.DrownedBeltRenderer;
import it.hurts.sskirillss.relics.client.renderer.items.items.belt.HunterBeltRenderer;
import it.hurts.sskirillss.relics.client.renderer.items.items.belt.LeatherBeltRenderer;
import it.hurts.sskirillss.relics.client.renderer.items.items.necklace.HolyLocketRenderer;
import it.hurts.sskirillss.relics.client.renderer.items.items.necklace.JellyfishNecklaceRenderer;
import it.hurts.sskirillss.relics.client.renderer.items.items.necklace.ReflectionNecklaceRenderer;
import it.hurts.sskirillss.relics.client.renderer.tiles.ResearchingTableRenderer;
import it.hurts.sskirillss.relics.init.BlockRegistry;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.init.ParticleRegistry;
import it.hurts.sskirillss.relics.init.TileRegistry;
import it.hurts.sskirillss.relics.items.relics.back.ArrowQuiverItem;
import it.hurts.sskirillss.relics.items.relics.base.utils.AbilityUtils;
import it.hurts.sskirillss.relics.tiles.base.IHasHUDInfo;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@Mod.EventBusSubscriber(modid="relics", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class RemoteRegistry {
    @SubscribeEvent
    public static void setupClient(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.RESEARCHING_TABLE.get()), (RenderType)RenderType.m_110463_());
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)ItemRegistry.INFINITY_HAM.get()), (ResourceLocation)new ResourceLocation("relics", "pieces"), (stack, world, entity, id) -> Math.min(10, NBTUtils.getInt(stack, "pieces", 0)));
            ItemProperties.register((Item)((Item)ItemRegistry.SHADOW_GLAIVE.get()), (ResourceLocation)new ResourceLocation("relics", "charges"), (stack, world, entity, id) -> Math.min(8, NBTUtils.getInt(stack, "charges", 0)));
            ItemProperties.register((Item)((Item)ItemRegistry.MAGIC_MIRROR.get()), (ResourceLocation)new ResourceLocation("relics", "world"), (stack, world, entity, id) -> {
                Entity e = Minecraft.m_91087_().m_91288_();
                if (e == null) {
                    return 0.0f;
                }
                return switch (e.m_20193_().m_46472_().m_135782_().m_135815_()) {
                    case "overworld" -> 1.0f;
                    case "the_nether" -> 2.0f;
                    case "the_end" -> 3.0f;
                    default -> 0.0f;
                };
            });
            ItemProperties.register((Item)((Item)ItemRegistry.SHADOW_GLAIVE.get()), (ResourceLocation)new ResourceLocation("relics", "charges"), (stack, world, entity, id) -> Math.min(8, NBTUtils.getInt(stack, "charges", 0)));
            ItemProperties.register((Item)((Item)ItemRegistry.MAGMA_WALKER.get()), (ResourceLocation)new ResourceLocation("relics", "heat"), (stack, world, entity, id) -> {
                int maxHeat;
                int heat = NBTUtils.getInt(stack, "heat", 0);
                return heat > (maxHeat = (int)Math.round(AbilityUtils.getAbilityValue(stack, "pace", "heat"))) ? 4.0f : (float)((int)Math.floor((float)heat / ((float)maxHeat / 4.0f)));
            });
            ItemProperties.register((Item)((Item)ItemRegistry.AQUA_WALKER.get()), (ResourceLocation)new ResourceLocation("relics", "drench"), (stack, world, entity, id) -> {
                int drench = NBTUtils.getInt(stack, "drench", 0);
                return (int)Math.floor((double)drench / (AbilityUtils.getAbilityValue(stack, "walking", "time") / 4.0));
            });
            ItemProperties.register((Item)((Item)ItemRegistry.ARROW_QUIVER.get()), (ResourceLocation)new ResourceLocation("relics", "fullness"), (stack, world, entity, id) -> {
                int maxAmount = ArrowQuiverItem.getSlotsAmount(stack);
                int amount = ArrowQuiverItem.getArrows(stack).size();
                return amount > 0 ? (float)((int)Math.floor((float)amount / ((float)maxAmount / 2.0f)) + 1) : 0.0f;
            });
            ItemProperties.register((Item)((Item)ItemRegistry.ELYTRA_BOOSTER.get()), (ResourceLocation)new ResourceLocation("relics", "fuel"), (stack, world, entity, id) -> {
                int fuel = NBTUtils.getInt(stack, "fuel", 0);
                return (int)Math.ceil((double)fuel / (AbilityUtils.getAbilityValue(stack, "boost", "capacity") / 5.0));
            });
            ItemProperties.register((Item)((Item)ItemRegistry.SOLID_SNOWBALL.get()), (ResourceLocation)new ResourceLocation("relics", "snow"), (stack, world, entity, id) -> {
                ItemStack relic = EntityUtils.findEquippedCurio((Entity)entity, (Item)ItemRegistry.WOOL_MITTEN.get());
                return (int)Math.floor((double)NBTUtils.getInt(stack, "snow", 0) / (AbilityUtils.getAbilityValue(relic, "mold", "size") / 3.0));
            });
            ItemProperties.register((Item)((Item)ItemRegistry.ROLLER_SKATES.get()), (ResourceLocation)new ResourceLocation("relics", "active"), (stack, world, entity, id) -> NBTUtils.getInt(stack, "duration", 0) > 0 ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ItemRegistry.BLAZING_FLASK.get()), (ResourceLocation)new ResourceLocation("relics", "active"), (stack, world, entity, id) -> NBTUtils.getString(stack, "pos", "").isEmpty() ? 0.0f : 1.0f);
        });
        CuriosRendererRegistry.register((Item)((Item)ItemRegistry.DROWNED_BELT.get()), DrownedBeltRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)ItemRegistry.HUNTER_BELT.get()), HunterBeltRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)ItemRegistry.LEATHER_BELT.get()), LeatherBeltRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)ItemRegistry.HOLY_LOCKET.get()), HolyLocketRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)ItemRegistry.REFLECTION_NECKLACE.get()), ReflectionNecklaceRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)ItemRegistry.JELLYFISH_NECKLACE.get()), JellyfishNecklaceRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)ItemRegistry.MIDNIGHT_ROBE.get()), MidnightRobeRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(DrownedBeltModel.LAYER, DrownedBeltModel::createLayer);
        event.registerLayerDefinition(HunterBeltModel.LAYER, HunterBeltModel::createLayer);
        event.registerLayerDefinition(LeatherBeltModel.LAYER, LeatherBeltModel::createLayer);
        event.registerLayerDefinition(HolyLocketModel.LAYER, HolyLocketModel::createLayer);
        event.registerLayerDefinition(ReflectionNecklaceModel.LAYER, ReflectionNecklaceModel::createLayer);
        event.registerLayerDefinition(JellyfishNecklaceModel.LAYER, JellyfishNecklaceModel::createLayer);
        event.registerLayerDefinition(MidnightRobeModel.LAYER, MidnightRobeModel::createLayer);
    }

    @SubscribeEvent
    public static void entityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)EntityRegistry.SHADOW_GLAIVE.get(), (EntityRendererProvider)new ShadowGlaiveRenderer.RenderFactory());
        event.registerEntityRenderer((EntityType)EntityRegistry.BLOCK_SIMULATION.get(), (EntityRendererProvider)new BlockSimulationRenderer.RenderFactory());
        event.registerEntityRenderer((EntityType)EntityRegistry.SHOCKWAVE.get(), (EntityRendererProvider)new NullRenderer.RenderFactory());
        event.registerEntityRenderer((EntityType)EntityRegistry.LIFE_ESSENCE.get(), (EntityRendererProvider)new NullRenderer.RenderFactory());
        event.registerEntityRenderer((EntityType)EntityRegistry.STALACTITE.get(), (EntityRendererProvider)new StalactiteRenderer.RenderFactory());
        event.registerEntityRenderer((EntityType)EntityRegistry.DISSECTION.get(), (EntityRendererProvider)new DissectionRenderer.RenderFactory());
        event.registerEntityRenderer((EntityType)EntityRegistry.SPORE.get(), (EntityRendererProvider)new SporeRenderer.RenderFactory());
        event.registerEntityRenderer((EntityType)EntityRegistry.SHADOW_SAW.get(), (EntityRendererProvider)new ShadowSawRenderer.RenderFactory());
        event.registerEntityRenderer((EntityType)EntityRegistry.SOLID_SNOWBALL.get(), (EntityRendererProvider)new SolidSnowballRenderer.RenderFactory());
        event.registerEntityRenderer((EntityType)EntityRegistry.ARROW_RAIN.get(), (EntityRendererProvider)new NullRenderer.RenderFactory());
        event.registerBlockEntityRenderer((BlockEntityType)TileRegistry.RESEARCHING_TABLE.get(), ResearchingTableRenderer::new);
    }

    @SubscribeEvent
    public static void onTooltipRegistry(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(ArrowQuiverItem.ArrowQuiverTooltip.class, ArrowQuiverItem.ClientArrowQuiverTooltip::new);
    }

    @SubscribeEvent
    public static void onParticleRegistry(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ParticleRegistry.CIRCLE_TINT.get(), CircleTintFactory::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.SPARK_TINT.get(), SparkTintFactory::new);
    }

    @SubscribeEvent
    public static void onOverlayRegistry(RegisterGuiOverlaysEvent event) {
        event.registerBelowAll("researching_hint", (forgeGui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
            Minecraft MC = Minecraft.m_91087_();
            ClientLevel level = MC.f_91073_;
            PoseStack poseStack = guiGraphics.m_280168_();
            if (level == null) {
                return;
            }
            HitResult hit = MC.f_91077_;
            if (hit == null || hit.m_6662_() != HitResult.Type.BLOCK) {
                return;
            }
            BlockPos pos = ((BlockHitResult)MC.f_91077_).m_82425_();
            BlockEntity tile = level.m_7702_(pos);
            if (!(tile instanceof IHasHUDInfo)) {
                return;
            }
            IHasHUDInfo infoTile = (IHasHUDInfo)tile;
            infoTile.renderHUDInfo(poseStack, MC.m_91268_());
        });
        event.registerBelowAll("active_abilities", (ForgeGui2, guiGraphics, partialTick, screenWidth, screenHeight) -> AbilitiesRenderHandler.render(guiGraphics, partialTick));
    }
}

