/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.hurts.sskirillss.relics.commands.arguments.RelicAbilityArgument;
import it.hurts.sskirillss.relics.commands.arguments.RelicAbilityStatArgument;
import it.hurts.sskirillss.relics.config.ConfigHelper;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.utils.AbilityUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.LevelingUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.QualityUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.server.command.EnumArgument;

public class RelicsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"relics").requires(sender -> sender.m_6761_(2))).then(Commands.m_82127_((String)"config").then(Commands.m_82127_((String)"reload").executes(context -> {
            ConfigHelper.readConfigs();
            return 1;
        })))).then(Commands.m_82127_((String)"level").then(Commands.m_82129_((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (!(stack.m_41720_() instanceof RelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            CommandAction action = (CommandAction)((Object)((Object)context.getArgument("action", CommandAction.class)));
            int level = IntegerArgumentType.getInteger((CommandContext)context, (String)"level");
            switch (action) {
                case SET: {
                    LevelingUtils.setLevel(stack, level);
                    break;
                }
                case ADD: {
                    LevelingUtils.addLevel(stack, level);
                    break;
                }
                case TAKE: {
                    LevelingUtils.addLevel(stack, -level);
                }
            }
            LevelingUtils.setLevel(stack, IntegerArgumentType.getInteger((CommandContext)context, (String)"level"));
            return 1;
        }))))).then(Commands.m_82127_((String)"experience").then(Commands.m_82129_((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.m_82129_((String)"experience", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (!(stack.m_41720_() instanceof RelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            CommandAction action = (CommandAction)((Object)((Object)context.getArgument("action", CommandAction.class)));
            int experience = IntegerArgumentType.getInteger((CommandContext)context, (String)"experience");
            switch (action) {
                case SET: {
                    LevelingUtils.setExperience(stack, experience);
                    break;
                }
                case ADD: {
                    LevelingUtils.addExperience(stack, experience);
                    break;
                }
                case TAKE: {
                    LevelingUtils.addExperience(stack, -experience);
                }
            }
            return 1;
        }))))).then(Commands.m_82127_((String)"points").then(Commands.m_82129_((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.m_82129_((String)"points", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (!(stack.m_41720_() instanceof RelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            CommandAction action = (CommandAction)((Object)((Object)context.getArgument("action", CommandAction.class)));
            int points = IntegerArgumentType.getInteger((CommandContext)context, (String)"points");
            switch (action) {
                case SET: {
                    LevelingUtils.setPoints(stack, points);
                    break;
                }
                case ADD: {
                    LevelingUtils.addPoints(stack, points);
                    break;
                }
                case TAKE: {
                    LevelingUtils.addPoints(stack, -points);
                }
            }
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ability").then(Commands.m_82127_((String)"points").then(Commands.m_82129_((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.m_82129_((String)"ability", (ArgumentType)RelicAbilityArgument.ability()).then(Commands.m_82129_((String)"points", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (!(stack.m_41720_() instanceof RelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            CommandAction action = (CommandAction)((Object)((Object)context.getArgument("action", CommandAction.class)));
            String ability = RelicAbilityArgument.getAbility(context, "ability");
            int points = IntegerArgumentType.getInteger((CommandContext)context, (String)"points");
            if (ability.equals("all")) {
                RelicAbilityData data = AbilityUtils.getRelicAbilityData(stack.m_41720_());
                if (data == null) {
                    return 0;
                }
                for (String entry : data.getAbilities().keySet()) {
                    switch (action) {
                        case SET: {
                            AbilityUtils.setAbilityPoints(stack, entry, points);
                            break;
                        }
                        case ADD: {
                            AbilityUtils.addAbilityPoints(stack, entry, points);
                            break;
                        }
                        case TAKE: {
                            AbilityUtils.addAbilityPoints(stack, entry, -points);
                        }
                    }
                }
            } else {
                switch (action) {
                    case SET: {
                        AbilityUtils.setAbilityPoints(stack, ability, points);
                        break;
                    }
                    case ADD: {
                        AbilityUtils.addAbilityPoints(stack, ability, points);
                        break;
                    }
                    case TAKE: {
                        AbilityUtils.addAbilityPoints(stack, ability, -points);
                    }
                }
            }
            return 1;
        })))))).then(Commands.m_82127_((String)"value").then(Commands.m_82129_((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.m_82129_((String)"ability", (ArgumentType)RelicAbilityArgument.ability()).then(Commands.m_82129_((String)"stat", (ArgumentType)RelicAbilityStatArgument.abilityStat()).then(Commands.m_82129_((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (!(stack.m_41720_() instanceof RelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            CommandAction action = (CommandAction)((Object)((Object)context.getArgument("action", CommandAction.class)));
            String ability = RelicAbilityArgument.getAbility(context, "ability");
            String stat = RelicAbilityStatArgument.getAbilityStat(context, "stat");
            double value = DoubleArgumentType.getDouble((CommandContext)context, (String)"value");
            if (ability.equals("all")) {
                RelicAbilityData data = AbilityUtils.getRelicAbilityData(stack.m_41720_());
                if (data == null) {
                    return 0;
                }
                for (String abilityEntry : data.getAbilities().keySet()) {
                    if (stat.equals("all")) {
                        for (String statEntry : AbilityUtils.getRelicAbilityEntry(stack.m_41720_(), abilityEntry).getStats().keySet()) {
                            switch (action) {
                                case SET: {
                                    AbilityUtils.setAbilityValue(stack, abilityEntry, statEntry, value);
                                    break;
                                }
                                case ADD: {
                                    AbilityUtils.addAbilityValue(stack, abilityEntry, statEntry, value);
                                    break;
                                }
                                case TAKE: {
                                    AbilityUtils.addAbilityValue(stack, abilityEntry, statEntry, -value);
                                }
                            }
                        }
                        continue;
                    }
                    switch (action) {
                        case SET: {
                            AbilityUtils.setAbilityValue(stack, abilityEntry, stat, value);
                            break;
                        }
                        case ADD: {
                            AbilityUtils.addAbilityValue(stack, abilityEntry, stat, value);
                            break;
                        }
                        case TAKE: {
                            AbilityUtils.addAbilityValue(stack, abilityEntry, stat, -value);
                        }
                    }
                }
            } else if (stat.equals("all")) {
                for (String statEntry : AbilityUtils.getRelicAbilityEntry(stack.m_41720_(), ability).getStats().keySet()) {
                    switch (action) {
                        case SET: {
                            AbilityUtils.setAbilityValue(stack, ability, statEntry, value);
                            break;
                        }
                        case ADD: {
                            AbilityUtils.addAbilityValue(stack, ability, statEntry, value);
                            break;
                        }
                        case TAKE: {
                            AbilityUtils.addAbilityValue(stack, ability, statEntry, -value);
                        }
                    }
                }
            } else {
                switch (action) {
                    case SET: {
                        AbilityUtils.setAbilityValue(stack, ability, stat, value);
                        break;
                    }
                    case ADD: {
                        AbilityUtils.addAbilityValue(stack, ability, stat, value);
                        break;
                    }
                    case TAKE: {
                        AbilityUtils.addAbilityValue(stack, ability, stat, -value);
                    }
                }
            }
            return 1;
        }))))))).then(Commands.m_82127_((String)"quality").then(Commands.m_82129_((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.m_82129_((String)"ability", (ArgumentType)RelicAbilityArgument.ability()).then(Commands.m_82129_((String)"stat", (ArgumentType)RelicAbilityStatArgument.abilityStat()).then(Commands.m_82129_((String)"quality", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (!(stack.m_41720_() instanceof RelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            CommandAction action = (CommandAction)((Object)((Object)context.getArgument("action", CommandAction.class)));
            String ability = RelicAbilityArgument.getAbility(context, "ability");
            String stat = RelicAbilityStatArgument.getAbilityStat(context, "stat");
            int quality = IntegerArgumentType.getInteger((CommandContext)context, (String)"quality");
            if (ability.equals("all")) {
                RelicAbilityData data = AbilityUtils.getRelicAbilityData(stack.m_41720_());
                if (data == null) {
                    return 0;
                }
                for (String abilityEntry : data.getAbilities().keySet()) {
                    if (stat.equals("all")) {
                        for (String statEntry : AbilityUtils.getRelicAbilityEntry(stack.m_41720_(), abilityEntry).getStats().keySet()) {
                            double value = QualityUtils.getStatByQuality(stack.m_41720_(), abilityEntry, statEntry, quality);
                            switch (action) {
                                case SET: {
                                    AbilityUtils.setAbilityValue(stack, abilityEntry, statEntry, value);
                                    break;
                                }
                                case ADD: {
                                    AbilityUtils.addAbilityValue(stack, abilityEntry, statEntry, value);
                                    break;
                                }
                                case TAKE: {
                                    AbilityUtils.addAbilityValue(stack, abilityEntry, statEntry, -value);
                                }
                            }
                        }
                        continue;
                    }
                    double value = QualityUtils.getStatByQuality(stack.m_41720_(), abilityEntry, stat, quality);
                    switch (action) {
                        case SET: {
                            AbilityUtils.setAbilityValue(stack, abilityEntry, stat, value);
                            break;
                        }
                        case ADD: {
                            AbilityUtils.addAbilityValue(stack, abilityEntry, stat, value);
                            break;
                        }
                        case TAKE: {
                            AbilityUtils.addAbilityValue(stack, abilityEntry, stat, -value);
                        }
                    }
                }
            } else if (stat.equals("all")) {
                for (String statEntry : AbilityUtils.getRelicAbilityEntry(stack.m_41720_(), ability).getStats().keySet()) {
                    double value = QualityUtils.getStatByQuality(stack.m_41720_(), ability, statEntry, quality);
                    switch (action) {
                        case SET: {
                            AbilityUtils.setAbilityValue(stack, ability, statEntry, value);
                            break;
                        }
                        case ADD: {
                            AbilityUtils.addAbilityValue(stack, ability, statEntry, value);
                            break;
                        }
                        case TAKE: {
                            AbilityUtils.addAbilityValue(stack, ability, statEntry, -value);
                        }
                    }
                }
            } else {
                double value = QualityUtils.getStatByQuality(stack.m_41720_(), ability, stat, quality);
                switch (action) {
                    case SET: {
                        AbilityUtils.setAbilityValue(stack, ability, stat, value);
                        break;
                    }
                    case ADD: {
                        AbilityUtils.addAbilityValue(stack, ability, stat, value);
                        break;
                    }
                    case TAKE: {
                        AbilityUtils.addAbilityValue(stack, ability, stat, -value);
                    }
                }
            }
            return 1;
        }))))))).then(Commands.m_82127_((String)"randomize").then(Commands.m_82129_((String)"ability", (ArgumentType)RelicAbilityArgument.ability()).then(Commands.m_82129_((String)"stat", (ArgumentType)RelicAbilityStatArgument.abilityStat()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (!(stack.m_41720_() instanceof RelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            String ability = RelicAbilityArgument.getAbility(context, "ability");
            String stat = RelicAbilityStatArgument.getAbilityStat(context, "stat");
            if (ability.equals("all")) {
                RelicAbilityData data = AbilityUtils.getRelicAbilityData(stack.m_41720_());
                if (data == null) {
                    return 0;
                }
                for (String abilityEntry : data.getAbilities().keySet()) {
                    if (stat.equals("all")) {
                        for (String statEntry : AbilityUtils.getRelicAbilityEntry(stack.m_41720_(), abilityEntry).getStats().keySet()) {
                            AbilityUtils.randomizeStat(stack, abilityEntry, statEntry);
                        }
                        continue;
                    }
                    AbilityUtils.randomizeStat(stack, abilityEntry, stat);
                }
            } else if (stat.equals("all")) {
                for (String statEntry : AbilityUtils.getRelicAbilityEntry(stack.m_41720_(), ability).getStats().keySet()) {
                    AbilityUtils.randomizeStat(stack, ability, statEntry);
                }
            } else {
                AbilityUtils.randomizeStat(stack, ability, stat);
            }
            return 1;
        }))))));
    }

    public static enum CommandAction {
        SET,
        ADD,
        TAKE;

    }
}

