/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.tooltip.base;

import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class RelicStyleData {
    private List<AbilityTooltip> abilities;
    private String particles;
    private Pair<String, String> borders;

    RelicStyleData(List<AbilityTooltip> abilities, String particles, Pair<String, String> borders) {
        this.abilities = abilities;
        this.particles = particles;
        this.borders = borders;
    }

    public static RelicStyleDataBuilder builder() {
        return new RelicStyleDataBuilder();
    }

    public List<AbilityTooltip> getAbilities() {
        return this.abilities;
    }

    public String getParticles() {
        return this.particles;
    }

    public Pair<String, String> getBorders() {
        return this.borders;
    }

    public void setAbilities(List<AbilityTooltip> abilities) {
        this.abilities = abilities;
    }

    public void setParticles(String particles) {
        this.particles = particles;
    }

    public void setBorders(Pair<String, String> borders) {
        this.borders = borders;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelicStyleData)) {
            return false;
        }
        RelicStyleData other = (RelicStyleData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<AbilityTooltip> this$abilities = this.getAbilities();
        List<AbilityTooltip> other$abilities = other.getAbilities();
        if (this$abilities == null ? other$abilities != null : !((Object)this$abilities).equals(other$abilities)) {
            return false;
        }
        String this$particles = this.getParticles();
        String other$particles = other.getParticles();
        if (this$particles == null ? other$particles != null : !this$particles.equals(other$particles)) {
            return false;
        }
        Pair<String, String> this$borders = this.getBorders();
        Pair<String, String> other$borders = other.getBorders();
        return !(this$borders == null ? other$borders != null : !this$borders.equals(other$borders));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RelicStyleData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<AbilityTooltip> $abilities = this.getAbilities();
        result = result * 59 + ($abilities == null ? 43 : ((Object)$abilities).hashCode());
        String $particles = this.getParticles();
        result = result * 59 + ($particles == null ? 43 : $particles.hashCode());
        Pair<String, String> $borders = this.getBorders();
        result = result * 59 + ($borders == null ? 43 : $borders.hashCode());
        return result;
    }

    public String toString() {
        return "RelicStyleData(abilities=" + this.getAbilities() + ", particles=" + this.getParticles() + ", borders=" + this.getBorders() + ")";
    }

    public static class RelicStyleDataBuilder {
        private ArrayList<AbilityTooltip> abilities;
        private String particles;
        private Pair<String, String> borders;

        public RelicStyleDataBuilder borders(String top, String bottom) {
            this.borders = Pair.of((Object)top, (Object)bottom);
            return this;
        }

        RelicStyleDataBuilder() {
        }

        public RelicStyleDataBuilder ability(AbilityTooltip ability) {
            if (this.abilities == null) {
                this.abilities = new ArrayList();
            }
            this.abilities.add(ability);
            return this;
        }

        public RelicStyleDataBuilder abilities(Collection<? extends AbilityTooltip> abilities) {
            if (abilities == null) {
                throw new NullPointerException("abilities cannot be null");
            }
            if (this.abilities == null) {
                this.abilities = new ArrayList();
            }
            this.abilities.addAll(abilities);
            return this;
        }

        public RelicStyleDataBuilder clearAbilities() {
            if (this.abilities != null) {
                this.abilities.clear();
            }
            return this;
        }

        public RelicStyleDataBuilder particles(String particles) {
            this.particles = particles;
            return this;
        }

        public RelicStyleData build() {
            return new RelicStyleData(switch (this.abilities == null ? 0 : this.abilities.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.abilities.get(0));
                default -> Collections.unmodifiableList(new ArrayList<AbilityTooltip>(this.abilities));
            }, this.particles, this.borders);
        }

        public String toString() {
            return "RelicStyleData.RelicStyleDataBuilder(abilities=" + this.abilities + ", particles=" + this.particles + ", borders=" + this.borders + ")";
        }
    }
}

