/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.widgets.relic.card;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.description.AbilityDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ScreenUtils;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.utils.AbilityUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.LevelingUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.QualityUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class AbilityCardIconWidget
extends AbstractDescriptionWidget
implements IHoverableWidget {
    private final RelicDescriptionScreen screen;
    private final String ability;

    public AbilityCardIconWidget(int x, int y, RelicDescriptionScreen screen, String ability) {
        super(x, y, 28, 37);
        this.screen = screen;
        this.ability = ability;
    }

    @Override
    public void m_5691_() {
        this.MC.m_91152_((Screen)new AbilityDescriptionScreen(this.screen.pos, this.screen.stack, this.ability));
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
        TextureManager manager = this.MC.m_91097_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RelicDescriptionScreen.TEXTURE);
        manager.m_174784_(RelicDescriptionScreen.TEXTURE);
        if (AbilityUtils.canUseAbility(this.screen.stack, this.ability)) {
            guiGraphics.m_280163_(RelicDescriptionScreen.TEXTURE, this.m_252754_(), this.m_252907_(), 258.0f, 0.0f, 28, 37, 512, 512);
            if (this.f_93622_) {
                guiGraphics.m_280163_(RelicDescriptionScreen.TEXTURE, this.m_252754_() - 1, this.m_252907_() - 1, 318.0f, 0.0f, 30, 39, 512, 512);
            }
        } else {
            guiGraphics.m_280163_(RelicDescriptionScreen.TEXTURE, this.m_252754_(), this.m_252907_(), 258.0f, 39.0f, 28, 37, 512, 512);
            if (this.f_93622_) {
                guiGraphics.m_280163_(RelicDescriptionScreen.TEXTURE, this.m_252754_() - 1, this.m_252907_() - 1, 318.0f, 39.0f, 30, 39, 512, 512);
            }
        }
        ResourceLocation card = new ResourceLocation("relics", "textures/gui/description/cards/" + ForgeRegistries.ITEMS.getKey((Object)this.screen.stack.m_41720_()).m_135815_() + "/" + this.ability + ".png");
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)card);
        manager.m_174784_(card);
        if (GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4097) == 29) {
            if (!AbilityUtils.canUseAbility(this.screen.stack, this.ability)) {
                RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
            }
            guiGraphics.m_280163_(card, this.m_252754_() + 3, this.m_252907_() + 3, 0.0f, 0.0f, 20, 29, 20, 29);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RelicDescriptionScreen.TEXTURE);
        manager.m_174784_(RelicDescriptionScreen.TEXTURE);
        if (AbilityUtils.canUseAbility(this.screen.stack, this.ability)) {
            guiGraphics.m_280163_(RelicDescriptionScreen.TEXTURE, this.m_252754_(), this.m_252907_(), 288.0f, 0.0f, 28, 38, 512, 512);
        } else {
            guiGraphics.m_280163_(RelicDescriptionScreen.TEXTURE, this.m_252754_(), this.m_252907_(), 288.0f, 39.0f, 28, 38, 512, 512);
        }
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Item item = this.screen.stack.m_41720_();
        if (!(item instanceof RelicItem)) {
            return;
        }
        RelicItem relic = (RelicItem)item;
        RelicData relicData = relic.getRelicData();
        if (relicData == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        RelicAbilityEntry abilityData = AbilityUtils.getRelicAbilityEntry(relic, this.ability);
        if (abilityData == null) {
            return;
        }
        int points = AbilityUtils.getAbilityPoints(this.screen.stack, this.ability);
        int maxPoints = abilityData.getMaxLevel() == -1 ? relicData.getLevelingData().getMaxLevel() / abilityData.getRequiredPoints() : abilityData.getMaxLevel();
        int level = LevelingUtils.getLevel(this.screen.stack);
        int requiredLevel = abilityData.getRequiredLevel();
        MutableComponent name = Component.m_237115_((String)("tooltip.relics." + ForgeRegistries.ITEMS.getKey((Object)this.screen.stack.m_41720_()).m_135815_() + ".ability." + this.ability)).m_130940_(ChatFormatting.BOLD);
        int width = Mth.m_14045_((int)(this.MC.f_91062_.m_92852_((FormattedText)name) / 2 + 12), (int)60, (int)100);
        int height = this.f_93619_ / 2 + 1;
        ArrayList<MutableComponent> description = new ArrayList<MutableComponent>();
        MutableComponent rarity = Component.m_237115_((String)"tooltip.relics.relic.ability.tooltip.rarity");
        int yOff = 0;
        if (level < requiredLevel) {
            width = 105;
            description.add(rarity);
            description.add(Component.m_237113_((String)"\u25b6 ").m_7220_((Component)Component.m_237110_((String)"tooltip.relics.relic.ability.tooltip.low_level", (Object[])new Object[]{requiredLevel, Component.m_237115_((String)"tooltip.relics.relic.status.negative").m_130940_(ChatFormatting.RED)})));
        } else if (abilityData.getMaxLevel() == 0) {
            width = 105;
            description.add(Component.m_237113_((String)"\u25b6 ").m_7220_((Component)Component.m_237115_((String)"tooltip.relics.relic.ability.tooltip.no_stats")));
        } else {
            yOff += 4;
            description.add(Component.m_237110_((String)"tooltip.relics.relic.ability.tooltip.level", (Object[])new Object[]{points, maxPoints == -1 ? "\u221e" : Integer.valueOf(maxPoints)}));
            description.add(rarity);
        }
        int renderX = this.m_252754_() + 29;
        int renderY = this.m_252907_();
        ScreenUtils.drawTexturedTooltipBorder(guiGraphics, new ResourceLocation("relics", "textures/gui/tooltip/border/paper.png"), width, height, renderX, renderY);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        guiGraphics.m_280614_(this.MC.f_91062_, (Component)name, (renderX + 9) * 2 + width - this.MC.f_91062_.m_92852_((FormattedText)name) / 2, (renderY + 7) * 2, 4269832, false);
        for (MutableComponent entry : description) {
            if (entry == rarity) {
                int texWidth = 512;
                int texHeight = 512;
                int xOff = 0;
                TextureManager manager = this.MC.m_91097_();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)AbilityDescriptionScreen.TEXTURE);
                manager.m_174784_(AbilityDescriptionScreen.TEXTURE);
                guiGraphics.m_280163_(AbilityDescriptionScreen.TEXTURE, (this.m_252754_() + 39) * 2 + this.MC.f_91062_.m_92852_((FormattedText)rarity), (renderY + 14) * 2 - 1 + yOff, 302.0f, 44.0f, 36, 8, texWidth, texHeight);
                for (int i = 1; i < QualityUtils.getAbilityQuality(this.screen.stack, this.ability) + 1; ++i) {
                    boolean isAliquot = i % 2 == 1;
                    guiGraphics.m_280163_(AbilityDescriptionScreen.TEXTURE, (this.m_252754_() + 39) * 2 + this.MC.f_91062_.m_92852_((FormattedText)rarity) + xOff + 1, (renderY + 14) * 2 - 1 + yOff + 1, (float)((AbilityUtils.canUseAbility(this.screen.stack, this.ability) ? 303 : 312) + (isAliquot ? 0 : 4)), 54.0f, isAliquot ? 4 : 3, 7, texWidth, texHeight);
                    xOff += isAliquot ? 4 : 3;
                }
            }
            List lines = this.MC.f_91062_.m_92923_((FormattedText)entry, 210);
            for (FormattedCharSequence line : lines) {
                guiGraphics.m_280649_(this.MC.f_91062_, line, (renderX + 9) * 2, (renderY + 14) * 2 + yOff, 4269832, false);
                yOff += 9;
            }
            if (entry != rarity) continue;
            yOff += 4;
        }
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
    }
}

