/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.widgets.ability;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.description.AbilityDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ScreenUtils;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.utils.AbilityUtils;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.leveling.PacketRelicTweak;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;

public class AbilityRerollButtonWidget
extends AbstractDescriptionWidget
implements IHoverableWidget {
    private final AbilityDescriptionScreen screen;
    private final String ability;

    public AbilityRerollButtonWidget(int x, int y, AbilityDescriptionScreen screen, String ability) {
        super(x, y, 18, 18);
        this.screen = screen;
        this.ability = ability;
    }

    @Override
    public boolean isLocked() {
        return !AbilityUtils.mayPlayerReroll((Player)this.MC.f_91074_, this.screen.stack, this.ability);
    }

    @Override
    public void m_5691_() {
        if (!this.isLocked()) {
            NetworkHandler.sendToServer(new PacketRelicTweak(this.screen.pos, this.ability, PacketRelicTweak.Operation.REROLL));
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
        TextureManager manager = this.MC.m_91097_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)AbilityDescriptionScreen.TEXTURE);
        manager.m_174784_(AbilityDescriptionScreen.TEXTURE);
        if (AbilityUtils.mayPlayerReroll((Player)this.MC.f_91074_, this.screen.stack, this.ability)) {
            guiGraphics.m_280163_(AbilityDescriptionScreen.TEXTURE, this.m_252754_(), this.m_252907_(), 278.0f, 0.0f, 18, 18, 512, 512);
            if (this.f_93622_) {
                guiGraphics.m_280163_(AbilityDescriptionScreen.TEXTURE, this.m_252754_() - 1, this.m_252907_() - 1, 318.0f, 0.0f, 20, 20, 512, 512);
            }
        } else {
            guiGraphics.m_280163_(AbilityDescriptionScreen.TEXTURE, this.m_252754_(), this.m_252907_(), 278.0f, 20.0f, 18, 18, 512, 512);
            RelicAbilityEntry abilityData = AbilityUtils.getRelicAbilityEntry(this.screen.stack.m_41720_(), this.ability);
            if (abilityData == null) {
                return;
            }
            if (AbilityUtils.canUseAbility(this.screen.stack, this.ability) && !abilityData.getStats().isEmpty() && this.f_93622_) {
                guiGraphics.m_280163_(AbilityDescriptionScreen.TEXTURE, this.m_252754_() - 1, this.m_252907_() - 1, 318.0f, 22.0f, 20, 20, 512, 512);
            }
        }
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (!AbilityUtils.canUseAbility(this.screen.stack, this.ability)) {
            return;
        }
        RelicAbilityEntry data = AbilityUtils.getRelicAbilityEntry(this.screen.stack.m_41720_(), this.ability);
        if (data.getStats().isEmpty()) {
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 100;
        int renderWidth = 0;
        int requiredExperience = AbilityUtils.getRerollRequiredExperience(this.screen.stack, this.ability);
        int experience = this.MC.f_91074_.f_36079_;
        MutableComponent negativeStatus = Component.m_237115_((String)"tooltip.relics.relic.status.negative").m_130940_(ChatFormatting.RED);
        MutableComponent positiveStatus = Component.m_237115_((String)"tooltip.relics.relic.status.positive").m_130940_(ChatFormatting.GREEN);
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.m_237115_((String)"tooltip.relics.relic.reroll.description"), Component.m_237113_((String)" "), Component.m_237110_((String)"tooltip.relics.relic.reroll.cost", (Object[])new Object[]{requiredExperience, requiredExperience > experience ? negativeStatus : positiveStatus})});
        for (MutableComponent entry : entries) {
            int entryWidth = (this.MC.f_91062_.m_92852_((FormattedText)entry) + 4) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth, maxWidth);
            }
            tooltip.addAll(this.MC.f_91062_.m_92923_((FormattedText)entry, maxWidth * 2));
        }
        int height = tooltip.size() * 4;
        int renderX = this.m_252754_() + this.f_93618_ + 3;
        int renderY = this.m_252907_() - height / 2;
        ScreenUtils.drawTexturedTooltipBorder(guiGraphics, new ResourceLocation("relics", "textures/gui/tooltip/border/paper.png"), renderWidth, height, renderX, renderY);
        int yOff = 0;
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        for (FormattedCharSequence entry : tooltip) {
            guiGraphics.m_280649_(this.MC.f_91062_, entry, (renderX + 9) * 2, (renderY + 9 + yOff) * 2, 4269832, false);
            yOff += 4;
        }
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
    }
}

