/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IAutoScaled;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.description.widgets.relic.card.AbilityCardIconWidget;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.utils.LevelingUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.QualityUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class RelicDescriptionScreen
extends Screen
implements IAutoScaled {
    private final Minecraft MC = Minecraft.m_91087_();
    public static final ResourceLocation TEXTURE = new ResourceLocation("relics", "textures/gui/description/relic_background.png");
    public static final ResourceLocation WIDGETS = new ResourceLocation("relics", "textures/gui/description/relic_widgets.png");
    public final BlockPos pos;
    public final ItemStack stack;
    public int backgroundHeight = 177;
    public int backgroundWidth = 256;

    public RelicDescriptionScreen(BlockPos pos, ItemStack stack) {
        super((Component)Component.m_237119_());
        this.pos = pos;
        this.stack = stack;
    }

    protected void m_7856_() {
        Item item = this.stack.m_41720_();
        if (!(item instanceof RelicItem)) {
            return;
        }
        RelicItem relic = (RelicItem)item;
        TextureManager manager = this.MC.m_91097_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        manager.m_174784_(TEXTURE);
        RelicData relicData = relic.getRelicData();
        if (relicData == null) {
            return;
        }
        RelicAbilityData abilityData = relicData.getAbilityData();
        if (abilityData != null) {
            int step = 0;
            for (Map.Entry<String, RelicAbilityEntry> ability : abilityData.getAbilities().entrySet()) {
                this.m_142416_((GuiEventListener)new AbilityCardIconWidget((this.f_96543_ - this.backgroundWidth) / 2 + 54 + step, (this.f_96544_ - this.backgroundHeight) / 2 + 124, this, ability.getKey()));
                step += 30;
            }
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        boolean isMaxLevel;
        Item item = this.stack.m_41720_();
        if (!(item instanceof RelicItem)) {
            return;
        }
        RelicItem relic = (RelicItem)item;
        RelicData relicData = relic.getRelicData();
        if (relicData == null) {
            return;
        }
        PoseStack pPoseStack = guiGraphics.m_280168_();
        TextureManager manager = this.MC.m_91097_();
        this.m_280273_(guiGraphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        manager.m_174784_(TEXTURE);
        int texWidth = 512;
        int texHeight = 512;
        int x = (this.f_96543_ - this.backgroundWidth) / 2;
        int y = (this.f_96544_ - this.backgroundHeight) / 2;
        guiGraphics.m_280163_(TEXTURE, x, y, 0.0f, 0.0f, this.backgroundWidth, this.backgroundHeight, texWidth, texHeight);
        int level = LevelingUtils.getLevel(this.stack);
        int maxLevel = relicData.getLevelingData().getMaxLevel();
        int percentage = LevelingUtils.getExperience(this.stack) / (LevelingUtils.getExperienceBetweenLevels(this.stack, level, level + 1) / 100);
        boolean bl = isMaxLevel = LevelingUtils.getLevel(this.stack) >= maxLevel;
        if (isMaxLevel) {
            guiGraphics.m_280163_(TEXTURE, x + 57, y + 89, 258.0f, 80.0f, 142, 12, texWidth, texHeight);
        } else {
            guiGraphics.m_280163_(TEXTURE, x + 74, y + 89, 275.0f, 80.0f, (int)Math.ceil((float)percentage / 100.0f * 109.0f), 10, texWidth, texHeight);
        }
        int xOff = 0;
        for (int i = 1; i < QualityUtils.getRelicQuality(this.stack) + 1; ++i) {
            boolean isAliquot = i % 2 == 1;
            guiGraphics.m_280163_(TEXTURE, x + 100 + xOff, y + 11, (float)(258 + (isAliquot ? 0 : 5)), 94.0f, isAliquot ? 5 : 9, 9, texWidth, texHeight);
            xOff += isAliquot ? 5 : 6;
        }
        MutableComponent name = Component.m_237113_((String)this.stack.m_41611_().getString().replace("[", "").replace("]", "")).m_130940_(ChatFormatting.BOLD);
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.5f, 0.5f, 1.0f);
        guiGraphics.m_280614_(this.MC.f_91062_, (Component)name, x * 2 + (this.backgroundWidth - this.MC.f_91062_.m_92852_((FormattedText)name) / 2), (y + 34) * 2, 4269832, false);
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        MutableComponent experience = isMaxLevel ? Component.m_237115_((String)"tooltip.relics.relic.max_level") : Component.m_237113_((String)(LevelingUtils.getExperience(this.stack) + "/" + LevelingUtils.getExperienceBetweenLevels(this.stack, level, level + 1) + " [" + percentage + "%]"));
        pPoseStack.m_85841_(0.5f, 0.5f, 1.0f);
        guiGraphics.m_280430_(this.MC.f_91062_, (Component)experience, (x + 128 - this.f_96547_.m_92852_((FormattedText)experience) / 4) * 2, (y + 85) * 2, 0xFFFFFF);
        pPoseStack.m_85849_();
        if (!isMaxLevel) {
            guiGraphics.m_280488_(this.MC.f_91062_, String.valueOf(level), x + 66 - this.MC.f_91062_.m_92895_(String.valueOf(level)) / 2, y + 91, 0xFFFFFF);
            guiGraphics.m_280488_(this.MC.f_91062_, String.valueOf(level + 1), x + 190 - this.MC.f_91062_.m_92895_(String.valueOf(level + 1)) / 2, y + 91, 0xFFFFFF);
        }
        String registryName = ForgeRegistries.ITEMS.getKey((Object)relic).m_135815_();
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.5f, 0.5f, 1.0f);
        int yOff = 9;
        List lines = this.MC.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)("tooltip.relics." + registryName + ".leveling")), 255);
        for (FormattedCharSequence line : lines) {
            guiGraphics.m_280649_(this.MC.f_91062_, line, x * 2 + 122 + (265 - this.MC.f_91062_.m_92724_(line)) / 2, (y + 43) * 2 + yOff, 4269832, false);
            yOff += 9;
        }
        pPoseStack.m_85849_();
        int points = LevelingUtils.getPoints(this.stack);
        if (points > 0) {
            manager.m_174784_(WIDGETS);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)WIDGETS);
            guiGraphics.m_280163_(WIDGETS, x + this.backgroundWidth - 3, y + 17, 0.0f, 0.0f, 40, 25, texWidth, texHeight);
            guiGraphics.m_280163_(WIDGETS, x + this.backgroundWidth + 16, y + 22, 0.0f, 27.0f, 16, 13, texWidth, texHeight);
            String value = String.valueOf(points);
            guiGraphics.m_280488_(this.MC.f_91062_, value, x + this.backgroundWidth + 7 - this.f_96547_.m_92895_(value) / 2, y + 25, 0xFFFFFF);
        }
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
        for (GuiEventListener listener : this.m_6702_()) {
            AbstractButton button;
            if (!(listener instanceof AbstractButton) || !(button = (AbstractButton)listener).m_274382_() || !(button instanceof IHoverableWidget)) continue;
            IHoverableWidget widget = (IHoverableWidget)button;
            widget.onHovered(guiGraphics, pMouseX, pMouseY);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    public int getAutoScale() {
        return 0;
    }
}

