/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IAutoScaled;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.description.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.widgets.ability.AbilityRerollButtonWidget;
import it.hurts.sskirillss.relics.client.screen.description.widgets.ability.AbilityResetButtonWidget;
import it.hurts.sskirillss.relics.client.screen.description.widgets.ability.AbilityUpgradeButtonWidget;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.utils.AbilityUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.LevelingUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.QualityUtils;
import it.hurts.sskirillss.relics.tiles.ResearchingTableTile;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class AbilityDescriptionScreen
extends Screen
implements IAutoScaled {
    private final Minecraft MC = Minecraft.m_91087_();
    public static final ResourceLocation TEXTURE = new ResourceLocation("relics", "textures/gui/description/ability_background.png");
    public static final ResourceLocation WIDGETS = new ResourceLocation("relics", "textures/gui/description/relic_widgets.png");
    public final BlockPos pos;
    public ItemStack stack;
    public final String ability;
    public int backgroundHeight = 177;
    public int backgroundWidth = 256;
    public AbilityUpgradeButtonWidget upgradeButton;
    public AbilityRerollButtonWidget rerollButton;
    public AbilityResetButtonWidget resetButton;

    public AbilityDescriptionScreen(BlockPos pos, ItemStack stack, String ability) {
        super((Component)Component.m_237119_());
        this.pos = pos;
        this.stack = stack;
        this.ability = ability;
    }

    protected void m_7856_() {
        if (!(this.stack.m_41720_() instanceof RelicItem)) {
            return;
        }
        TextureManager manager = this.MC.m_91097_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        manager.m_174784_(TEXTURE);
        this.upgradeButton = new AbilityUpgradeButtonWidget((this.f_96543_ - this.backgroundWidth) / 2 + 209, (this.f_96544_ - this.backgroundHeight) / 2 + 98, this, this.ability);
        this.rerollButton = new AbilityRerollButtonWidget((this.f_96543_ - this.backgroundWidth) / 2 + 209, (this.f_96544_ - this.backgroundHeight) / 2 + 118, this, this.ability);
        this.resetButton = new AbilityResetButtonWidget((this.f_96543_ - this.backgroundWidth) / 2 + 209, (this.f_96544_ - this.backgroundHeight) / 2 + 138, this, this.ability);
        this.m_142416_((GuiEventListener)this.upgradeButton);
        this.m_142416_((GuiEventListener)this.rerollButton);
        this.m_142416_((GuiEventListener)this.resetButton);
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        BlockEntity blockEntity;
        ClientLevel world = this.MC.f_91073_;
        if (world == null || !((blockEntity = world.m_7702_(this.pos)) instanceof ResearchingTableTile)) {
            return;
        }
        ResearchingTableTile tile = (ResearchingTableTile)blockEntity;
        this.stack = tile.getStack();
        Item item = this.stack.m_41720_();
        if (!(item instanceof RelicItem)) {
            return;
        }
        RelicItem relic = (RelicItem)item;
        RelicData relicData = relic.getRelicData();
        if (relicData == null) {
            return;
        }
        RelicAbilityEntry abilityData = AbilityUtils.getRelicAbilityEntry(relic, this.ability);
        if (abilityData == null) {
            return;
        }
        PoseStack pPoseStack = guiGraphics.m_280168_();
        TextureManager manager = this.MC.m_91097_();
        this.m_280273_(guiGraphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        manager.m_174784_(TEXTURE);
        int texWidth = 512;
        int texHeight = 512;
        int x = (this.f_96543_ - this.backgroundWidth) / 2;
        int y = (this.f_96544_ - this.backgroundHeight) / 2;
        guiGraphics.m_280163_(TEXTURE, x, y, 0.0f, 0.0f, this.backgroundWidth, this.backgroundHeight, texWidth, texHeight);
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.5f, 0.5f, 0.5f);
        int level = AbilityUtils.getAbilityPoints(this.stack, this.ability);
        int maxLevel = abilityData.getMaxLevel() == -1 ? relicData.getLevelingData().getMaxLevel() / abilityData.getRequiredPoints() : abilityData.getMaxLevel();
        MutableComponent name = Component.m_237115_((String)("tooltip.relics." + ForgeRegistries.ITEMS.getKey((Object)relic).m_135815_() + ".ability." + this.ability));
        if (abilityData.getStats().size() > 0) {
            name.m_7220_((Component)Component.m_237110_((String)"tooltip.relics.relic.ability.level", (Object[])new Object[]{level, maxLevel == -1 ? "\u221e" : Integer.valueOf(maxLevel)}));
        }
        guiGraphics.m_280614_(this.MC.f_91062_, (Component)name.m_130940_(ChatFormatting.BOLD), x * 2 + 142, y * 2 + 52 - 1, 4269832, false);
        List lines = this.MC.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)("tooltip.relics." + ForgeRegistries.ITEMS.getKey((Object)this.stack.m_41720_()).m_135815_() + ".ability." + this.ability + ".description")), 305);
        for (int i = 0; i < lines.size(); ++i) {
            guiGraphics.m_280649_(this.MC.f_91062_, (FormattedCharSequence)lines.get(i), x * 2 + 142, y * 2 + i * 9 + 70, 4269832, false);
        }
        pPoseStack.m_85849_();
        int yOff = 0;
        int xOff = 0;
        boolean isLocked = !AbilityUtils.canUseAbility(this.stack, this.ability);
        boolean isHoveredUpgrade = !isLocked && this.upgradeButton.m_274382_();
        boolean isHoveredReroll = !isLocked && this.rerollButton.m_274382_();
        boolean isHoveredReset = !isLocked && this.resetButton.m_274382_();
        for (String stat : AbilityUtils.getAbilityInitialValues(this.stack, this.ability).keySet()) {
            RelicAbilityStat statData = AbilityUtils.getRelicAbilityStat(relic, this.ability, stat);
            if (statData == null) continue;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            manager.m_174784_(TEXTURE);
            guiGraphics.m_280163_(TEXTURE, x + 32, y + 103 + yOff / 2, 302.0f, 44.0f, 36, 8, texWidth, texHeight);
            for (int i = 1; i < QualityUtils.getStatQuality(this.stack, this.ability, stat) + 1; ++i) {
                boolean isAliquot = i % 2 == 1;
                guiGraphics.m_280163_(TEXTURE, x + 33 + xOff, y + 104 + yOff / 2, (float)((isLocked ? 312 : 303) + (isAliquot ? 0 : 4)), 54.0f, isAliquot ? 4 : 3, 7, texWidth, texHeight);
                xOff += isAliquot ? 4 : 3;
            }
            MutableComponent cost = Component.m_237113_((String)String.valueOf(statData.getFormatValue().apply(AbilityUtils.getAbilityValue(this.stack, this.ability, stat))));
            if (isHoveredUpgrade && level < maxLevel) {
                cost.m_130946_(" \u27a0 " + statData.getFormatValue().apply(AbilityUtils.getAbilityValue(this.stack, this.ability, stat, level + 1)));
            }
            if (isHoveredReroll) {
                cost.m_130946_(" \u27a0 ").m_7220_((Component)Component.m_237113_((String)"X.XXX").m_130940_(ChatFormatting.OBFUSCATED));
            }
            if (isHoveredReset && level > 0) {
                cost.m_130946_(" \u27a0 " + statData.getFormatValue().apply(AbilityUtils.getAbilityValue(this.stack, this.ability, stat, 0)));
            }
            pPoseStack.m_85836_();
            pPoseStack.m_85841_(0.5f, 0.5f, 0.5f);
            guiGraphics.m_280614_(this.MC.f_91062_, (Component)Component.m_237115_((String)("tooltip.relics." + ForgeRegistries.ITEMS.getKey((Object)this.stack.m_41720_()).m_135815_() + ".ability." + this.ability + ".stat." + stat + ".title")), x * 2 + 188, y * 2 + yOff + 204, 4269832, false);
            guiGraphics.m_280614_(this.MC.f_91062_, (Component)Component.m_237113_((String)" \u25cf ").m_7220_((Component)Component.m_237110_((String)("tooltip.relics." + ForgeRegistries.ITEMS.getKey((Object)this.stack.m_41720_()).m_135815_() + ".ability." + this.ability + ".stat." + stat + ".value"), (Object[])new Object[]{cost})), x * 2 + 188, y * 2 + (yOff += 10) + 204, 4269832, false);
            pPoseStack.m_85849_();
            yOff += 17;
            xOff = 0;
        }
        int points = LevelingUtils.getPoints(this.stack);
        if (points > 0) {
            manager.m_174784_(WIDGETS);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)WIDGETS);
            guiGraphics.m_280163_(WIDGETS, x + this.backgroundWidth - 3, y + 17, 0.0f, 0.0f, 40, 25, texWidth, texHeight);
            guiGraphics.m_280163_(WIDGETS, x + this.backgroundWidth + 16, y + 22, 0.0f, 27.0f, 16, 13, texWidth, texHeight);
            String value = String.valueOf(points);
            guiGraphics.m_280488_(this.MC.f_91062_, value, x + this.backgroundWidth + 7 - this.f_96547_.m_92895_(value) / 2, y + 25, 0xFFFFFF);
        }
        ResourceLocation card = new ResourceLocation("relics", "textures/gui/description/cards/" + ForgeRegistries.ITEMS.getKey((Object)this.stack.m_41720_()).m_135815_() + "/" + this.ability + ".png");
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)card);
        manager.m_174784_(card);
        if (GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4097) == 29) {
            if (isLocked) {
                RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
            }
            guiGraphics.m_280411_(card, x + 29, y + 19, 30, 43, 0.0f, 0.0f, 20, 29, 20, 29);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        manager.m_174784_(TEXTURE);
        guiGraphics.m_280163_(TEXTURE, x + 26, y + 25, 356.0f, 0.0f, 38, 48, texWidth, texHeight);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        manager.m_174784_(TEXTURE);
        if (isLocked) {
            guiGraphics.m_280163_(TEXTURE, x + 24, y + 16, 258.0f, 101.0f, 42, 59, texWidth, texHeight);
        } else {
            guiGraphics.m_280163_(TEXTURE, x + 24, y + 16, 258.0f, 40.0f, 42, 59, texWidth, texHeight);
        }
        for (int i = 1; i < QualityUtils.getAbilityQuality(this.stack, this.ability) + 1; ++i) {
            boolean isAliquot = i % 2 == 1;
            guiGraphics.m_280163_(TEXTURE, x + 27 + xOff, y + 63, (float)((isLocked ? 312 : 303) + (isAliquot ? 0 : 4)), 54.0f, isAliquot ? 4 : 3, 7, texWidth, texHeight);
            xOff += isAliquot ? 4 : 3;
        }
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
        for (GuiEventListener listener : this.m_6702_()) {
            AbstractButton button;
            if (!(listener instanceof AbstractButton) || !(button = (AbstractButton)listener).m_274382_() || !(button instanceof IHoverableWidget)) continue;
            IHoverableWidget widget = (IHoverableWidget)button;
            widget.onHovered(guiGraphics, pMouseX, pMouseY);
        }
    }

    public void m_7379_() {
        this.MC.m_91152_((Screen)new RelicDescriptionScreen(this.pos, this.stack));
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    public int getAutoScale() {
        return 0;
    }
}

