/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.hud.abilities;

import it.hurts.sskirillss.relics.client.hud.abilities.AbilitiesRenderHandler;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.AbilityCastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.utils.AbilityUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.DataUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;

public class ActiveAbilityUtils {
    public static ItemStack getStackInCuriosSlot(Player player, int slot) {
        return CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).map(handler -> handler.getStackInSlot(slot)).orElse(ItemStack.f_41583_);
    }

    public static List<AbilitiesRenderHandler.AbilityEntry> getActiveEntries(Player player) {
        ArrayList<AbilitiesRenderHandler.AbilityEntry> entries = new ArrayList<AbilitiesRenderHandler.AbilityEntry>();
        CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).ifPresent(handler -> {
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                List<String> abilities;
                ItemStack stack = handler.getStackInSlot(slot);
                if (!(stack.m_41720_() instanceof RelicItem) || (abilities = ActiveAbilityUtils.getRelicActiveAbilities(stack)).isEmpty()) continue;
                for (String ability : abilities) {
                    if (!AbilityUtils.canUseAbility(stack, ability)) continue;
                    entries.add(new AbilitiesRenderHandler.AbilityEntry(slot, ability));
                }
            }
        });
        return entries;
    }

    public static List<String> getRelicActiveAbilities(ItemStack stack) {
        ArrayList<String> abilities = new ArrayList<String>();
        RelicAbilityData abilityData = DataUtils.getRelicAbilityData(stack.m_41720_());
        if (abilityData == null) {
            return abilities;
        }
        for (Map.Entry<String, RelicAbilityEntry> ability : abilityData.getAbilities().entrySet()) {
            if (ability.getValue().getCastData().getKey() == AbilityCastType.NONE) continue;
            abilities.add(ability.getKey());
        }
        return abilities;
    }
}

