/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.hud.abilities;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.hud.abilities.ActiveAbilityUtils;
import it.hurts.sskirillss.relics.init.HotkeyRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.AbilityCastPredicate;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.AbilityCastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.AbilityCastType;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.data.PredicateData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.data.PredicateEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.data.PredicateInfo;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.utils.AbilityUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.CastUtils;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.abilities.SpellCastPacket;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class AbilitiesRenderHandler {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static List<AbilityEntry> entries = new ArrayList<AbilityEntry>();
    private static final Map<String, AbilityCache> cache = new HashMap<String, AbilityCache>();
    private static int selectedIndex = 0;
    private static boolean animationDown = false;
    private static int animationDelta = 0;
    private static int castShakeDelta = 0;
    private static int mouseDelta = 0;

    private static void updateCaches(Player player) {
        if (animationDelta == 0) {
            return;
        }
        entries = ActiveAbilityUtils.getActiveEntries(player);
        for (AbilityEntry entry : entries) {
            cache.putIfAbsent(entry.getAbility(), new AbilityCache());
            AnimationCache animationCache = entry.getCache().getAnimation();
            if (animationCache.iconShakeDelta > 0) {
                --animationCache.iconShakeDelta;
            }
            String abilityName = entry.ability;
            ItemStack stack = ActiveAbilityUtils.getStackInCuriosSlot(player, entry.slot);
            RelicItem relic = (RelicItem)stack.m_41720_();
            AbilityCastPredicate predicate = CastUtils.getAbilityCastPredicates(relic, abilityName);
            if (predicate == null) continue;
            for (Map.Entry<String, PredicateEntry> data : predicate.getPredicates().entrySet()) {
                entry.getCache().predicate.info.put(data.getKey(), data.getValue().getPredicate().apply(new PredicateData(player, stack)));
            }
        }
    }

    public static void render(GuiGraphics guiGraphics, float partialTicks) {
        if (animationDelta == 0) {
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        Window window = MC.m_91268_();
        LocalPlayer player = AbilitiesRenderHandler.MC.f_91074_;
        if (player == null || entries.isEmpty()) {
            return;
        }
        int x = window.m_85445_() / 2;
        int y = -40;
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, ((float)animationDelta - (animationDelta != 5 ? partialTicks * (float)(animationDown ? -1 : 1) : 0.0f)) * 16.0f, 0.0f);
        float shakeOffset = castShakeDelta > 0 ? ((float)castShakeDelta - partialTicks) * 0.25f : 0.0f;
        AbilitiesRenderHandler.drawAbility(guiGraphics, player, -2, (float)(x - 65) - shakeOffset, y, partialTicks);
        AbilitiesRenderHandler.drawAbility(guiGraphics, player, -1, (float)(x - 34) - shakeOffset, y, partialTicks);
        AbilitiesRenderHandler.drawAbility(guiGraphics, player, 0, x, y, partialTicks);
        AbilitiesRenderHandler.drawAbility(guiGraphics, player, 1, (float)(x + 34) + shakeOffset, y, partialTicks);
        AbilitiesRenderHandler.drawAbility(guiGraphics, player, 2, (float)(x + 65) + shakeOffset, y, partialTicks);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("relics", "textures/hud/abilities/background.png"));
        RenderSystem.enableBlend();
        RenderUtils.renderTextureFromCenter(poseStack, (float)(x - 95) - shakeOffset, (float)y, 2.0f, 2.0f, 256.0f, 256.0f, 18.0f, 29.0f, 1.0f + (mouseDelta < 0 ? (float)Math.abs(mouseDelta) * 0.01f : 0.0f));
        if (mouseDelta < 0) {
            RenderUtils.renderTextureFromCenter(poseStack, (float)(x - 95) - shakeOffset, (float)y, 25.0f, 1.0f, 256.0f, 256.0f, 24.0f, 35.0f, 1.0f + (float)Math.abs(mouseDelta) * 0.01f);
        }
        RenderUtils.renderTextureFromCenter(poseStack, (float)(x + 95) + shakeOffset, (float)y, 2.0f, 38.0f, 256.0f, 256.0f, 18.0f, 29.0f, 1.0f + (mouseDelta > 0 ? (float)Math.abs(mouseDelta) * 0.01f : 0.0f));
        if (mouseDelta > 0) {
            RenderUtils.renderTextureFromCenter(poseStack, (float)(x + 95) + shakeOffset, (float)y, 25.0f, 37.0f, 256.0f, 256.0f, 24.0f, 35.0f, 1.0f + (float)Math.abs(mouseDelta) * 0.01f);
        }
        RenderSystem.disableBlend();
        AbilityEntry selectedAbility = AbilitiesRenderHandler.getAbilityByIndex(selectedIndex);
        ItemStack stack = ActiveAbilityUtils.getStackInCuriosSlot((Player)player, selectedAbility.getSlot());
        String registryName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_();
        MutableComponent name = Component.m_237115_((String)("tooltip.relics." + registryName + ".ability." + selectedAbility.getAbility()));
        guiGraphics.m_280614_(AbilitiesRenderHandler.MC.f_91062_, (Component)name, x - AbilitiesRenderHandler.MC.f_91062_.m_92852_((FormattedText)name) / 2, y - 37, 0xFFFFFF, true);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252880_(((float)animationDelta - (animationDelta != 5 ? partialTicks * (float)(animationDown ? -1 : 1) : 0.0f)) * 16.0f, 0.0f, 0.0f);
        int yOff = 0;
        x = -70;
        y = 25;
        for (Map.Entry<String, PredicateInfo> entry : AbilitiesRenderHandler.cache.get((Object)selectedAbility.getAbility()).predicate.info.entrySet()) {
            String predicateName = entry.getKey();
            PredicateInfo info = entry.getValue();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)(info.getCondition() != false ? new ResourceLocation("relics", "textures/gui/description/icons/completed.png") : (info.getIcon() != null ? info.getIcon() : new ResourceLocation("relics", "textures/gui/description/icons/" + registryName + "/" + predicateName + ".png"))));
            RenderUtils.renderTextureFromCenter(poseStack, (float)x, (float)(y + yOff), 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, 0.5f);
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            guiGraphics.m_280614_(AbilitiesRenderHandler.MC.f_91062_, (Component)Component.m_237110_((String)("tooltip.relics." + registryName + ".ability." + selectedAbility.ability + ".predicate." + predicateName), (Object[])info.getPlaceholders().toArray()).m_130940_(info.getCondition() != false ? ChatFormatting.STRIKETHROUGH : ChatFormatting.RESET), (x + 7) * 2, (y - 2 + yOff) * 2, info.getCondition() != false ? 12517304 : 15826844, true);
            poseStack.m_85841_(2.0f, 2.0f, 2.0f);
            yOff += 10;
        }
        poseStack.m_85849_();
    }

    private static void drawAbility(GuiGraphics guiGraphics, LocalPlayer player, int realIndex, float x, float y, float partialTicks) {
        AbilityEntry ability = AbilitiesRenderHandler.getAbilityByIndex(AbilitiesRenderHandler.getRelativeIndex(realIndex));
        if (ability == null) {
            return;
        }
        ItemStack stack = ActiveAbilityUtils.getStackInCuriosSlot((Player)player, ability.getSlot());
        Item item = stack.m_41720_();
        if (!(item instanceof RelicItem)) {
            return;
        }
        RelicItem relic = (RelicItem)item;
        PoseStack poseStack = guiGraphics.m_280168_();
        boolean isLocked = !AbilityUtils.canPlayerUseActiveAbility((Player)player, stack, ability.getAbility());
        ResourceLocation card = new ResourceLocation("relics", "textures/gui/description/cards/" + ForgeRegistries.ITEMS.getKey((Object)ActiveAbilityUtils.getStackInCuriosSlot((Player)player, ability.getSlot()).m_41720_()).m_135815_() + "/" + ability.getAbility() + ".png");
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)card);
        RenderSystem.enableBlend();
        poseStack.m_85836_();
        int width = 20;
        int height = 29;
        float scale = (float)(1.0 + Mth.m_14008_((double)Math.pow(13.5, -Math.abs(realIndex)), (double)0.0, (double)0.2f) + (realIndex == 0 ? Math.sin(((float)player.f_19797_ + partialTicks) * 0.1f) * (double)0.05f + (double)(castShakeDelta > 0 ? ((float)castShakeDelta - partialTicks) * 0.02f : 0.0f) : 0.0));
        RenderUtils.renderTextureFromCenter(poseStack, x - scale, y - scale, width, height, scale);
        int cooldown = AbilityUtils.getAbilityCooldown(stack, ability.getAbility());
        int cap = AbilityUtils.getAbilityCooldownCap(stack, ability.getAbility());
        Object iconDescription = "";
        if (cooldown > 0) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)card);
            RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
            float percentage = (float)cooldown / ((float)cap / 100.0f) / 100.0f;
            RenderUtils.renderTextureFromCenter(poseStack, x - scale, y - scale + (float)height * scale / 2.0f - (float)height * scale / 2.0f * percentage, 0.0f, (float)height - (float)height * percentage, (float)width, (float)height, (float)width, (float)height * percentage, scale);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("relics", "textures/hud/abilities/background.png"));
        RenderUtils.renderTextureFromCenter(poseStack, x, y, 66.0f, isLocked ? 40.0f : 2.0f, 256.0f, 256.0f, 28.0f, 37.0f, scale);
        if (AbilityUtils.isAbilityTicking(stack, ability.getAbility())) {
            AbilityCastType type = (AbilityCastType)((Object)AbilityUtils.getRelicAbilityEntry(relic, ability.getAbility()).getCastData().getKey());
            if (type == AbilityCastType.TOGGLEABLE) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("relics", "textures/hud/abilities/widgets/toggleable.png"));
                RenderUtils.renderTextureFromCenter(poseStack, x - 1.0f, y - 1.0f, 30.0f, 624.0f, 30.0f, 39.0f, scale, AnimationData.builder().frame(0, 1).frame(1, 1).frame(2, 1).frame(3, 1).frame(4, 1).frame(5, 1).frame(6, 1).frame(7, 1).frame(8, 1).frame(9, 1).frame(10, 1).frame(11, 1).frame(12, 1).frame(13, 1).frame(14, 1).frame(15, 1));
            } else {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)(Math.sin((float)player.f_19797_ * 0.2f) * 0.25 + 0.5)));
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("relics", "textures/hud/abilities/widgets/cyclical.png"));
                RenderUtils.renderTextureFromCenter(poseStack, x - scale / 2.0f, y - scale / 2.0f, 29.0f, 38.0f, scale);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        if (realIndex == 0) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("relics", "textures/hud/abilities/background.png"));
            RenderUtils.renderTextureFromCenter(poseStack, x - 1.0f, y - 20.0f, 53.0f, isLocked ? 14.0f : 2.0f, 256.0f, 256.0f, 6.0f, 11.0f, scale - 0.1f);
        }
        if (cooldown > 0) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("relics", "textures/hud/abilities/widgets/icons/cooldown.png"));
            AbilitiesRenderHandler.drawAbilityStatusIcon(ability, guiGraphics, x - scale, y - scale, 20.0f, 300.0f, scale - 0.1f, AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 8).frame(11, 2).frame(12, 2).frame(13, 2).frame(14, 2), cap - cooldown, partialTicks);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            iconDescription = String.valueOf(MathUtils.round((double)cooldown / 20.0, 1));
        } else {
            PredicateCache predicateCache = ability.getCache().predicate;
            Collection<PredicateInfo> infoEntries = predicateCache.info.values();
            int successPredicates = 0;
            for (PredicateInfo info : infoEntries) {
                if (!info.getCondition().booleanValue()) continue;
                ++successPredicates;
            }
            int failedPredicates = infoEntries.size() - successPredicates;
            if (failedPredicates > 0) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("relics", "textures/hud/abilities/widgets/icons/locked.png"));
                AbilitiesRenderHandler.drawAbilityStatusIcon(ability, guiGraphics, x - scale, y - scale, 20.0f, 20.0f, scale - 0.1f, null, player.f_19797_, partialTicks);
                iconDescription = successPredicates + "/" + infoEntries.size();
            }
        }
        if (!((String)iconDescription).isEmpty()) {
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            guiGraphics.drawString(AbilitiesRenderHandler.MC.f_91062_, (String)iconDescription, (x - 1.0f) * 2.0f - (float)AbilitiesRenderHandler.MC.f_91062_.m_92895_((String)iconDescription) / 2.0f, (y - 6.0f + scale * 15.0f) * 2.0f, 0xFFFFFF, true);
            poseStack.m_85841_(2.0f, 2.0f, 2.0f);
        }
        poseStack.m_85849_();
    }

    private static void drawAbilityStatusIcon(AbilityEntry ability, GuiGraphics guiGraphics, float x, float y, float texWidth, float texHeight, float scale, @Nullable AnimationData animation, long ticks, float partialTicks) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, 0.0f);
        AnimationCache animationCache = ability.getCache().getAnimation();
        if (animationCache.iconShakeDelta != 0) {
            float color = (float)animationCache.iconShakeDelta * 0.05f;
            RenderSystem.setShaderColor((float)1.0f, (float)(1.0f - color), (float)(1.0f - color), (float)1.0f);
            poseStack.m_252781_(Axis.f_252403_.m_252961_((float)Math.sin(((float)ticks + partialTicks) * 0.5f) * 0.05f));
            scale += ((float)animationCache.iconShakeDelta - partialTicks) * 0.025f;
        }
        if (animation != null) {
            RenderUtils.renderTextureFromCenter(poseStack, 0.0f, 0.0f, texWidth, texHeight, texWidth, texWidth, scale, animation, ticks);
        } else {
            RenderUtils.renderTextureFromCenter(poseStack, 0.0f, 0.0f, texWidth, texHeight, scale);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    private static int getRelativeIndex(int offset) {
        int current = selectedIndex;
        int sum = current + offset;
        int max = entries.size() - 1;
        return sum > max ? Math.min(max, sum - (max + 1)) : (sum < 0 ? Math.max(0, sum + (max + 1)) : sum);
    }

    @Nullable
    private static AbilityEntry getAbilityByIndex(int index) {
        if (entries.isEmpty()) {
            return null;
        }
        return entries.get(Mth.m_14045_((int)index, (int)0, (int)entries.size()));
    }

    private static void applyDelta(int delta) {
        int current = selectedIndex;
        int sum = current + delta;
        int max = entries.size() - 1;
        selectedIndex = sum > max ? sum - max - 1 : (sum < 0 ? max : sum);
    }

    public static class AbilityEntry {
        private int slot;
        private String ability;

        public AbilityCache getCache() {
            return cache.get(this.ability);
        }

        public int getSlot() {
            return this.slot;
        }

        public String getAbility() {
            return this.ability;
        }

        public void setSlot(int slot) {
            this.slot = slot;
        }

        public void setAbility(String ability) {
            this.ability = ability;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AbilityEntry)) {
                return false;
            }
            AbilityEntry other = (AbilityEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSlot() != other.getSlot()) {
                return false;
            }
            String this$ability = this.getAbility();
            String other$ability = other.getAbility();
            return !(this$ability == null ? other$ability != null : !this$ability.equals(other$ability));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AbilityEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSlot();
            String $ability = this.getAbility();
            result = result * 59 + ($ability == null ? 43 : $ability.hashCode());
            return result;
        }

        public String toString() {
            return "AbilitiesRenderHandler.AbilityEntry(slot=" + this.getSlot() + ", ability=" + this.getAbility() + ")";
        }

        public AbilityEntry(int slot, String ability) {
            this.slot = slot;
            this.ability = ability;
        }
    }

    public static class AbilityCache {
        private AnimationCache animation = new AnimationCache();
        private PredicateCache predicate = new PredicateCache();

        public AnimationCache getAnimation() {
            return this.animation;
        }

        public PredicateCache getPredicate() {
            return this.predicate;
        }

        public void setAnimation(AnimationCache animation) {
            this.animation = animation;
        }

        public void setPredicate(PredicateCache predicate) {
            this.predicate = predicate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AbilityCache)) {
                return false;
            }
            AbilityCache other = (AbilityCache)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AnimationCache this$animation = this.getAnimation();
            AnimationCache other$animation = other.getAnimation();
            if (this$animation == null ? other$animation != null : !((Object)this$animation).equals(other$animation)) {
                return false;
            }
            PredicateCache this$predicate = this.getPredicate();
            PredicateCache other$predicate = other.getPredicate();
            return !(this$predicate == null ? other$predicate != null : !((Object)this$predicate).equals(other$predicate));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AbilityCache;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AnimationCache $animation = this.getAnimation();
            result = result * 59 + ($animation == null ? 43 : ((Object)$animation).hashCode());
            PredicateCache $predicate = this.getPredicate();
            result = result * 59 + ($predicate == null ? 43 : ((Object)$predicate).hashCode());
            return result;
        }

        public String toString() {
            return "AbilitiesRenderHandler.AbilityCache(animation=" + this.getAnimation() + ", predicate=" + this.getPredicate() + ")";
        }

        public AbilityCache() {
        }

        public AbilityCache(AnimationCache animation, PredicateCache predicate) {
            this.animation = animation;
            this.predicate = predicate;
        }
    }

    public static class AnimationCache {
        private int iconShakeDelta = 0;

        public int getIconShakeDelta() {
            return this.iconShakeDelta;
        }

        public void setIconShakeDelta(int iconShakeDelta) {
            this.iconShakeDelta = iconShakeDelta;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnimationCache)) {
                return false;
            }
            AnimationCache other = (AnimationCache)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getIconShakeDelta() == other.getIconShakeDelta();
        }

        protected boolean canEqual(Object other) {
            return other instanceof AnimationCache;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIconShakeDelta();
            return result;
        }

        public String toString() {
            return "AbilitiesRenderHandler.AnimationCache(iconShakeDelta=" + this.getIconShakeDelta() + ")";
        }

        public AnimationCache() {
        }

        public AnimationCache(int iconShakeDelta) {
            this.iconShakeDelta = iconShakeDelta;
        }
    }

    public static class PredicateCache {
        private Map<String, PredicateInfo> info = new HashMap<String, PredicateInfo>();

        public Map<String, PredicateInfo> getInfo() {
            return this.info;
        }

        public void setInfo(Map<String, PredicateInfo> info) {
            this.info = info;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PredicateCache)) {
                return false;
            }
            PredicateCache other = (PredicateCache)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, PredicateInfo> this$info = this.getInfo();
            Map<String, PredicateInfo> other$info = other.getInfo();
            return !(this$info == null ? other$info != null : !((Object)this$info).equals(other$info));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PredicateCache;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, PredicateInfo> $info = this.getInfo();
            result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
            return result;
        }

        public String toString() {
            return "AbilitiesRenderHandler.PredicateCache(info=" + this.getInfo() + ")";
        }

        public PredicateCache() {
        }

        public PredicateCache(Map<String, PredicateInfo> info) {
            this.info = info;
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class CastEvents {
        @SubscribeEvent
        public static void onKeyPressed(InputEvent.MouseButton.Pre event) {
            if (animationDelta == 0 || event.getAction() != 1 || event.getButton() != 0) {
                return;
            }
            Minecraft MC = Minecraft.m_91087_();
            if (MC.f_91080_ != null) {
                return;
            }
            LocalPlayer player = MC.f_91074_;
            if (player == null) {
                return;
            }
            AbilityEntry ability = AbilitiesRenderHandler.getAbilityByIndex(selectedIndex);
            if (ability == null) {
                return;
            }
            ItemStack stack = ActiveAbilityUtils.getStackInCuriosSlot((Player)player, ability.getSlot());
            Item item = stack.m_41720_();
            if (!(item instanceof RelicItem)) {
                return;
            }
            RelicItem relic = (RelicItem)item;
            if (!AbilityUtils.canPlayerUseActiveAbility((Player)player, stack, ability.getAbility())) {
                int delta = ability.getCache().getAnimation().iconShakeDelta;
                ability.getCache().getAnimation().setIconShakeDelta(Math.min(15, delta + (delta > 0 ? 5 : 10)));
                event.setCanceled(true);
                return;
            }
            boolean isTicking = AbilityUtils.isAbilityTicking(stack, ability.getAbility());
            AbilityCastType type = (AbilityCastType)((Object)AbilityUtils.getRelicAbilityEntry(relic, ability.getAbility()).getCastData().getKey());
            switch (type) {
                case INSTANTANEOUS: {
                    NetworkHandler.sendToServer(new SpellCastPacket(AbilityCastType.INSTANTANEOUS, AbilityCastStage.END, ability.getAbility(), ability.getSlot()));
                    relic.castActiveAbility(stack, (Player)player, ability.getAbility(), type, AbilityCastStage.END);
                    break;
                }
                case CYCLICAL: {
                    NetworkHandler.sendToServer(new SpellCastPacket(AbilityCastType.CYCLICAL, AbilityCastStage.START, ability.getAbility(), ability.getSlot()));
                    relic.castActiveAbility(stack, (Player)player, ability.getAbility(), type, AbilityCastStage.START);
                    break;
                }
                case INTERRUPTIBLE: {
                    AbilityCastStage stage = isTicking ? AbilityCastStage.END : AbilityCastStage.START;
                    NetworkHandler.sendToServer(new SpellCastPacket(AbilityCastType.INTERRUPTIBLE, stage, ability.getAbility(), ability.getSlot()));
                    relic.castActiveAbility(stack, (Player)player, ability.getAbility(), type, stage);
                    break;
                }
                case TOGGLEABLE: {
                    AbilityCastStage stage = isTicking ? AbilityCastStage.END : AbilityCastStage.START;
                    NetworkHandler.sendToServer(new SpellCastPacket(AbilityCastType.TOGGLEABLE, stage, ability.getAbility(), ability.getSlot()));
                    relic.castActiveAbility(stack, (Player)player, ability.getAbility(), type, stage);
                }
            }
            castShakeDelta = 5;
            Minecraft.m_91087_().f_91067_.m_91602_();
        }

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.side != LogicalSide.CLIENT || event.phase != TickEvent.Phase.END) {
                return;
            }
            Player player = event.player;
            if (player == null) {
                return;
            }
            AbilityEntry ability = AbilitiesRenderHandler.getAbilityByIndex(selectedIndex);
            if (ability == null) {
                return;
            }
            ItemStack stack = ActiveAbilityUtils.getStackInCuriosSlot(player, ability.getSlot());
            Item item = stack.m_41720_();
            if (!(item instanceof RelicItem)) {
                return;
            }
            RelicItem relic = (RelicItem)item;
            boolean isTicking = AbilityUtils.isAbilityTicking(stack, ability.getAbility());
            boolean isCasting = Minecraft.m_91087_().f_91067_.m_91560_();
            RelicAbilityEntry entry = AbilityUtils.getRelicAbilityEntry(relic, ability.getAbility());
            if (entry == null) {
                return;
            }
            AbilityCastType type = (AbilityCastType)((Object)entry.getCastData().getKey());
            switch (type) {
                case CYCLICAL: {
                    if (!isTicking) break;
                    if (isCasting) {
                        NetworkHandler.sendToServer(new SpellCastPacket(AbilityCastType.CYCLICAL, AbilityCastStage.TICK, ability.getAbility(), ability.getSlot()));
                        relic.castActiveAbility(stack, player, ability.getAbility(), type, AbilityCastStage.TICK);
                        break;
                    }
                    NetworkHandler.sendToServer(new SpellCastPacket(AbilityCastType.CYCLICAL, AbilityCastStage.END, ability.getAbility(), ability.getSlot()));
                    relic.castActiveAbility(stack, player, ability.getAbility(), type, AbilityCastStage.END);
                    break;
                }
                case INTERRUPTIBLE: {
                    if (!isTicking) break;
                    NetworkHandler.sendToServer(new SpellCastPacket(AbilityCastType.INTERRUPTIBLE, AbilityCastStage.TICK, ability.getAbility(), ability.getSlot()));
                    relic.castActiveAbility(stack, player, ability.getAbility(), type, AbilityCastStage.TICK);
                    break;
                }
                case TOGGLEABLE: {
                    if (!isTicking) break;
                    NetworkHandler.sendToServer(new SpellCastPacket(AbilityCastType.TOGGLEABLE, AbilityCastStage.TICK, ability.getAbility(), ability.getSlot()));
                    relic.castActiveAbility(stack, player, ability.getAbility(), type, AbilityCastStage.TICK);
                }
            }
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class GeneralEvents {
        @SubscribeEvent
        public static void onMouseScroll(InputEvent.MouseScrollingEvent event) {
            if (!HotkeyRegistry.ABILITY_LIST.m_90857_() || entries.isEmpty()) {
                return;
            }
            int current = selectedIndex;
            AbilitiesRenderHandler.applyDelta(event.getScrollDelta() > 0.0 ? -1 : 1);
            if (current != selectedIndex) {
                mouseDelta = event.getScrollDelta() > 0.0 ? -10 : 10;
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null) {
                    player.m_5496_((SoundEvent)SoundEvents.f_12490_.get(), 0.5f, 1.5f + player.m_217043_().m_188501_() * 0.25f);
                }
            }
            event.setCanceled(true);
        }

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.side != LogicalSide.CLIENT || event.phase != TickEvent.Phase.END) {
                return;
            }
            Player player = event.player;
            if (!(player instanceof LocalPlayer)) {
                return;
            }
            if (castShakeDelta > 0) {
                --castShakeDelta;
            }
            if (mouseDelta > 0) {
                --mouseDelta;
            } else if (mouseDelta < 0) {
                ++mouseDelta;
            }
            if (HotkeyRegistry.ABILITY_LIST.m_90857_()) {
                ItemStack stack;
                Item item;
                AbilityEntry ability = AbilitiesRenderHandler.getAbilityByIndex(selectedIndex);
                if (ability != null && (item = (stack = ActiveAbilityUtils.getStackInCuriosSlot(player, ability.getSlot())).m_41720_()) instanceof RelicItem) {
                    RelicItem relic = (RelicItem)item;
                    if (AbilityUtils.canPlayerUseActiveAbility(player, stack, ability.getAbility())) {
                        relic.tickActiveAbilitySelection(stack, player, ability.getAbility());
                    }
                }
                if (animationDelta < 5) {
                    ++animationDelta;
                }
                animationDown = true;
            } else {
                if (animationDelta > 0) {
                    --animationDelta;
                }
                animationDown = false;
            }
            if (animationDelta == 0) {
                return;
            }
            AbilitiesRenderHandler.updateCaches(player);
            if (selectedIndex > entries.size() || selectedIndex < 0) {
                selectedIndex = 0;
            }
        }
    }
}

