/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.blocks;

import it.hurts.sskirillss.relics.client.screen.description.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.init.TileRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.utils.ResearchUtils;
import it.hurts.sskirillss.relics.tiles.ResearchingTableTile;
import it.hurts.sskirillss.relics.utils.TickerUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

public class ResearchingTableBlock
extends Block
implements EntityBlock {
    public ResearchingTableBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60953_(s -> 15).m_60978_(1.5f).m_60918_(SoundType.f_56736_).m_60955_());
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        ResearchingTableTile tile;
        ItemStack stack;
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = worldIn.m_7702_(pos)) instanceof ResearchingTableTile && (stack = (tile = (ResearchingTableTile)blockEntity).getStack()) != null && !stack.m_41619_()) {
            worldIn.m_7967_((Entity)new ItemEntity(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack));
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openGui(BlockPos pos, ItemStack stack) {
        Minecraft.m_91087_().m_91152_((Screen)new RelicDescriptionScreen(pos, stack));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return TickerUtils.getTicker(type, (BlockEntityType)TileRegistry.RESEARCHING_TABLE.get(), ResearchingTableTile::tick);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ResearchingTableTile(pos, state);
    }

    @Mod.EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
            BlockPos pos;
            InteractionHand hand = event.getHand();
            if (hand != InteractionHand.MAIN_HAND) {
                return;
            }
            Level level = event.getLevel();
            BlockEntity blockEntity = level.m_7702_(pos = event.getPos());
            if (!(blockEntity instanceof ResearchingTableTile)) {
                return;
            }
            ResearchingTableTile tile = (ResearchingTableTile)blockEntity;
            Player player = event.getEntity();
            ItemStack handStack = player.m_21205_();
            ItemStack tileStack = tile.getStack();
            BlockState oldState = level.m_8055_(pos);
            if (tileStack.m_41619_()) {
                if (!(handStack.m_41720_() instanceof RelicItem)) {
                    return;
                }
                tile.setStack(handStack.m_41620_(1));
            } else if (player.m_6144_()) {
                ResearchUtils.setItemResearched(player, tileStack.m_41720_(), true);
                if (level.m_5776_()) {
                    ResearchingTableBlock.openGui(pos, tileStack);
                }
            } else {
                level.m_7967_((Entity)new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), tileStack));
                tile.setStack(ItemStack.f_41583_);
            }
            tile.m_6596_();
            level.m_7260_(pos, oldState, level.m_8055_(pos), 3);
        }
    }
}

