/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.patreon.pkts;

import io.github.flemmli97.tenshilib.common.network.Packet;
import io.github.flemmli97.tenshilib.patreon.PatreonDataManager;
import io.github.flemmli97.tenshilib.patreon.PatreonEffects;
import io.github.flemmli97.tenshilib.patreon.PatreonPlatform;
import io.github.flemmli97.tenshilib.patreon.RenderLocation;
import io.github.flemmli97.tenshilib.patreon.pkts.S2CEffectUpdatePkt;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class C2SEffectUpdatePkt
implements Packet {
    public static final ResourceLocation ID = new ResourceLocation("tenshilib", "c2s_patreon_effect_pkt");
    public final String id;
    public final boolean render;
    public final RenderLocation location;
    public final int color;

    public C2SEffectUpdatePkt(String id, boolean render, RenderLocation location, int color) {
        this.id = id;
        this.render = render;
        this.location = location;
        this.color = color;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130070_(this.id);
        buf.writeBoolean(this.render);
        buf.m_130068_((Enum)this.location);
        buf.writeInt(this.color);
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    public static C2SEffectUpdatePkt fromBytes(FriendlyByteBuf buf) {
        return new C2SEffectUpdatePkt(buf.m_130277_(), buf.readBoolean(), (RenderLocation)buf.m_130066_(RenderLocation.class), buf.readInt());
    }

    public static void handlePacketServer(C2SEffectUpdatePkt pkt, ServerPlayer player) {
        PatreonPlatform.INSTANCE.playerSettings((Player)player).ifPresent(settings -> {
            PatreonEffects.PatreonEffectConfig eff;
            int tier = PatreonDataManager.get(player.m_20148_().toString()).tier();
            if (tier < 1 || (eff = PatreonEffects.get(pkt.id)) == null || eff.tier > tier) {
                settings.setEffect(null);
            } else {
                settings.read(pkt, pkt.id);
            }
            PatreonPlatform.INSTANCE.sendToTracking(player, new S2CEffectUpdatePkt(player.m_19879_(), settings.effect() != null ? settings.effect().id() : "", settings.shouldRender(), settings.getRenderLocation(), settings.getColor()));
        });
    }
}

