/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.mixinhelper;

import io.github.flemmli97.tenshilib.api.item.IDualWeapon;
import io.github.flemmli97.tenshilib.mixinhelper.OffHandStrength;
import java.util.function.Consumer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class MixinUtils {
    public static InteractionHand get(LivingEntity entity, InteractionHand hand, InteractionHand prevSwungHand, Consumer<InteractionHand> update) {
        if (entity.m_9236_().f_46443_ && hand == InteractionHand.MAIN_HAND) {
            if (entity.m_21205_().m_41720_() instanceof IDualWeapon) {
                if (!entity.f_20911_ || entity.f_20913_ >= MixinUtils.getCurrentSwingDuration(entity) / 2 || entity.f_20913_ < 0) {
                    InteractionHand newHand = prevSwungHand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
                    update.accept(newHand);
                    return newHand;
                }
                return hand;
            }
            update.accept(InteractionHand.OFF_HAND);
        }
        return hand;
    }

    private static int getCurrentSwingDuration(LivingEntity entity) {
        if (MobEffectUtil.m_19584_((LivingEntity)entity)) {
            return 6 - (1 + MobEffectUtil.m_19586_((LivingEntity)entity));
        }
        if (entity.m_21023_(MobEffects.f_19599_)) {
            return 6 + (1 + entity.m_21124_(MobEffects.f_19599_).m_19564_()) * 2;
        }
        return 6;
    }

    public static float offHandHeight(Player player, float val, float offHandHeight) {
        if (!(player.m_21205_().m_41720_() instanceof IDualWeapon) || val + offHandHeight == 0.0f) {
            return val;
        }
        float strength = ((OffHandStrength)player).getOffhandStrengthScale(1.0f);
        return strength * strength * strength - offHandHeight;
    }
}

