/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.utils;

import io.github.flemmli97.tenshilib.common.utils.CircleSector;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RayTraceUtils {
    public static List<Entity> getEntities(LivingEntity entity, float reach, float aoe) {
        return RayTraceUtils.getEntities(entity, reach, aoe, null);
    }

    public static List<Entity> getEntities(LivingEntity entity, float reach, float aoe, Predicate<Entity> pred) {
        return RayTraceUtils.getEntitiesIn(entity, entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_(), 0.0), entity.m_20252_(1.0f), reach, aoe, pred);
    }

    public static List<Entity> getEntitiesIgnorePitch(LivingEntity entity, float reach, float aoe, Predicate<Entity> pred) {
        return RayTraceUtils.getEntitiesIn(entity, entity.m_20182_().m_82520_(0.0, 0.1, 0.0), Vec3.m_82498_((float)0.0f, (float)entity.m_5675_(1.0f)), reach, aoe, pred);
    }

    public static List<Entity> getEntitiesIn(LivingEntity entity, Vec3 pos, Vec3 look, float reach, float aoe, Predicate<Entity> pred) {
        CircleSector circ = new CircleSector(pos, look, reach, aoe, (Entity)entity);
        return entity.m_9236_().m_6249_((Entity)entity, entity.m_20191_().m_82400_((double)(reach + 1.0f)), t -> t != entity && (pred == null || pred.test((Entity)t)) && !t.m_7307_((Entity)entity) && t.m_6087_() && circ.intersects(t.m_9236_(), t.m_20191_().m_82377_(0.15, (double)t.m_20206_() <= 0.3 ? (double)t.m_20206_() : 0.15, 0.15)));
    }

    public static EntityHitResult calculateEntityFromLook(LivingEntity entity, float reach) {
        return RayTraceUtils.calculateEntityFromLook(entity, entity.m_20299_(1.0f), entity.m_20252_(1.0f), reach, null);
    }

    public static EntityHitResult calculateEntityFromLook(LivingEntity entity, Vec3 pos, Vec3 dir, float reach, @Nullable Predicate<Entity> pred) {
        Vec3 scaledDir = dir.m_82490_((double)reach);
        return RayTraceUtils.rayTraceEntities(entity.m_9236_(), (Entity)entity, pos, pos.m_82549_(scaledDir), entity.m_20191_().m_82369_(scaledDir).m_82400_(1.0), t -> EntitySelector.f_20408_.test(t) && t.m_6087_() && (pred == null || pred.test((Entity)t)));
    }

    @Nullable
    public static BlockPos randomPosAround(Level world, Entity e, BlockPos pos, int range, boolean grounded, Random rand) {
        int randX = pos.m_123341_() + rand.nextInt(2 * range) - range;
        int randY = pos.m_123342_() + rand.nextInt(2 * range) - range;
        int randZ = pos.m_123343_() + rand.nextInt(2 * range) - range;
        if (!grounded) {
            BlockPos pos1 = new BlockPos(randX, randY, randZ);
            while (Math.abs(randY - pos1.m_123342_()) < range && !world.m_45772_(e.m_20191_().m_82338_(pos1))) {
                pos1 = pos1.m_7494_();
            }
            if (!world.m_45772_(e.m_20191_().m_82338_(pos1))) {
                return null;
            }
            return pos1;
        }
        int y = pos.m_123342_() - range;
        BlockPos pos1 = new BlockPos(randX, y, randZ);
        while (!(pos1.m_123342_() - y >= range || world.m_8055_(pos1.m_7495_()).m_60638_((BlockGetter)world, pos1.m_7495_(), e, Direction.UP) && world.m_45772_(e.m_20191_().m_82338_(pos1)))) {
            pos1 = pos1.m_7494_();
        }
        if (!world.m_45772_(e.m_20191_().m_82338_(pos1))) {
            return null;
        }
        return pos1;
    }

    public static HitResult entityRayTrace(Entity e, float range, ClipContext.Block blockMode, ClipContext.Fluid fluidMode, boolean includeEntities, boolean getEntityHitVec, @Nullable Predicate<Entity> pred) {
        Vec3 posEye = e.m_20299_(1.0f);
        Vec3 dir = e.m_20154_().m_82490_((double)range);
        Vec3 lookPos = posEye.m_82549_(dir);
        if (includeEntities) {
            EntityHitResult entityHitResult;
            BlockHitResult raytraceresult = e.m_9236_().m_45547_(new ClipContext(posEye, lookPos, blockMode, fluidMode, e));
            if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
                lookPos = raytraceresult.m_82450_();
            }
            if ((entityHitResult = getEntityHitVec ? RayTraceUtils.rayTraceEntities(e.m_9236_(), e, posEye, lookPos, e.m_20191_().m_82369_(dir).m_82400_(1.0), pred) : ProjectileUtil.m_37304_((Level)e.m_9236_(), (Entity)e, (Vec3)posEye, (Vec3)lookPos, (AABB)e.m_20191_().m_82369_(dir).m_82400_(1.0), pred == null ? entity -> true : pred)) != null) {
                raytraceresult = entityHitResult;
            }
            return raytraceresult;
        }
        return e.m_9236_().m_45547_(new ClipContext(posEye, lookPos, blockMode, fluidMode, e));
    }

    @Nullable
    public static EntityHitResult rayTraceEntities(Entity e, Vec3 from, Vec3 to, Predicate<Entity> pred) {
        return RayTraceUtils.rayTraceEntities(e.m_9236_(), e, from, to, e.m_20191_().m_82369_(e.m_20184_()).m_82400_(1.0), pred);
    }

    @Nullable
    public static EntityHitResult rayTraceEntities(Level world, Entity e, Vec3 from, Vec3 to, AABB aabb, Predicate<Entity> pred) {
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        Vec3 hit = null;
        for (Entity entity1 : world.m_6249_(e, aabb, pred)) {
            AABB axisalignedbb = entity1.m_20191_().m_82400_((double)0.3f);
            if (axisalignedbb.m_82390_(from)) {
                entity = entity1;
                hit = from;
                if (axisalignedbb.m_82390_(to)) break;
                hit = axisalignedbb.m_82371_(from, to).orElse(from);
                break;
            }
            Optional optional = axisalignedbb.m_82371_(from, to);
            if (!optional.isPresent()) continue;
            if (d0 == 0.0) {
                entity = entity1;
                hit = (Vec3)optional.get();
                break;
            }
            double d1 = from.m_82557_((Vec3)optional.get());
            if (!(d1 < d0)) continue;
            entity = entity1;
            d0 = d1;
            hit = (Vec3)optional.get();
        }
        return entity == null ? null : new EntityHitResult(entity, hit);
    }

    public static EntityHitResult projectileRayTrace(Level world, Entity entity, Vec3 from, Vec3 to, AABB check, Predicate<Entity> pred, double radius) {
        double distVar = Double.MAX_VALUE;
        Entity ret = null;
        from = from.m_82520_(0.0, (double)entity.m_20206_() * 0.5, 0.0);
        Vec3 dir = to.m_82546_(from);
        AABB entityBB = entity.m_20191_();
        for (Entity entity1 : world.m_6249_(entity, check, pred)) {
            AABB axisalignedbb = entity1.m_20191_().m_82400_((double)0.3f);
            Pair<Vec3, Vec3> points = MathUtils.closestPointsAABB(entityBB, axisalignedbb);
            double dist = ((Vec3)points.getLeft()).m_82557_((Vec3)points.getRight());
            if (!(dist < distVar) || !(dist <= radius * radius) || radius != 0.0 && !MathUtils.isInFront(entity1.m_20182_(), from, dir)) continue;
            ret = entity1;
            distVar = dist;
        }
        return ret == null ? null : new EntityHitResult(ret);
    }

    public static List<Vector3f> rotatedVecs(Vec3 dir, Vec3 axis, float minDeg, float maxDeg, float step) {
        float y;
        ArrayList<Vector3f> list = new ArrayList<Vector3f>();
        Vector3f axisf = new Vector3f((float)axis.f_82479_, (float)axis.f_82480_, (float)axis.f_82481_);
        list.add(new Vector3f((float)dir.f_82479_, (float)dir.f_82480_, (float)dir.f_82481_));
        for (y = step; y <= maxDeg; y += step) {
            list.add(RayTraceUtils.rotatedAround(dir, axisf, y));
        }
        for (y = minDeg; y <= -step; y += step) {
            list.add(RayTraceUtils.rotatedAround(dir, axisf, y));
        }
        return list;
    }

    public static Vector3f rotatedAround(Vec3 dir, Vector3f axis, float deg) {
        Quaternionf quaternion = new Quaternionf(new AxisAngle4f((float)Math.PI / 180 * deg, (Vector3fc)axis));
        Vector3f newDir = new Vector3f((float)dir.f_82479_, (float)dir.f_82480_, (float)dir.f_82481_);
        newDir.rotate((Quaternionfc)quaternion);
        return newDir;
    }
}

