/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity;

import io.github.flemmli97.tenshilib.common.entity.EntityUtil;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public abstract class EntityDamageCloud
extends Entity
implements OwnableEntity {
    private LivingEntity shooter;
    protected int livingTicks;
    private int attackedEntities = 0;
    protected static final EntityDataAccessor<Optional<UUID>> shooterUUID = SynchedEntityData.m_135353_(EntityDamageCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Float> radius = SynchedEntityData.m_135353_(EntityDamageCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public EntityDamageCloud(EntityType<? extends EntityDamageCloud> type, Level world) {
        super(type, world);
    }

    public EntityDamageCloud(EntityType<? extends EntityDamageCloud> type, Level world, double x, double y, double z) {
        this(type, world);
        this.m_6034_(x, y, z);
    }

    public EntityDamageCloud(EntityType<? extends EntityDamageCloud> type, Level world, LivingEntity shooter) {
        this(type, world, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_());
        this.shooter = shooter;
        this.f_19804_.m_135381_(shooterUUID, Optional.of(shooter.m_20148_()));
        this.m_19915_(shooter.m_146908_(), shooter.m_146909_());
    }

    public int maxHitCount() {
        return -1;
    }

    public float radiusIncrease() {
        return 0.0f;
    }

    public double maxRadius() {
        return -1.0;
    }

    public int livingTicks() {
        return this.livingTicks;
    }

    public int livingTickMax() {
        return 200;
    }

    public boolean canHitShooter() {
        return false;
    }

    public boolean canStartDamage() {
        return this.livingTicks % 5 == 0;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(shooterUUID, Optional.empty());
        this.f_19804_.m_135372_(radius, (Object)Float.valueOf(0.0f));
    }

    public float getRadius() {
        return ((Float)this.f_19804_.m_135370_(radius)).floatValue();
    }

    public void setRadius(float val) {
        this.f_19804_.m_135381_(radius, (Object)Float.valueOf(val));
    }

    public boolean m_6783_(double distance) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.livingTicks;
        if (!this.m_9236_().f_46443_) {
            float radius;
            if (this.livingTicks > this.livingTickMax()) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
            if ((double)(radius = this.getRadius()) < this.maxRadius()) {
                this.setRadius(radius + this.radiusIncrease());
            }
            if (this.canStartDamage() && this.m_6084_()) {
                List targets = this.m_9236_().m_6443_(LivingEntity.class, this.damageBoundingBox(), this::canHit);
                for (LivingEntity living : targets) {
                    if ((this.maxHitCount() == -1 || this.attackedEntities < this.maxHitCount()) && this.damageEntity(living)) {
                        ++this.attackedEntities;
                    }
                    if (this.maxHitCount() == -1 || this.attackedEntities < this.maxHitCount()) continue;
                    this.onMaxEntities();
                    break;
                }
            }
        }
    }

    protected boolean canHit(LivingEntity entity) {
        return this.m_269323_() == null || !this.m_269323_().m_20365_((Entity)entity) && (this.canHitShooter() && this.f_19797_ > 2 || !entity.equals((Object)this.m_269323_()));
    }

    protected abstract boolean damageEntity(LivingEntity var1);

    protected void onMaxEntities() {
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    protected AABB damageBoundingBox() {
        float radius = this.getRadius();
        return this.m_20191_().m_82377_((double)radius, 0.3, (double)radius);
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128403_("Shooter")) {
            this.f_19804_.m_135381_(shooterUUID, Optional.of(compound.m_128342_("Shooter")));
        }
        this.shooter = this.m_269323_();
        this.livingTicks = compound.m_128451_("LivingTicks");
        this.attackedEntities = compound.m_128451_("AttackedEntities");
        this.f_19804_.m_135381_(radius, (Object)Float.valueOf(compound.m_128457_("Radius")));
    }

    protected void m_7380_(CompoundTag compound) {
        ((Optional)this.f_19804_.m_135370_(shooterUUID)).ifPresent(uuid -> compound.m_128362_("Shooter", uuid));
        compound.m_128405_("LivingTicks", this.livingTicks);
        compound.m_128405_("AttackedEntities", this.attackedEntities);
        compound.m_128350_("Radius", this.getRadius());
    }

    public LivingEntity m_269323_() {
        if (this.shooter != null && !this.shooter.m_213877_()) {
            return this.shooter;
        }
        ((Optional)this.f_19804_.m_135370_(shooterUUID)).ifPresent(uuid -> {
            this.shooter = EntityUtil.findFromUUID(LivingEntity.class, this.m_9236_(), uuid);
        });
        return this.shooter;
    }

    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(shooterUUID)).orElse(null);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

