/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RenderUtils {
    public static final int defaultColor = -1;
    private static final float triangleMult = (float)(Math.sqrt(3.0) / 2.0);
    private static final Random random = new Random(432L);

    public static void renderBlockOutline(PoseStack matrixStack, MultiBufferSource buffer, Player player, BlockPos pos, float partialTicks, boolean drawImmediately) {
        RenderUtils.renderBlockOutline(matrixStack, buffer, player, pos, partialTicks, 0.0f, 0.0f, 0.0f, 1.0f, drawImmediately);
    }

    public static void renderBlockOutline(PoseStack matrixStack, MultiBufferSource buffer, Player player, BlockPos pos, float partialTicks, float red, float green, float blue, float alpha, boolean drawImmediately) {
        BlockState state = player.m_9236_().m_8055_(pos);
        RenderType renderType = RenderType.m_110504_();
        Vec3 vec = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        RenderUtils.renderShape(matrixStack, buffer.m_6299_(renderType), state.m_60651_((BlockGetter)player.m_9236_(), pos, CollisionContext.m_82750_((Entity)player)), (double)pos.m_123341_() - vec.f_82479_, (double)pos.m_123342_() - vec.f_82480_, (double)pos.m_123343_() - vec.f_82481_, red, green, blue, alpha);
        if (drawImmediately && buffer instanceof MultiBufferSource.BufferSource) {
            ((MultiBufferSource.BufferSource)buffer).m_109912_(renderType);
        }
    }

    public static void renderShape(PoseStack poseStack, VertexConsumer consumer, VoxelShape shape, double x, double y, double z, float red, float green, float blue, float alpha) {
        PoseStack.Pose pose = poseStack.m_85850_();
        shape.m_83224_((k, l, m, n, o, p) -> {
            float q = (float)(n - k);
            float r = (float)(o - l);
            float s = (float)(p - m);
            float t = Mth.m_14116_((float)(q * q + r * r + s * s));
            consumer.m_252986_(pose.m_252922_(), (float)(k + x), (float)(l + y), (float)(m + z)).m_85950_(red, green, blue, alpha).m_252939_(pose.m_252943_(), q /= t, r /= t, s /= t).m_5752_();
            consumer.m_252986_(pose.m_252922_(), (float)(n + x), (float)(o + y), (float)(p + z)).m_85950_(red, green, blue, alpha).m_252939_(pose.m_252943_(), q, r, s).m_5752_();
        });
    }

    public static void renderAreaAround(PoseStack matrixStack, MultiBufferSource buffer, BlockPos pos, float radius, boolean drawImmediately) {
        RenderUtils.renderBoundingBox(matrixStack, buffer, new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).m_82400_((double)radius).m_82338_(pos.m_7495_()), drawImmediately);
    }

    public static void renderAreaAround(PoseStack matrixStack, MultiBufferSource buffer, BlockPos pos, float radius, float red, float green, float blue, float alpha, boolean ignoreDepth, boolean drawImmediately) {
        RenderUtils.renderBoundingBox(matrixStack, buffer, new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).m_82400_((double)radius).m_82338_(pos.m_7495_()), red, green, blue, alpha, drawImmediately);
    }

    public static void renderBoundingBox(PoseStack matrixStack, MultiBufferSource buffer, AABB aabb, boolean drawImmediately) {
        RenderUtils.renderBoundingBox(matrixStack, buffer, aabb, 1.0f, 0.5f, 0.5f, 1.0f, drawImmediately);
    }

    public static void renderBoundingBox(PoseStack matrixStack, MultiBufferSource buffer, AABB aabb, float red, float green, float blue, float alpha, boolean drawImmediately) {
        Vec3 vec = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        RenderType renderType = RenderType.m_110504_();
        LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)buffer.m_6299_(renderType), (AABB)aabb.m_82400_(0.002).m_82386_(-vec.f_82479_, -vec.f_82480_, -vec.f_82481_), (float)red, (float)green, (float)blue, (float)alpha);
        if (drawImmediately && buffer instanceof MultiBufferSource.BufferSource) {
            ((MultiBufferSource.BufferSource)buffer).m_109911_();
        }
    }

    public static void applyYawPitch(PoseStack stack, float yaw, float pitch) {
        stack.m_252781_(Axis.f_252436_.m_252977_(yaw));
        stack.m_252781_(Axis.f_252403_.m_252977_(pitch));
    }

    public static void renderTexture(PoseStack stack, VertexConsumer builder, float xSize, float ySize, TextureBuilder textureBuilder) {
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        Matrix3f mat3f = stack.m_85850_().m_252943_();
        builder.m_252986_(matrix4f, -(xSize /= 2.0f), ySize /= 2.0f, 0.0f).m_6122_(textureBuilder.red, textureBuilder.green, textureBuilder.blue, textureBuilder.alpha).m_7421_(textureBuilder.u, textureBuilder.v).m_86008_(textureBuilder.overlay).m_85969_(textureBuilder.light).m_252939_(mat3f, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(matrix4f, xSize, ySize, 0.0f).m_6122_(textureBuilder.red, textureBuilder.green, textureBuilder.blue, textureBuilder.alpha).m_7421_(textureBuilder.u + textureBuilder.uLength, textureBuilder.v).m_86008_(textureBuilder.overlay).m_85969_(textureBuilder.light).m_252939_(mat3f, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(matrix4f, xSize, -ySize, 0.0f).m_6122_(textureBuilder.red, textureBuilder.green, textureBuilder.blue, textureBuilder.alpha).m_7421_(textureBuilder.u + textureBuilder.uLength, textureBuilder.v + textureBuilder.vLength).m_86008_(textureBuilder.overlay).m_85969_(textureBuilder.light).m_252939_(mat3f, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(matrix4f, -xSize, -ySize, 0.0f).m_6122_(textureBuilder.red, textureBuilder.green, textureBuilder.blue, textureBuilder.alpha).m_7421_(textureBuilder.u, textureBuilder.v + textureBuilder.vLength).m_86008_(textureBuilder.overlay).m_85969_(textureBuilder.light).m_252939_(mat3f, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    public static void renderGradientBeams3d(PoseStack stack, MultiBufferSource renderTypeBuffer, float length, float width, int ticks, float partialTicks, float rotationPerTick, int amount, BeamBuilder builder) {
        stack.m_85836_();
        random.setSeed(432L);
        for (int i = 0; i < amount; ++i) {
            float ticker = (float)ticks + partialTicks;
            stack.m_252781_(Axis.f_252529_.m_252977_(random.nextFloat() * 360.0f));
            stack.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f));
            stack.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f + ticker * rotationPerTick));
            RenderUtils.renderGradientBeam3d(stack, renderTypeBuffer, length, width, builder);
        }
        stack.m_85849_();
    }

    public static void renderGradientBeam3d(PoseStack stack, MultiBufferSource renderTypeBuffer, float length, float width, BeamBuilder builder) {
        float heightHalf = triangleMult * width * 0.5f;
        float widthHalf = width * 0.5f;
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        VertexConsumer buffer = renderTypeBuffer.m_6299_(builder.renderType);
        buffer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(builder.red, builder.green, builder.blue, builder.alpha).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(builder.red, builder.green, builder.blue, builder.alpha).m_5752_();
        buffer.m_252986_(matrix4f, -widthHalf, length, -heightHalf).m_6122_(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha).m_5752_();
        buffer.m_252986_(matrix4f, widthHalf, length, -heightHalf).m_6122_(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(builder.red, builder.green, builder.blue, builder.alpha).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(builder.red, builder.green, builder.blue, builder.alpha).m_5752_();
        buffer.m_252986_(matrix4f, widthHalf, length, -heightHalf).m_6122_(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, length, heightHalf).m_6122_(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(builder.red, builder.green, builder.blue, builder.alpha).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(builder.red, builder.green, builder.blue, builder.alpha).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, length, heightHalf).m_6122_(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha).m_5752_();
        buffer.m_252986_(matrix4f, -widthHalf, length, -heightHalf).m_6122_(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha).m_5752_();
    }

    public static void renderGradientBeams(PoseStack matrixStack, MultiBufferSource renderTypeBuffer, float length, float width, int ticks, float partialTicks, float rotationPerTick, int amount, BeamBuilder builder) {
        matrixStack.m_85836_();
        random.setSeed(432L);
        for (int i = 0; i < amount; ++i) {
            float ticker = (float)ticks + partialTicks;
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(random.nextFloat() * 360.0f));
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f));
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f + ticker * rotationPerTick));
            RenderUtils.renderGradientBeam(matrixStack, renderTypeBuffer, length, width, builder);
        }
        matrixStack.m_85849_();
    }

    public static void renderGradientBeam(PoseStack matrixStack, MultiBufferSource renderTypeBuffer, float length, float width, BeamBuilder builder) {
        float widthHalf = width * 0.5f;
        Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
        VertexConsumer buffer = renderTypeBuffer.m_6299_(builder.renderType);
        buffer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(builder.red, builder.green, builder.blue, builder.alpha).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(builder.red, builder.green, builder.blue, builder.alpha).m_5752_();
        buffer.m_252986_(matrix4f, -widthHalf, length, 0.0f).m_6122_(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha).m_5752_();
        buffer.m_252986_(matrix4f, widthHalf, length, 0.0f).m_6122_(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(builder.red, builder.green, builder.blue, builder.alpha).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(builder.red, builder.green, builder.blue, builder.alpha).m_5752_();
        buffer.m_252986_(matrix4f, widthHalf, length, 0.0f).m_6122_(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha).m_5752_();
        buffer.m_252986_(matrix4f, -widthHalf, length, 0.0f).m_6122_(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha).m_5752_();
    }

    public static class TextureBuilder {
        private int red = 255;
        private int green = 255;
        private int blue = 255;
        private int alpha = 255;
        private float u;
        private float v;
        private float uLength = 1.0f;
        private float vLength = 1.0f;
        private int light = 0xF000F0;
        private int overlay = OverlayTexture.f_118083_;

        public void setUV(float u, float v) {
            this.u = u;
            this.v = v;
        }

        public void setUVLength(float uLength, float vLength) {
            this.uLength = uLength;
            this.vLength = vLength;
        }

        public void setColor(int hexColor) {
            int red = hexColor >> 16 & 0xFF;
            int green = hexColor >> 8 & 0xFF;
            int blue = hexColor & 0xFF;
            int alpha = hexColor >> 24 & 0xFF;
            this.setColor(red, green, blue, alpha);
        }

        public void setColor(int red, int green, int blue, int alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        public void setColor(float red, float green, float blue, float alpha) {
            this.setColor((int)red * 255, (int)green * 255, (int)blue * 255, (int)alpha * 255);
        }

        public void setOverlay(int overlay) {
            this.overlay = overlay;
        }

        public void setLight(int light) {
            this.light = light;
        }
    }

    public static class BeamBuilder {
        private int red = 255;
        private int green = 255;
        private int blue = 255;
        private int alpha = 255;
        private int endRed = 255;
        private int endGreen = 0;
        private int endBlue = 255;
        private int endAlpha = 0;
        private RenderType renderType = RenderType.m_110502_();

        public void setStartColor(int hexColor) {
            int red = hexColor >> 16 & 0xFF;
            int green = hexColor >> 8 & 0xFF;
            int blue = hexColor & 0xFF;
            int alpha = hexColor >> 24 & 0xFF;
            this.setStartColor(red, green, blue, alpha);
        }

        public void setStartColor(int red, int green, int blue, int alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        public void setEndColor(int hexColor) {
            int red = hexColor >> 16 & 0xFF;
            int green = hexColor >> 8 & 0xFF;
            int blue = hexColor & 0xFF;
            int alpha = hexColor >> 24 & 0xFF;
            this.setEndColor(red, green, blue, alpha);
        }

        public void setEndColor(int red, int green, int blue, int alpha) {
            this.endRed = red;
            this.endGreen = green;
            this.endBlue = blue;
            this.endAlpha = alpha;
        }

        public void setRenderType(RenderType renderType) {
            this.renderType = renderType;
        }
    }
}

