/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client;

import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.IAnimated;
import io.github.flemmli97.tenshilib.api.entity.IOverlayEntityRender;
import io.github.flemmli97.tenshilib.client.CustomRiderRendererManager;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ClientHandlers {
    public static final Set<UUID> RIDING_RENDER_BLACKLIST = new HashSet<UUID>();

    public static void updateAnim(int entityID, int animID) {
        Minecraft mc = Minecraft.m_91087_();
        Entity e = mc.f_91073_.m_6815_(entityID);
        if (e instanceof IAnimated) {
            IAnimated anim = (IAnimated)e;
            anim.getAnimationHandler().setAnimation(animID == -2 ? null : (animID == -1 ? AnimatedAction.vanillaAttack : anim.getAnimationHandler().getAnimations()[animID]));
        }
    }

    public static int getColor(LivingEntity entity, float f) {
        IOverlayEntityRender overlay = (IOverlayEntityRender)entity;
        int oV = (int)(f * 15.0f);
        int oU = entity.f_20916_ > 0 || entity.f_20919_ > 0 ? 3 : 10;
        return OverlayTexture.m_118093_((int)overlay.overlayU(oV), (int)overlay.overlayV(oU));
    }

    public static Player clientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static boolean shouldDisableRender(Entity entity) {
        Entity entity2 = entity.m_20202_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity vehicle = (LivingEntity)entity2;
            if (CustomRiderRendererManager.getInstance().hasRiderLayerRenderer(vehicle.m_6095_())) {
                if (RIDING_RENDER_BLACKLIST.contains(entity.m_20148_())) {
                    return false;
                }
                return entity != Minecraft.m_91087_().f_91074_ || !Minecraft.m_91087_().f_91066_.m_92176_().m_90612_();
            }
        }
        return false;
    }
}

