/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.api.entity;

import net.minecraft.util.Mth;

public class AnimatedAction {
    public static final AnimatedAction vanillaAttack = new AnimatedAction(20, 1, "vanilla");
    public static final AnimatedAction[] vanillaAttackOnly = new AnimatedAction[]{vanillaAttack};
    private final int length;
    private final int attackTime;
    private final int fadeTick;
    private final boolean shouldRunOut;
    private final String id;
    private final String animationClient;
    private final float speed;
    private float ticker;

    public AnimatedAction(double length, String id) {
        this((int)Math.ceil(length * 20.0), id);
    }

    public AnimatedAction(int length, String id) {
        this(length, 1, id, id, 1.0f, true, 0);
    }

    public AnimatedAction(double length, double attackTime, String id) {
        this((int)Math.ceil(length * 20.0), (int)Math.ceil(attackTime * 20.0), id, id, 1.0f, true, 0);
    }

    public AnimatedAction(int length, int attackTime, String id) {
        this(length, attackTime, id, id, 1.0f, true, 0);
    }

    private AnimatedAction(int length, int attackTime, String id, String animationClient, float speedMod, boolean shouldRunOut, int fadeTick) {
        this.speed = speedMod;
        this.length = Math.max(1, length);
        this.attackTime = Mth.m_14045_((int)attackTime, (int)1, (int)this.length);
        this.id = id;
        this.animationClient = animationClient;
        this.shouldRunOut = shouldRunOut;
        this.fadeTick = fadeTick;
    }

    public static AnimatedAction copyOf(AnimatedAction animatedAction, String id) {
        return new AnimatedAction(animatedAction.length, animatedAction.attackTime, id, animatedAction.animationClient, animatedAction.speed, animatedAction.shouldRunOut, animatedAction.fadeTick);
    }

    public static Builder builder(int length, String id) {
        return new Builder(length, id);
    }

    public AnimatedAction create() {
        return new AnimatedAction(this.length, this.attackTime, this.id, this.animationClient, this.speed, this.shouldRunOut, this.fadeTick);
    }

    public boolean tick() {
        return this.tick(1);
    }

    public boolean tick(int offSet) {
        float f;
        this.ticker += 1.0f * this.speed;
        return f >= (float)(this.length + offSet) && this.shouldRunOut;
    }

    public boolean canAttack() {
        return this.ticker == (float)this.attackTime;
    }

    public int getTick() {
        return (int)this.ticker;
    }

    public int getLength() {
        return this.length;
    }

    public int getAttackTime() {
        return this.attackTime;
    }

    public void reset() {
        this.ticker = 0.0f;
    }

    public String getID() {
        return this.id;
    }

    public boolean is(AnimatedAction ... others) {
        for (AnimatedAction other : others) {
            if (other == null || !this.id.equals(other.id)) continue;
            return true;
        }
        return false;
    }

    public String getAnimationClient() {
        return this.animationClient;
    }

    public boolean shouldRunOut() {
        return this.shouldRunOut;
    }

    public int getFadeTick() {
        return this.fadeTick;
    }

    public String toString() {
        return "ID: " + this.id + "; length: " + this.length + "; attackTime: " + this.attackTime + "; speed: " + this.speed;
    }

    public boolean equals(Object o) {
        if (o instanceof AnimatedAction) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static class Builder {
        private final int length;
        private int attackTime = 1;
        private int fadeTick;
        private boolean shouldRunOut = true;
        private final String id;
        private String animationClient;
        private float speed = 1.0f;

        public Builder(int length, String id) {
            this.length = Math.max(1, length);
            this.id = id;
            this.animationClient = id;
        }

        public Builder withClientID(String id) {
            this.animationClient = id;
            return this;
        }

        public Builder marker(int time) {
            this.attackTime = Mth.m_14045_((int)time, (int)1, (int)this.length);
            return this;
        }

        public Builder infinite() {
            this.shouldRunOut = false;
            return this;
        }

        public Builder speed(float speed) {
            this.speed = speed;
            return this;
        }

        public Builder changeDelay(int delay) {
            this.fadeTick = delay;
            return this;
        }

        public AnimatedAction build() {
            return new AnimatedAction(this.length, this.attackTime, this.id, this.animationClient, this.speed, this.shouldRunOut, this.fadeTick);
        }
    }
}

