/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.util;

import com.mojang.datafixers.util.Pair;
import com.tom.createores.CreateOreExcavation;
import com.tom.createores.OreDataCapability;
import com.tom.createores.recipe.VeinRecipe;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;

public class RandomSpreadGenerator {
    private List<VeinRecipe> recipes = new ArrayList<VeinRecipe>();

    public void loadAll(ServerLevel level) {
        this.recipes.addAll(level.m_7465_().m_44013_(CreateOreExcavation.VEIN_RECIPES.getRecipeType()));
        this.recipes.sort(Comparator.comparingInt(VeinRecipe::getNegGenerationPriority).thenComparing(VeinRecipe::m_6423_));
    }

    public VeinRecipe pick(LevelChunk chunk) {
        int x = chunk.m_7697_().f_45578_;
        int z = chunk.m_7697_().f_45579_;
        int minY = QuartPos.m_175400_((int)chunk.m_141937_());
        int maxY = minY + QuartPos.m_175400_((int)chunk.m_141928_()) - 1;
        ServerLevel level = (ServerLevel)chunk.m_62953_();
        for (VeinRecipe recipe : this.recipes) {
            ChunkPos chunkpos = recipe.getPlacement().m_227008_(level.m_7328_(), x, z);
            if (chunkpos.f_45578_ != x || chunkpos.f_45579_ != z) continue;
            WorldgenRandom rng = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
            rng.m_190068_(level.m_7328_(), x, z);
            Holder biome = chunk.m_203495_(rng.m_188503_(4), minY + rng.m_188503_(maxY), rng.m_188503_(4));
            if (!recipe.canGenerate(level, (Holder<Biome>)biome)) continue;
            return recipe;
        }
        return null;
    }

    private VeinRecipe pick(ServerLevel level, ChunkPos chunk, VeinRecipe last) {
        int minY = QuartPos.m_175400_((int)level.m_141937_());
        int maxY = minY + QuartPos.m_175400_((int)level.m_141928_()) - 1;
        for (VeinRecipe recipe : this.recipes) {
            ChunkPos chunkpos = recipe.getPlacement().m_227008_(level.m_7328_(), chunk.f_45578_, chunk.f_45579_);
            if (chunkpos.f_45578_ == chunk.f_45578_ && chunkpos.f_45579_ == chunk.f_45579_) {
                WorldgenRandom rng = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
                rng.m_190068_(level.m_7328_(), chunk.f_45578_, chunk.f_45579_);
                BlockPos pos = new BlockPos(QuartPos.m_175402_((int)rng.m_188503_(4)), QuartPos.m_175402_((int)(minY + rng.m_188503_(maxY))), QuartPos.m_175402_((int)rng.m_188503_(4))).m_121955_((Vec3i)chunk.m_45615_());
                if (level.m_215069_(b -> recipe.canGenerate(level, (Holder<Biome>)b), pos, 1, 1, 1) != null) {
                    return recipe;
                }
            }
            if (recipe != last) continue;
            break;
        }
        return null;
    }

    public BlockPos locate(ResourceLocation id, BlockPos pPos, ServerLevel level, int radius) {
        Recipe recipe = level.m_7465_().m_44043_(id).orElse(null);
        if (recipe instanceof VeinRecipe) {
            VeinRecipe r = (VeinRecipe)recipe;
            int i = SectionPos.m_123171_((int)pPos.m_123341_());
            int j = SectionPos.m_123171_((int)pPos.m_123343_());
            for (int k = 0; k <= radius; ++k) {
                BlockPos pos = this.getNearestGenerated(level, i, j, k, level.m_7328_(), r);
                if (pos == null) continue;
                return pos;
            }
        }
        return null;
    }

    public Pair<BlockPos, VeinRecipe> locate(BlockPos pPos, ServerLevel level, int radius) {
        int i = SectionPos.m_123171_((int)pPos.m_123341_());
        int j = SectionPos.m_123171_((int)pPos.m_123343_());
        for (int k = 0; k <= radius; ++k) {
            Pair found = null;
            float dist = Float.MAX_VALUE;
            for (int j2 = 0; j2 < this.recipes.size(); ++j2) {
                OreDataCapability.OreData data;
                float d;
                VeinRecipe r = this.recipes.get(j2);
                BlockPos pos = this.getNearestGenerated(level, i, j, k, level.m_7328_(), r);
                if (pos == null || !((d = RandomSpreadGenerator.distance2d(pos, pPos)) < dist) || level.m_46749_(pos) && (r = (data = OreDataCapability.getData(level.m_46745_(pos))).getRecipe(level.m_7465_())) == null) continue;
                found = Pair.of((Object)pos, (Object)r);
                dist = d;
            }
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private BlockPos getNearestGenerated(ServerLevel pLevel, int pX, int pY, int pZ, long pSeed, VeinRecipe recipe) {
        RandomSpreadStructurePlacement pSpreadPlacement = recipe.getPlacement();
        int i = pSpreadPlacement.m_205003_();
        for (int j = -pZ; j <= pZ; ++j) {
            boolean flag = j == -pZ || j == pZ;
            for (int k = -pZ; k <= pZ; ++k) {
                int i1;
                int l;
                ChunkPos chunkpos;
                VeinRecipe picked;
                boolean flag1;
                boolean bl = flag1 = k == -pZ || k == pZ;
                if (!flag && !flag1 || (picked = this.pick(pLevel, chunkpos = pSpreadPlacement.m_227008_(pSeed, l = pX + i * j, i1 = pY + i * k), recipe)) != recipe) continue;
                return chunkpos.m_151394_(0);
            }
        }
        return null;
    }

    public static float distance2d(BlockPos a, BlockPos b) {
        int i = b.m_123341_() - a.m_123341_();
        int j = b.m_123343_() - a.m_123343_();
        return Mth.m_14116_((float)(i * i + j * j));
    }
}

