/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.item;

import com.mojang.datafixers.util.Pair;
import com.tom.createores.Config;
import com.tom.createores.OreDataCapability;
import com.tom.createores.OreVeinGenerator;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.ComponentJoiner;
import com.tom.createores.util.RandomSpreadGenerator;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class OreVeinFinderItem
extends Item {
    public OreVeinFinderItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        if (!level.f_46443_) {
            this.detect(level, player.m_20183_(), player);
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(interactionHand));
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        if (!ctx.m_43725_().f_46443_) {
            this.detect(ctx.m_43725_(), ctx.m_8083_(), ctx.m_43723_());
        }
        return InteractionResult.SUCCESS;
    }

    private void detect(Level level, BlockPos pos, Player player) {
        ChunkPos center = new ChunkPos(pos);
        OreDataCapability.OreData found = null;
        ArrayList<OreDataCapability.OreData> nearby = new ArrayList<OreDataCapability.OreData>();
        int near = Config.veinFinderNear;
        for (int x = -near; x <= near; ++x) {
            for (int z = -near; z <= near; ++z) {
                OreDataCapability.OreData d2 = OreDataCapability.getData(level.m_6325_(center.f_45578_ + x, center.f_45579_ + z));
                if (x == 0 && z == 0) {
                    found = d2;
                    continue;
                }
                nearby.add(d2);
            }
        }
        player.m_5661_((Component)Component.m_237115_((String)"chat.coe.veinFinder.info"), false);
        player.m_5661_((Component)Component.m_237110_((String)"chat.coe.veinFinder.pos", (Object[])new Object[]{center.f_45578_, center.f_45579_}), false);
        RecipeManager m = level.m_7465_();
        MutableComponent nothing = Component.m_237115_((String)"chat.coe.veinFinder.nothing");
        MutableComponent comma = Component.m_237113_((String)", ");
        Object f = found != null && found.getRecipe(m) != null ? found.getRecipe(m).getName() : nothing;
        player.m_5661_((Component)Component.m_237110_((String)"chat.coe.veinFinder.found", (Object[])new Object[]{f}), false);
        f = nearby.stream().map(d -> d.getRecipe(m)).filter(r -> r != null).map(r -> r.getName()).collect(ComponentJoiner.joining((Component)nothing, (Component)comma));
        player.m_5661_((Component)Component.m_237110_((String)"chat.coe.veinFinder.nearby", (Object[])new Object[]{f}), false);
        Pair<BlockPos, VeinRecipe> nearest = OreVeinGenerator.getPicker((ServerLevel)level).locate(pos, (ServerLevel)level, 16);
        if (nearest != null) {
            BlockPos at = (BlockPos)nearest.getFirst();
            int i = Math.round(RandomSpreadGenerator.distance2d(at, pos) / (float)Config.veinFinderFar) * Config.veinFinderFar;
            player.m_5661_((Component)Component.m_237110_((String)"chat.coe.veinFinder.far", (Object[])new Object[]{Component.m_237110_((String)"chat.coe.veinFinder.distance", (Object[])new Object[]{((VeinRecipe)nearest.getSecond()).getName(), i})}), false);
        } else {
            player.m_5661_((Component)Component.m_237110_((String)"chat.coe.veinFinder.far", (Object[])new Object[]{nothing}), false);
        }
        player.m_36335_().m_41524_((Item)this, Config.veinFinderCd);
    }
}

