/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.biome_provider.region;

import com.legacy.blue_skies.world.biome_provider.region.BiomeRegion;
import com.legacy.blue_skies.world.biome_provider.region.HeightRegion;

public class BakedWorldRegion {
    private final double coordScale;
    private final int biomeSize;
    private final byte[] biomes;
    private final int heightSize;
    private final short[] heights;

    public BakedWorldRegion(BiomeRegion biomeRegion, HeightRegion heightRegion) {
        if (biomeRegion.scale != heightRegion.scale) {
            throw new IllegalStateException("The BiomeRegion has a different scale than the HeightRegion at x=" + biomeRegion.regionX * 1024 + " z=" + biomeRegion.regionZ * 1024);
        }
        biomeRegion.bake();
        heightRegion.bake();
        this.coordScale = (double)biomeRegion.scale / 1024.0;
        int[][] biomes = biomeRegion.getData();
        this.biomeSize = biomes.length;
        this.biomes = new byte[this.biomeSize * this.biomeSize];
        for (int x = 0; x < this.biomeSize; ++x) {
            for (int z = 0; z < this.biomeSize; ++z) {
                this.biomes[x * this.biomeSize + z] = (byte)biomes[x][z];
            }
        }
        int[][] heights = heightRegion.getData();
        this.heightSize = heights.length;
        this.heights = new short[this.heightSize * this.heightSize];
        for (int x = 0; x < this.heightSize; ++x) {
            for (int z = 0; z < this.heightSize; ++z) {
                this.heights[x * this.heightSize + z] = (short)heights[x][z];
            }
        }
    }

    public int getBiome(int x, int z) {
        return this.getWithinScale(this.biomes, this.biomeSize, x, z);
    }

    public int getHeight(int x, int z) {
        return this.getWithinScale(this.heights, this.heightSize, x, z);
    }

    private byte getWithinScale(byte[] data, int size, int x, int z) {
        if (this.coordScale != 1.0) {
            x = (int)Math.floor((double)x * this.coordScale);
            z = (int)Math.floor((double)z * this.coordScale);
        }
        int s = size - 1;
        return data[(x & s) * size + (z & s)];
    }

    private short getWithinScale(short[] data, int size, int x, int z) {
        if (this.coordScale != 1.0) {
            x = (int)Math.floor((double)x * this.coordScale);
            z = (int)Math.floor((double)z * this.coordScale);
        }
        int s = size - 1;
        return data[(x & s) * size + (z & s)];
    }
}

