/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.biome_provider.provider;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.world.SkiesBiomeSource;
import com.legacy.blue_skies.world.biome_provider.biomes.BiomeIds;
import com.legacy.blue_skies.world.biome_provider.region.BakedWorldRegion;
import com.legacy.blue_skies.world.biome_provider.region.BiomeRegion;
import com.legacy.blue_skies.world.biome_provider.region.HeightRegion;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;

public abstract class AbstractBiomeProvider {
    private final EnumMap<BiomeIds.Temperature, int[]> landBiomes = new EnumMap(BiomeIds.Temperature.class);
    private final EnumMap<BiomeIds.Temperature, int[]> oceanBiomes = new EnumMap(BiomeIds.Temperature.class);
    private static final List<ResourceKey<Level>> TRACKED_LEVELS = new ArrayList<ResourceKey<Level>>(2);
    public final int minY;
    public final int maxY;
    private final Long2ObjectLinkedOpenHashMap<BakedWorldRegion> cache;
    private static final int BASE_CACHE_SIZE = 7;
    private int cacheSize = 7;
    public Long seed = null;
    public PerlinSimplexNoise noiseA = null;
    public PerlinSimplexNoise noiseB = null;
    public PerlinSimplexNoise noiseC = null;

    public AbstractBiomeProvider(ResourceKey<Level> level, int minY, int height) {
        if (!TRACKED_LEVELS.contains(level)) {
            TRACKED_LEVELS.add(level);
        }
        this.minY = minY;
        this.maxY = height + minY;
        this.cache = new Long2ObjectLinkedOpenHashMap();
        this.bakeBiomeTemps(this.getLandBiomes(), this.landBiomes);
        this.bakeBiomeTemps(this.getOceanBiomes(), this.oceanBiomes);
    }

    public abstract int[] getLandBiomes();

    public abstract int[] getOceanBiomes();

    public void bakeBiomeTemps(int[] biomes, EnumMap<BiomeIds.Temperature, int[]> finalMap) {
        if (biomes.length == 0) {
            throw new IllegalStateException("The biomes array was empty. At least one ocean and land biome must be defined, even if they are not normally used.");
        }
        EnumMap biomeMap = new EnumMap(BiomeIds.Temperature.class);
        for (BiomeIds.Temperature temp : BiomeIds.Temperature.values()) {
            biomeMap.put(temp, new ArrayList());
        }
        for (int biome : biomes) {
            for (BiomeIds.Temperature biomeTemp : BiomeIds.getData(biome).temperatures()) {
                ((List)biomeMap.get((Object)biomeTemp)).add(biome);
            }
        }
        BiomeIds.Temperature[] temperatureArray = BiomeIds.Temperature.values();
        int n = temperatureArray.length;
        for (int j = 0; j < n; ++j) {
            BiomeIds.Temperature temp;
            List biomesForTemp = (List)biomeMap.get((Object)(temp = temperatureArray[j]));
            finalMap.put(temp, biomesForTemp.isEmpty() ? biomes : biomesForTemp.stream().mapToInt(i -> i).toArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BakedWorldRegion getWorldRegion(ChunkPos chunkPos) {
        int regionX = (int)Math.floor((double)chunkPos.f_45578_ / 64.0);
        int regionZ = (int)Math.floor((double)chunkPos.f_45579_ / 64.0);
        long pos = ChunkPos.m_45589_((int)regionX, (int)regionZ);
        Long2ObjectLinkedOpenHashMap<BakedWorldRegion> long2ObjectLinkedOpenHashMap = this.cache;
        synchronized (long2ObjectLinkedOpenHashMap) {
            BakedWorldRegion worldRegion = (BakedWorldRegion)this.cache.getAndMoveToLast(pos);
            if (worldRegion != null) {
                return worldRegion;
            }
            worldRegion = this.timeBench("Calculating", () -> {
                BiomeRegion biomeRegion = this.timeBench("  Biomes", () -> {
                    BiomeRegion bRegion = new BiomeRegion(this, regionX, regionZ, 4);
                    this.transformBiomes(bRegion);
                    return bRegion;
                });
                HeightRegion heightRegion = this.timeBench("  Heights", () -> {
                    HeightRegion hRegion = new HeightRegion(this, regionX, regionZ, biomeRegion.getScale(), biomeRegion);
                    this.transformHeights(hRegion);
                    return hRegion;
                });
                return new BakedWorldRegion(biomeRegion, heightRegion);
            });
            this.cache.put(pos, (Object)worldRegion);
            while (this.cache.size() > this.cacheSize) {
                this.cache.removeFirst();
            }
            return worldRegion;
        }
    }

    private <T> T timeBench(String label, Supplier<T> runner) {
        return runner.get();
    }

    public abstract void transformBiomes(BiomeRegion var1);

    public abstract void transformHeights(HeightRegion var1);

    public int getBiomeForTemp(BiomeIds.Temperature temp, boolean isOcean, Random rand) {
        int[] biomes = (isOcean ? this.oceanBiomes : this.landBiomes).get((Object)temp);
        return biomes[rand.nextInt(biomes.length)];
    }

    public Holder<Biome> getBiome(HolderGetter<Biome> registry, Map<ResourceLocation, Holder<Biome>> allBiomes, int x, int y, int z) {
        ChunkPos chunkPos = new ChunkPos(x >> 4, z >> 4);
        Holder<Biome> biome = allBiomes.get(BiomeIds.getName(this.getWorldRegion(chunkPos).getBiome(x, z)));
        if (biome == null) {
            BlueSkies.LOGGER.warn("Blue Skies found an invalid biome at chunk ({}, {}) using {}", (Object)chunkPos.f_45578_, (Object)chunkPos.f_45579_, (Object)this.getClass().getCanonicalName());
            return registry.m_255043_(Biomes.f_48202_);
        }
        return biome;
    }

    public int getHeight(int x, int z) {
        return this.getWorldRegion(new ChunkPos(new BlockPos(x, 0, z))).getHeight(x, z);
    }

    public void setSeed(long seed) {
        if (this.seed == null) {
            this.seed = seed;
            this.noiseA = new PerlinSimplexNoise(WorldgenRandom.Algorithm.LEGACY.m_224687_(seed), List.of(Integer.valueOf(0)));
            this.noiseB = new PerlinSimplexNoise(WorldgenRandom.Algorithm.LEGACY.m_224687_(seed + 10L), List.of(Integer.valueOf(0)));
            this.noiseC = new PerlinSimplexNoise(WorldgenRandom.Algorithm.LEGACY.m_224687_(seed + 20L), List.of(Integer.valueOf(0)));
        }
    }

    public static void updateCacheSize(MinecraftServer server) {
        for (ResourceKey<Level> levelKey : TRACKED_LEVELS) {
            ServerLevel level = server.m_129880_(levelKey);
            BiomeSource biomeSource = level.m_7726_().m_8481_().m_62218_();
            if (!(biomeSource instanceof SkiesBiomeSource)) continue;
            ((SkiesBiomeSource)biomeSource).updateBiomeProviderCache(level.m_6907_().size());
        }
    }

    public void updateCacheSize(int playerCount) {
        this.cacheSize = Math.max(playerCount, 1) * 7;
    }
}

