/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.providers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.crafting.ToolRecipe;
import com.legacy.blue_skies.data.objects.tags.SkiesItemTags;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesRecipes;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.triggers.SpecialArachnarchTrigger;
import com.legacy.blue_skies.triggers.SpecialCrusherTrigger;
import com.legacy.blue_skies.triggers.UsedAlchemyTableTrigger;
import com.legacy.blue_skies.triggers.UsedToolboxTrigger;
import com.legacy.blue_skies.util.StringUtil;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.ChangeDimensionTrigger;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.advancements.critereon.SummonedEntityTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;

public class SkiesAdvancementProv
extends ForgeAdvancementProvider {
    private static final Logger LOGGER = BlueSkies.makeLogger(SkiesAdvancementProv.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public SkiesAdvancementProv(DataGenerator gen, CompletableFuture<HolderLookup.Provider> lookup, ExistingFileHelper existingFileHelper) {
        super(gen.getPackOutput(), lookup, existingFileHelper, List.of(new BlueSkiesAdvancements()));
    }

    private static class BlueSkiesAdvancements
    implements ForgeAdvancementProvider.AdvancementGenerator {
        private String section = "";

        private BlueSkiesAdvancements() {
        }

        public void generate(HolderLookup.Provider lookup, Consumer<Advancement> saver, ExistingFileHelper existingFileHelper) {
            this.toolRecipes(saver);
            Advancement root = this.builder((ItemLike)SkiesItems.multi_portal_item, "root", BlueSkies.locate("textures/block/dungeon/blinding_stone.png"), FrameType.TASK, false, false, false).m_138360_(RequirementsStrategy.f_15979_).m_138386_("enter_everbright", (CriterionTriggerInstance)this.changeDim(BlueSkiesAdvancements.genEverbrightKey())).m_138386_("enter_everdawn", (CriterionTriggerInstance)this.changeDim(BlueSkiesAdvancements.genEverdawnKey())).m_138389_(saver, BlueSkies.find("root"));
            Advancement thinkingPortals = this.builder((ItemLike)SkiesItems.zeal_lighter, "thinking_with_portals", FrameType.TASK, true, true, false).m_138398_(root).m_138386_("enter_everbright", (CriterionTriggerInstance)this.changeDim(BlueSkiesAdvancements.genEverbrightKey())).m_138386_("enter_everdawn", (CriterionTriggerInstance)this.changeDim(BlueSkiesAdvancements.genEverdawnKey())).m_138389_(saver, BlueSkies.find("thinking_with_portals"));
            Advancement moonstoneShard = this.builder((ItemLike)SkiesItems.moonstone_shard, "get_moonstone_shard", FrameType.TASK, true, true, false).m_138398_(thinkingPortals).m_138386_("obtain_moonstone_shard", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{SkiesItems.moonstone_shard})).m_138389_(saver, BlueSkies.find("get_moonstone_shard"));
            Advancement pyrope = this.builder((ItemLike)SkiesItems.pyrope_gem, "get_pyrope", FrameType.TASK, true, true, false).m_138398_(moonstoneShard).m_138386_("obtain_material", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{SkiesItems.pyrope_gem})).m_138389_(saver, BlueSkies.find("get_pyrope"));
            Advancement aquite = this.builder((ItemLike)SkiesItems.aquite, "get_aquite", FrameType.TASK, true, true, false).m_138398_(pyrope).m_138386_("obtain_material", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{SkiesItems.aquite})).m_138389_(saver, BlueSkies.find("get_aquite"));
            Advancement diopside = this.builder((ItemLike)SkiesItems.diopside_gem, "get_diopside", FrameType.TASK, true, true, false).m_138398_(aquite).m_138386_("obtain_material", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{SkiesItems.diopside_gem})).m_138389_(saver, BlueSkies.find("get_diopside"));
            Advancement charoite = this.builder((ItemLike)SkiesItems.charoite, "get_charoite", FrameType.TASK, true, true, false).m_138398_(aquite).m_138386_("obtain_material", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{SkiesItems.charoite})).m_138389_(saver, BlueSkies.find("get_charoite"));
            Advancement foodPrepTable = this.builder((ItemLike)SkiesBlocks.food_prep_table, "craft_food_prep_table", FrameType.TASK, true, true, false).m_138398_(thinkingPortals).m_138386_("obtain_prep_table", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{SkiesBlocks.food_prep_table})).m_138389_(saver, BlueSkies.find("craft_food_prep_table"));
            Advancement enterBlindingDungeon = this.enterAnyStructure(this.builder((ItemLike)SkiesBlocks.bright_blinding_keystone, "enter_blinding_dungeon", FrameType.GOAL, true, true, false).m_138398_(thinkingPortals).m_138360_(RequirementsStrategy.f_15979_), List.of(SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getStructure().getKey(), SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructure().getKey())).m_138389_(saver, BlueSkies.find("enter_blinding_dungeon"));
            Advancement keys = this.builder((ItemLike)SkiesItems.blinding_key, "keys", FrameType.TASK, true, true, false).m_138398_(enterBlindingDungeon).m_138386_("obtain_key", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{SkiesItems.blinding_key})).m_138389_(saver, BlueSkies.find("keys"));
            Advancement regrowth = this.builder((ItemLike)SkiesBlocks.comet_sapling, "regrowth", FrameType.TASK, true, true, false).m_138398_(keys).m_138386_("have_sapling", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{SkiesBlocks.comet_sapling})).m_138389_(saver, BlueSkies.find("regrowth"));
            Advancement cometPie = this.builder((ItemLike)SkiesBlocks.comet_berry_pie, "blue_sky_pie", FrameType.GOAL, true, true, false).m_138398_(regrowth).m_138386_("have_pie", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{SkiesBlocks.comet_berry_pie})).m_138389_(saver, BlueSkies.find("blue_sky_pie"));
            this.setSection("everbright");
            Advancement enterBright = this.builder((ItemLike)SkiesBlocks.everbright_portal, "enter", FrameType.TASK, true, true, false).m_138398_(root).m_138386_("enter_everbright", (CriterionTriggerInstance)this.changeDim(BlueSkiesAdvancements.genEverbrightKey())).m_138389_(saver, BlueSkies.find("everbright/enter"));
            Advancement getWoodBright = this.haveAnyItem(this.builder((ItemLike)SkiesBlocks.bluebright_log, "get_wood", FrameType.TASK, true, true, false).m_138398_(enterBright).m_138360_(RequirementsStrategy.f_15979_), List.of(SkiesBlocks.bluebright_log, SkiesBlocks.bluebright_wood, SkiesBlocks.starlit_log, SkiesBlocks.starlit_wood, SkiesBlocks.frostbright_log, SkiesBlocks.frostbright_wood)).m_138389_(saver, BlueSkies.find("everbright/get_wood"));
            Advancement snowcapOven = this.builder((ItemLike)SkiesBlocks.snowcap_oven, "craft_snowcap_oven", FrameType.TASK, true, true, false).m_138398_(getWoodBright).m_138386_("obtain_oven", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{SkiesBlocks.snowcap_oven})).m_138389_(saver, BlueSkies.find("everbright/craft_snowcap_oven"));
            Advancement falsite = this.builder((ItemLike)SkiesItems.falsite_ingot, "get_falsite", FrameType.TASK, true, true, false).m_138398_(getWoodBright).m_138386_("obtain_material", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{SkiesItems.falsite_ingot})).m_138389_(saver, BlueSkies.find("everbright/get_falsite"));
            Advancement ventium = this.builder((ItemLike)SkiesItems.ventium_ingot, "get_ventium", FrameType.TASK, true, true, false).m_138398_(getWoodBright).m_138386_("obtain_material", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{SkiesItems.ventium_ingot})).m_138389_(saver, BlueSkies.find("everbright/get_ventium"));
            Advancement useToolBox = this.builder((ItemLike)SkiesBlocks.tool_box, "use_tool_box", FrameType.TASK, true, true, false).m_138398_(ventium).m_138386_("use_tool_box", (CriterionTriggerInstance)UsedToolboxTrigger.Instance.any()).m_138389_(saver, BlueSkies.find("everbright/use_tool_box"));
            Advancement useFalsiteInToolBox = this.builder((ItemLike)SkiesItems.falsite_ingot, "use_falsite_in_tool_box", FrameType.TASK, true, true, false).m_138398_(useToolBox).m_138386_("use_tool_box", (CriterionTriggerInstance)UsedToolboxTrigger.Instance.withModifier(SkiesItemTags.FALSITE)).m_138389_(saver, BlueSkies.find("everbright/use_falsite_in_tool_box"));
            Advancement killSummoner = this.builder((ItemLike)SkiesItems.ethereal_arc, "kill_summoner", FrameType.CHALLENGE, true, true, false).m_138398_(getWoodBright).m_138386_("kill_summoner", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(SkiesEntityTypes.SUMMONER))).m_138389_(saver, BlueSkies.find("everbright/kill_summoner"));
            Advancement summonGolem = this.builder((ItemLike)SkiesItems.summoning_tome, "summon_golem", FrameType.TASK, true, true, false).m_138398_(killSummoner).m_138386_("summon_golem", (CriterionTriggerInstance)SummonedEntityTrigger.TriggerInstance.m_68275_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(SkiesEntityTypes.ARTIFICIAL_GOLEM))).m_138389_(saver, BlueSkies.find("everbright/summon_artificial_golem"));
            Advancement regenBrewberry = this.builder((ItemLike)SkiesItems.pink_brewberry, "regen_brewberry", FrameType.GOAL, true, true, false).m_138398_(regrowth).m_138386_("have_pink_brewberry", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)SkiesItems.pink_brewberry)).m_138389_(saver, BlueSkies.find("everbright/regen_brewberry"));
            Advancement enterNatureDungeon = this.builder((ItemLike)SkiesBlocks.nature_keystone, "enter_nature_dungeon", FrameType.GOAL, true, true, false).m_138398_(killSummoner).m_138386_("entered_dungeon", (CriterionTriggerInstance)this.enterStructure((ResourceKey<Structure>)SkiesStructures.NATURE_DUNGEON.getStructure().getKey())).m_138389_(saver, BlueSkies.find("everbright/enter_nature_dungeon"));
            Advancement killCrusher = this.builder((ItemLike)SkiesItems.nature_arc, "kill_starlit_crusher", FrameType.CHALLENGE, true, true, false).m_138398_(enterNatureDungeon).m_138386_("kill_starlit_crusher", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(SkiesEntityTypes.STARLIT_CRUSHER))).m_138389_(saver, BlueSkies.find("everbright/kill_starlit_crusher"));
            Advancement killCrusherSpecial = this.builder((ItemLike)SkiesItems.nature_arc, "kill_starlit_crusher_special", FrameType.CHALLENGE, true, true, false).m_138398_(killCrusher).m_138386_("punch_crusher", (CriterionTriggerInstance)SpecialCrusherTrigger.Instance.any()).m_138389_(saver, BlueSkies.find("everbright/kill_starlit_crusher_special"));
            this.setSection("everdawn");
            Advancement enterDawn = this.builder((ItemLike)SkiesBlocks.everdawn_portal, "enter", FrameType.TASK, true, true, false).m_138398_(root).m_138386_("enter_everdawn", (CriterionTriggerInstance)this.changeDim(BlueSkiesAdvancements.genEverdawnKey())).m_138389_(saver, BlueSkies.find("everdawn/enter"));
            Advancement getWoodDawn = this.haveAnyItem(this.builder((ItemLike)SkiesBlocks.lunar_log, "get_wood", FrameType.TASK, true, true, false).m_138398_(enterDawn).m_138360_(RequirementsStrategy.f_15979_), List.of(SkiesBlocks.lunar_log, SkiesBlocks.lunar_wood, SkiesBlocks.dusk_log, SkiesBlocks.dusk_wood, SkiesBlocks.maple_log, SkiesBlocks.maple_wood)).m_138389_(saver, BlueSkies.find("everdawn/get_wood"));
            Advancement horizonite = this.builder((ItemLike)SkiesItems.horizonite_ingot, "get_horizonite", FrameType.TASK, true, true, false).m_138398_(getWoodDawn).m_138386_("obtain_material", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{SkiesItems.horizonite_ingot})).m_138389_(saver, BlueSkies.find("everdawn/get_horizonite"));
            Advancement horizoniteForge = this.builder((ItemLike)SkiesBlocks.horizonite_forge, "craft_horizonite_forge", FrameType.TASK, true, true, false).m_138398_(horizonite).m_138386_("obtain_forge", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{SkiesBlocks.horizonite_forge})).m_138389_(saver, BlueSkies.find("everdawn/craft_horizonite_forge"));
            Advancement poisonShroom = this.builder((ItemLike)SkiesBlocks.baneful_mushroom, "poison_shroom", FrameType.TASK, true, true, false).m_138398_(enterDawn).m_138386_("touch_shroom", (CriterionTriggerInstance)EnterBlockTrigger.TriggerInstance.m_31297_((Block)SkiesBlocks.baneful_mushroom)).m_138389_(saver, BlueSkies.find("everdawn/poison_shroom"));
            Advancement killAlchemist = this.builder((ItemLike)SkiesItems.dusk_arc, "kill_alchemist", FrameType.CHALLENGE, true, true, false).m_138398_(getWoodDawn).m_138386_("kill_alchemist", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(SkiesEntityTypes.ALCHEMIST))).m_138389_(saver, BlueSkies.find("everdawn/kill_alchemist"));
            Advancement useAlchemyTable = this.builder((ItemLike)SkiesBlocks.alchemy_table, "use_alchemy_table", FrameType.TASK, true, true, false).m_138398_(killAlchemist).m_138386_("use_alchemy_table", (CriterionTriggerInstance)UsedAlchemyTableTrigger.Instance.any()).m_138389_(saver, BlueSkies.find("everdawn/use_alchemy_table"));
            Advancement enterPoisonDungeon = this.builder((ItemLike)SkiesBlocks.poison_keystone, "enter_poison_dungeon", FrameType.GOAL, true, true, false).m_138398_(killAlchemist).m_138386_("entered_dungeon", (CriterionTriggerInstance)this.enterStructure((ResourceKey<Structure>)SkiesStructures.POISON_DUNGEON.getStructure().getKey())).m_138389_(saver, BlueSkies.find("everdawn/enter_poison_dungeon"));
            Advancement killArachnarch = this.builder((ItemLike)SkiesItems.poison_arc, "kill_arachnarch", FrameType.CHALLENGE, true, true, false).m_138398_(enterPoisonDungeon).m_138386_("kill_arachnarch", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(SkiesEntityTypes.ARACHNARCH))).m_138389_(saver, BlueSkies.find("everdawn/kill_arachnarch"));
            Advancement killArachnarchSpecial = this.builder((ItemLike)SkiesItems.poison_arc, "kill_arachnarch_special", FrameType.CHALLENGE, true, true, false).m_138398_(killArachnarch).m_138386_("drop_arachnarch", (CriterionTriggerInstance)SpecialArachnarchTrigger.Instance.any()).m_138389_(saver, BlueSkies.find("everdawn/kill_starlit_arachnarch_special"));
            Advancement different = this.builder((ItemLike)SkiesItems.different_sword, "think_different", FrameType.GOAL, true, true, false).m_138398_(killArachnarch).m_138386_("have_sword", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{SkiesItems.different_sword})).m_138389_(saver, BlueSkies.find("everdawn/think_different"));
            Advancement killBugs = this.killAllOf(this.builder((ItemLike)SkiesItems.bug_guts, "kill_bug", FrameType.GOAL, true, true, false).m_138398_(poisonShroom), List.of(SkiesEntityTypes.VENOM_SPIDER, SkiesEntityTypes.NYCTOFLY, SkiesEntityTypes.EMBERBACK, SkiesEntityTypes.INFESTED_SWARMER, SkiesEntityTypes.ARACHNARCH, SkiesEntityTypes.NESTED_SPIDER)).m_138389_(saver, BlueSkies.find("everdawn/kill_bug"));
            Advancement alchemyGold = this.builder((ItemLike)Items.f_42417_, "alchemy_gold", FrameType.CHALLENGE, true, true, true).m_138398_(useAlchemyTable).m_138386_("craft_gold", (CriterionTriggerInstance)UsedAlchemyTableTrigger.Instance.withItem((ItemLike)Items.f_42417_)).m_138389_(saver, BlueSkies.find("everdawn/alchemy_gold"));
            this.setSection("progression");
            Advancement impossibleRoot = Advancement.Builder.m_138353_().m_138386_("impossible", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_138389_(saver, BlueSkies.find("progression/root"));
            this.unlockKeyTrade("unlock_everbright_blinding_key_trade", SkiesItems.blinding_key, SkiesBlocks.bright_blinding_keystone, impossibleRoot, saver);
            this.unlockKeyTrade("unlock_everdawn_blinding_key_trade", SkiesItems.blinding_key, SkiesBlocks.dawn_blinding_keystone, impossibleRoot, saver);
            this.unlockKeyTrade("unlock_nature_key_trade", SkiesItems.nature_key, SkiesBlocks.nature_keystone, impossibleRoot, saver);
            this.unlockKeyTrade("unlock_poison_key_trade", SkiesItems.poison_key, SkiesBlocks.poison_keystone, impossibleRoot, saver);
        }

        private void toolRecipes(Consumer<Advancement> consumer) {
            for (ToolRecipe.Materials material : ToolRecipe.Materials.values()) {
                for (String type : SkiesRecipes.TOOL_TYPES) {
                    String name = StringUtil.toLower(material.name()) + "_" + type;
                    Advancement.Builder.m_138353_().m_138386_("has_resource", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{material.getItem()}).m_45077_()})).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)BlueSkies.locate(StringUtil.toLower(name)))).m_138389_(consumer, BlueSkies.find("recipes/blue_skies_tools/" + StringUtil.toLower(name)));
                }
            }
        }

        private Advancement.Builder killAllOf(Advancement.Builder builder, List<EntityType<?>> entities) {
            entities.forEach(e -> builder.m_138386_("kill_" + ForgeRegistries.ENTITY_TYPES.getKey(e).m_135815_(), (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(e))));
            return builder;
        }

        private Advancement.Builder haveAnyItem(Advancement.Builder builder, List<ItemLike> items) {
            items.forEach(item -> builder.m_138386_("has_" + ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()).m_135815_(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{item})));
            return builder;
        }

        private Advancement.Builder enterAnyStructure(Advancement.Builder builder, List<ResourceKey<Structure>> structures) {
            structures.forEach(structure -> builder.m_138386_("entered_" + structure.m_135782_().m_135815_(), (CriterionTriggerInstance)this.enterStructure((ResourceKey<Structure>)structure)));
            return builder;
        }

        private ChangeDimensionTrigger.TriggerInstance changeDim(ResourceKey<Level> type) {
            return ChangeDimensionTrigger.TriggerInstance.m_19782_(type);
        }

        private PlayerTrigger.TriggerInstance enterStructure(ResourceKey<Structure> type) {
            return PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_220589_(type));
        }

        private void unlockKeyTrade(String name, Item key, Block keystone, Advancement parent, Consumer<Advancement> consumer) {
            ItemUsedOnLocationTrigger.TriggerInstance clickKeystone = ItemUsedOnLocationTrigger.TriggerInstance.m_285945_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52652_(BlockPredicate.Builder.m_17924_().m_146726_(new Block[]{keystone}).m_17931_()), (ItemPredicate.Builder)ItemPredicate.Builder.m_45068_());
            Advancement.Builder.m_138353_().m_138398_(parent).m_138371_((ItemLike)key, (Component)Component.m_237119_(), (Component)Component.m_237119_(), null, FrameType.TASK, false, false, true).m_138386_("click_keystone", (CriterionTriggerInstance)clickKeystone).m_138389_(consumer, BlueSkies.find("progression/" + name));
        }

        private Component translate(String key) {
            return Component.m_237115_((String)("advancements.blue_skies" + (String)(this.section.equals("") ? "" : "." + this.section) + "." + key));
        }

        private void setSection(String name) {
            this.section = name;
        }

        private Advancement.Builder builder(ItemLike displayItem, String name, ResourceLocation background, FrameType frameType, boolean showToast, boolean announceToChat, boolean hidden) {
            return Advancement.Builder.m_138353_().m_138371_(displayItem, this.translate(name), this.translate(name + ".desc"), background, frameType, showToast, announceToChat, hidden);
        }

        private Advancement.Builder builder(ItemLike displayItem, String name, FrameType frameType, boolean showToast, boolean announceToChat, boolean hidden) {
            return this.builder(displayItem, name, null, frameType, showToast, announceToChat, hidden);
        }

        public static ResourceKey<Level> genEverbrightKey() {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)SkiesDimensions.EVERBRIGHT_ID);
        }

        public static ResourceKey<Level> genEverdawnKey() {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)SkiesDimensions.EVERDAWN_ID);
        }
    }
}

