/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.network;

import com.minecraftserverzone.weaponmaster.setup.capabilities.PlayerStatsProvider;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketDataForAll {
    private int slotNum;
    private ItemStack stack;
    private UUID uuid;

    public PacketDataForAll(FriendlyByteBuf buf) {
        this.slotNum = buf.readInt();
        this.stack = buf.m_130267_();
        this.uuid = buf.m_130259_();
    }

    public PacketDataForAll(int slot, ItemStack itemstack, UUID uuid) {
        this.slotNum = slot;
        this.stack = itemstack;
        this.uuid = uuid;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.slotNum);
        buf.writeItemStack(this.stack, false);
        buf.m_130077_(this.uuid);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.playerChanged()));
        ctx.get().setPacketHandled(true);
    }

    public void playerChanged() {
        for (Player sp : Minecraft.m_91087_().f_91073_.m_6907_()) {
            if (!sp.m_20148_().equals(this.uuid)) continue;
            sp.getCapability(PlayerStatsProvider.PLAYER_STATS_CAPABILITY).ifPresent(h -> {
                if (this.slotNum == 0) {
                    h.setHotbarSlot1(this.stack);
                } else if (this.slotNum == 1) {
                    h.setHotbarSlot2(this.stack);
                } else if (this.slotNum == 2) {
                    h.setHotbarSlot3(this.stack);
                } else if (this.slotNum == 3) {
                    h.setHotbarSlot4(this.stack);
                } else if (this.slotNum == 4) {
                    h.setHotbarSlot5(this.stack);
                } else if (this.slotNum == 5) {
                    h.setHotbarSlot6(this.stack);
                } else if (this.slotNum == 6) {
                    h.setHotbarSlot7(this.stack);
                } else if (this.slotNum == 7) {
                    h.setHotbarSlot8(this.stack);
                } else if (this.slotNum == 8) {
                    h.setHotbarSlot9(this.stack);
                }
            });
        }
    }
}

