/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.itemlayers;

import com.minecraftserverzone.weaponmaster.setup.ClientOnlyForgeSetup;
import com.minecraftserverzone.weaponmaster.setup.capabilities.PlayerStatsProvider;
import com.minecraftserverzone.weaponmaster.setup.configs.ConfigHolder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.Vanishable;
import net.minecraftforge.fml.ModList;

public class HumanoidItemLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    public HumanoidItemLayer(RenderLayerParent<T, M> p_174516_) {
        super(p_174516_);
    }

    protected void renderPlayerWithItems(LivingEntity p_174525_, ItemStack p_174526_, ItemDisplayContext p_174527_, HumanoidArm p_174528_, PoseStack p_174529_, MultiBufferSource p_174530_, int p_174531_) {
        this.renderWithItems(p_174525_, p_174526_, p_174528_, p_174529_, p_174530_, p_174531_);
    }

    public boolean blackListed(ItemStack item, String txt) {
        if (txt != null) {
            String[] blacklist;
            if (item == null) {
                return false;
            }
            for (String bl : blacklist = txt.split(",")) {
                if (!item.m_41720_().m_204114_().m_205785_().m_135782_().toString().contains(bl)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean whiteListed(ItemStack item, String txt) {
        if (txt != null) {
            String[] whitelist;
            if (item == null) {
                return false;
            }
            for (String wl : whitelist = txt.split(",")) {
                if (!item.m_41720_().m_204114_().m_205785_().m_135782_().toString().contains(wl)) continue;
                return true;
            }
        }
        return false;
    }

    public void render(PoseStack p_117204_, MultiBufferSource p_117205_, int p_117206_, T p_117207_, float p_117208_, float p_117209_, float p_117210_, float p_117211_, float p_117212_, float p_117213_) {
        p_117204_.m_85836_();
        if (ModList.get().isLoaded("yearsc") && ((HumanoidModel)this.m_117386_()).f_102610_) {
            float f = 0.5f;
            p_117204_.m_85837_(0.0, 0.75, 0.0);
            p_117204_.m_85841_(f, f, f);
        }
        this.renderPlayerWithItems((LivingEntity)p_117207_, (ItemStack)((Player)p_117207_).m_150109_().f_35974_.get(0), ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, p_117204_, p_117205_, p_117206_);
        p_117204_.m_85849_();
    }

    private void move(PoseStack matrixStack, String[][] moveTypes, int slot, float translation) {
        if (moveTypes[slot][2].equals("-")) {
            translation = -translation;
        }
        if (moveTypes[slot][1].equals("x")) {
            matrixStack.m_252880_(translation, 0.0f, 0.0f);
        } else if (moveTypes[slot][1].equals("y")) {
            matrixStack.m_252880_(0.0f, translation, 0.0f);
        } else if (moveTypes[slot][1].equals("z")) {
            matrixStack.m_252880_(0.0f, 0.0f, translation);
        }
    }

    private int hasItems(ItemStack[] items, Player player, String[][] moveTypes, int slot, int selected, int shieldSlot, int bannerSlot, int[] toggleSlots) {
        int i = 0;
        for (int j = 0; j < 9; ++j) {
            if (!moveTypes[slot][0].contains(String.valueOf(j + 1)) || items[j] == null || items[j].m_41619_() || selected == j || toggleSlots[j] != 1) continue;
            ++i;
        }
        if (moveTypes[slot][0].contains("shield") && shieldSlot > -1 && selected != shieldSlot && toggleSlots[9] == 1) {
            ++i;
        }
        if (moveTypes[slot][0].contains("banner") && bannerSlot > -1 && selected != bannerSlot && toggleSlots[10] == 1) {
            ++i;
        }
        return i;
    }

    private boolean hasEquipments(Player player, String[][] moveTypes, int slot) {
        boolean move = false;
        if (moveTypes[slot][0].contains("helm") && !player.m_150109_().m_36052_(3).m_41619_()) {
            move = true;
        }
        if (moveTypes[slot][0].contains("chest") && !player.m_150109_().m_36052_(2).m_41619_()) {
            move = true;
        }
        if (moveTypes[slot][0].contains("legs") && !player.m_150109_().m_36052_(1).m_41619_()) {
            move = true;
        }
        if (moveTypes[slot][0].contains("boots") && !player.m_150109_().m_36052_(0).m_41619_()) {
            move = true;
        }
        return move;
    }

    private void renderWithItems(LivingEntity p_174518_, ItemStack p_174519_, HumanoidArm p_174520_, PoseStack p_174521_, MultiBufferSource p_174522_, int p_174523_) {
        Player p = (Player)p_174518_;
        p.getCapability(PlayerStatsProvider.PLAYER_STATS_CAPABILITY).ifPresent(h -> {
            float moveBy;
            int selected = h.getSelectedSlot();
            ItemStack stack1 = this.blackListed(h.getHotbarSlot1(), h.getBlacklist()) ? ItemStack.f_41583_ : h.getHotbarSlot1();
            ItemStack stack2 = this.blackListed(h.getHotbarSlot2(), h.getBlacklist()) ? ItemStack.f_41583_ : h.getHotbarSlot2();
            ItemStack stack3 = this.blackListed(h.getHotbarSlot3(), h.getBlacklist()) ? ItemStack.f_41583_ : h.getHotbarSlot3();
            ItemStack stack4 = this.blackListed(h.getHotbarSlot4(), h.getBlacklist()) ? ItemStack.f_41583_ : h.getHotbarSlot4();
            ItemStack stack5 = this.blackListed(h.getHotbarSlot5(), h.getBlacklist()) ? ItemStack.f_41583_ : h.getHotbarSlot5();
            ItemStack stack6 = this.blackListed(h.getHotbarSlot6(), h.getBlacklist()) ? ItemStack.f_41583_ : h.getHotbarSlot6();
            ItemStack stack7 = this.blackListed(h.getHotbarSlot7(), h.getBlacklist()) ? ItemStack.f_41583_ : h.getHotbarSlot7();
            ItemStack stack8 = this.blackListed(h.getHotbarSlot8(), h.getBlacklist()) ? ItemStack.f_41583_ : h.getHotbarSlot8();
            ItemStack stack9 = this.blackListed(h.getHotbarSlot9(), h.getBlacklist()) ? ItemStack.f_41583_ : h.getHotbarSlot9();
            ItemStack[] items = new ItemStack[]{stack1, stack2, stack3, stack4, stack5, stack6, stack7, stack8, stack9};
            int[] toggleSlots = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
            int[] slotPositions = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            int[] slotRotations = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            String[] bodyattachments = ClientOnlyForgeSetup.slotAttachment.split(",");
            String[][] bodyattachment = new String[11][2];
            for (int i = 0; i < 11; ++i) {
                bodyattachment[i][0] = bodyattachments[i].split("-")[0];
                bodyattachment[i][1] = bodyattachments[i].split("-")[1];
            }
            String[] moveSlots = ClientOnlyForgeSetup.slotMover.split("_");
            String[][] moveTypes = new String[][]{moveSlots[0].split(";"), moveSlots[1].split(";"), moveSlots[2].split(";"), moveSlots[3].split(";"), moveSlots[4].split(";"), moveSlots[5].split(";"), moveSlots[6].split(";"), moveSlots[7].split(";"), moveSlots[8].split(";"), moveSlots[9].split(";"), moveSlots[10].split(";")};
            if (p instanceof LocalPlayer) {
                int[] toggleSlots2 = new int[]{(Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[0].get() != false ? 1 : 0, (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[1].get() != false ? 1 : 0, (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[2].get() != false ? 1 : 0, (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[3].get() != false ? 1 : 0, (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[4].get() != false ? 1 : 0, (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[5].get() != false ? 1 : 0, (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[6].get() != false ? 1 : 0, (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[7].get() != false ? 1 : 0, (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[8].get() != false ? 1 : 0, (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[9].get() != false ? 1 : 0, (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[10].get() != false ? 1 : 0};
                toggleSlots = toggleSlots2;
                slotPositions = ClientOnlyForgeSetup.slotPositions;
                slotRotations = ClientOnlyForgeSetup.slotRotations;
            } else {
                int i;
                if (h.getToggleSlot() != null) {
                    toggleSlots = h.getToggleSlot();
                }
                for (i = 0; i < 3; ++i) {
                    if (h.getHotbarSlot1Position() != null) {
                        slotPositions[i] = h.getHotbarSlot1Position()[i];
                    }
                    if (h.getHotbarSlot2Position() != null) {
                        slotPositions[i + 3] = h.getHotbarSlot2Position()[i];
                    }
                    if (h.getHotbarSlot3Position() != null) {
                        slotPositions[i + 6] = h.getHotbarSlot3Position()[i];
                    }
                    if (h.getHotbarSlot4Position() != null) {
                        slotPositions[i + 9] = h.getHotbarSlot4Position()[i];
                    }
                    if (h.getHotbarSlot5Position() != null) {
                        slotPositions[i + 12] = h.getHotbarSlot5Position()[i];
                    }
                    if (h.getHotbarSlot6Position() != null) {
                        slotPositions[i + 15] = h.getHotbarSlot6Position()[i];
                    }
                    if (h.getHotbarSlot7Position() != null) {
                        slotPositions[i + 18] = h.getHotbarSlot7Position()[i];
                    }
                    if (h.getHotbarSlot8Position() != null) {
                        slotPositions[i + 21] = h.getHotbarSlot8Position()[i];
                    }
                    if (h.getHotbarSlot9Position() != null) {
                        slotPositions[i + 24] = h.getHotbarSlot9Position()[i];
                    }
                    if (h.getHotbarSlotShieldPosition() != null) {
                        slotPositions[i + 27] = h.getHotbarSlotShieldPosition()[i];
                    }
                    if (h.getHotbarSlotBannerPosition() != null) {
                        slotPositions[i + 30] = h.getHotbarSlotBannerPosition()[i];
                    }
                    if (h.getHotbarSlot1Rotation() != null) {
                        slotRotations[i] = h.getHotbarSlot1Rotation()[i];
                    }
                    if (h.getHotbarSlot2Rotation() != null) {
                        slotRotations[i + 3] = h.getHotbarSlot2Rotation()[i];
                    }
                    if (h.getHotbarSlot3Rotation() != null) {
                        slotRotations[i + 6] = h.getHotbarSlot3Rotation()[i];
                    }
                    if (h.getHotbarSlot4Rotation() != null) {
                        slotRotations[i + 9] = h.getHotbarSlot4Rotation()[i];
                    }
                    if (h.getHotbarSlot5Rotation() != null) {
                        slotRotations[i + 12] = h.getHotbarSlot5Rotation()[i];
                    }
                    if (h.getHotbarSlot6Rotation() != null) {
                        slotRotations[i + 15] = h.getHotbarSlot6Rotation()[i];
                    }
                    if (h.getHotbarSlot7Rotation() != null) {
                        slotRotations[i + 18] = h.getHotbarSlot7Rotation()[i];
                    }
                    if (h.getHotbarSlot8Rotation() != null) {
                        slotRotations[i + 21] = h.getHotbarSlot8Rotation()[i];
                    }
                    if (h.getHotbarSlot9Rotation() != null) {
                        slotRotations[i + 24] = h.getHotbarSlot9Rotation()[i];
                    }
                    if (h.getHotbarSlotShieldRotation() != null) {
                        slotRotations[i + 27] = h.getHotbarSlotShieldRotation()[i];
                    }
                    if (h.getHotbarSlotBannerRotation() == null) continue;
                    slotRotations[i + 30] = h.getHotbarSlotBannerRotation()[i];
                }
                if (h.getSlotAttachments() != null) {
                    bodyattachments = h.getSlotAttachments().split(",");
                    for (i = 0; i < 11; ++i) {
                        bodyattachment[i][0] = bodyattachments[i].split("-")[0];
                        bodyattachment[i][1] = bodyattachments[i].split("-")[1];
                    }
                }
            }
            int shieldAt = -1;
            for (int i = 0; i < 9; ++i) {
                if (items[i] == null || !(items[i].m_41720_() instanceof ShieldItem)) continue;
                shieldAt = i;
                break;
            }
            int bannerAt = -1;
            for (int i = 0; i < 9; ++i) {
                if (items[i] == null || !(items[i].m_41720_() instanceof BannerItem)) continue;
                bannerAt = i;
                break;
            }
            if (bannerAt != -1 && selected != bannerAt && toggleSlots[10] == 1) {
                p_174521_.m_85836_();
                this.copyModelPartRotation(p_174521_, 10, bodyattachment, 0.01f, 1.0f);
                float moveBy2 = (float)this.hasItems(items, p, moveTypes, 10, selected, shieldAt, bannerAt, toggleSlots) * 0.042f;
                this.move(p_174521_, moveTypes, 10, moveBy2);
                moveBy = this.hasEquipments(p, moveTypes, 10) ? 0.038f : 0.0f;
                this.move(p_174521_, moveTypes, 10, moveBy);
                p_174521_.m_252880_((float)slotPositions[30] / 100.0f, (float)slotPositions[31] / 100.0f, (float)slotPositions[32] / 100.0f);
                p_174521_.m_252781_(Axis.f_252529_.m_252977_((float)slotRotations[30]));
                p_174521_.m_252781_(Axis.f_252436_.m_252977_((float)slotRotations[31]));
                p_174521_.m_252781_(Axis.f_252403_.m_252977_((float)slotRotations[32]));
                p_174521_.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                p_174521_.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                p_174521_.m_85837_(0.0, 0.6, -0.3);
                p_174521_.m_85841_(0.75f, 0.75f, 0.75f);
                Minecraft.m_91087_().m_91290_().m_234586_().m_269530_(p_174518_, items[bannerAt], ItemDisplayContext.NONE, false, p_174521_, p_174522_, p_174523_);
                p_174521_.m_85849_();
            }
            p_174521_.m_85836_();
            if (shieldAt != -1 && selected != shieldAt && toggleSlots[9] == 1) {
                p_174521_.m_85836_();
                this.copyModelPartRotation(p_174521_, 9, bodyattachment, 1.0f, 1.0f);
                float moveBy2 = (float)this.hasItems(items, p, moveTypes, 9, selected, shieldAt, bannerAt, toggleSlots) * 0.042f;
                this.move(p_174521_, moveTypes, 9, moveBy2);
                moveBy = this.hasEquipments(p, moveTypes, 9) ? 0.038f : 0.0f;
                this.move(p_174521_, moveTypes, 9, moveBy);
                p_174521_.m_252880_((float)slotPositions[27] / 100.0f, (float)slotPositions[28] / 100.0f, (float)slotPositions[29] / 100.0f);
                p_174521_.m_85837_(0.0, 0.0, 0.015);
                p_174521_.m_252781_(Axis.f_252529_.m_252977_((float)slotRotations[27]));
                p_174521_.m_252781_(Axis.f_252436_.m_252977_((float)slotRotations[28]));
                p_174521_.m_252781_(Axis.f_252403_.m_252977_((float)slotRotations[29]));
                p_174521_.m_85837_((double)0.3f, 0.7, 0.5);
                p_174521_.m_85841_(0.6f, 0.6f, 0.6f);
                p_174521_.m_85837_(-0.25, -0.375, -0.625);
                p_174521_.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                Minecraft.m_91087_().m_91290_().m_234586_().m_269530_(p_174518_, items[shieldAt], ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, false, p_174521_, p_174522_, p_174523_);
                p_174521_.m_85849_();
            }
            for (int slot = 0; slot < 9; ++slot) {
                if (items[slot] == null || items[slot].m_41619_() || selected == slot || shieldAt == slot || bannerAt == slot || toggleSlots[slot] != 1) continue;
                p_174521_.m_85836_();
                this.copyModelPartRotation(p_174521_, slot, bodyattachment, 1.0f, 1.0f);
                p_174521_.m_252880_((float)slotPositions[slot * 3] / 100.0f, (float)slotPositions[slot * 3 + 1] / 100.0f, (float)slotPositions[slot * 3 + 2] / 100.0f);
                moveBy = (float)this.hasItems(items, p, moveTypes, slot, selected, shieldAt, bannerAt, toggleSlots) * 0.042f;
                this.move(p_174521_, moveTypes, slot, moveBy);
                float moveByArmor = this.hasEquipments(p, moveTypes, slot) ? 0.038f : 0.0f;
                this.move(p_174521_, moveTypes, slot, moveByArmor);
                p_174521_.m_252781_(Axis.f_252529_.m_252977_((float)slotRotations[slot * 3]));
                p_174521_.m_252781_(Axis.f_252436_.m_252977_((float)slotRotations[slot * 3 + 1]));
                p_174521_.m_252781_(Axis.f_252403_.m_252977_((float)slotRotations[slot * 3 + 2]));
                if (items[slot].m_41720_() instanceof BowItem) {
                    this.renderBowItem(slot, p_174518_, items[slot], p_174520_, p_174521_, p_174522_, p_174523_);
                } else if (items[slot].m_41720_() instanceof CrossbowItem) {
                    this.renderCrossbowItem(slot, p_174518_, items[slot], p_174520_, p_174521_, p_174522_, p_174523_);
                } else if (items[slot].m_41720_().getClass().equals(TridentItem.class)) {
                    this.renderTridentItem(slot, p_174518_, items[slot], p_174520_, p_174521_, p_174522_, p_174523_);
                } else if ((items[slot].m_41720_() instanceof TieredItem || items[slot].m_41720_() instanceof Vanishable) && !(items[slot].m_41720_() instanceof Equipable)) {
                    this.renderTieredItem(slot, p_174518_, items[slot], p_174520_, p_174521_, p_174522_, p_174523_);
                } else if (this.whiteListed(items[slot], h.getWhitelist())) {
                    p_174521_.m_85837_(0.0, 0.7, 0.0);
                    p_174521_.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                    this.renderNormalItem(slot, p_174518_, items[slot], p_174520_, p_174521_, p_174522_, p_174523_);
                }
                p_174521_.m_85849_();
            }
            p_174521_.m_85849_();
        });
    }

    public void translateToHand(ModelPart part, HumanoidArm p_102854_, PoseStack p_102855_) {
        part.m_104299_(p_102855_);
    }

    public void translateAndRotate(PoseStack p_104300_, float x, float y, float z, float xRot, float yRot, float zRot, float xScale, float yScale, float zScale) {
        p_104300_.m_85837_((double)(x / 16.0f), (double)(y / 16.0f), (double)(z / 16.0f));
        if (zRot != 0.0f) {
            p_104300_.m_252781_(Axis.f_252403_.m_252961_(zRot));
        }
        if (yRot != 0.0f) {
            p_104300_.m_252781_(Axis.f_252436_.m_252961_(yRot));
        }
        if (xRot != 0.0f) {
            p_104300_.m_252781_(Axis.f_252529_.m_252961_(xRot));
        }
        if (xScale != 1.0f || yScale != 1.0f || zScale != 1.0f) {
            p_104300_.m_85841_(xScale, yScale, zScale);
        }
    }

    public void copyModelPartRotation(PoseStack ps, int slot, String[][] bodyattachment, float multiplier, float maxRotateChanger) {
        ModelPart part = ((HumanoidModel)this.m_117386_()).f_102810_;
        if (bodyattachment[slot][1].equals("head")) {
            part = ((HumanoidModel)this.m_117386_()).m_5585_();
        } else if (bodyattachment[slot][1].equals("body")) {
            part = ((HumanoidModel)this.m_117386_()).f_102810_;
        } else if (bodyattachment[slot][1].equals("rarm")) {
            part = ((HumanoidModel)this.m_117386_()).f_102811_;
        } else if (bodyattachment[slot][1].equals("larm")) {
            part = ((HumanoidModel)this.m_117386_()).f_102812_;
        } else if (bodyattachment[slot][1].equals("rleg")) {
            part = ((HumanoidModel)this.m_117386_()).f_102813_;
        } else if (bodyattachment[slot][1].equals("lleg")) {
            part = ((HumanoidModel)this.m_117386_()).f_102814_;
        }
        part.m_104299_(ps);
    }

    private void renderTridentItem(int slot, LivingEntity p_174518_, ItemStack itemStack, HumanoidArm p_174520_, PoseStack p_174521_, MultiBufferSource p_174522_, int p_174523_) {
        p_174521_.m_85836_();
        p_174521_.m_252781_(Axis.f_252403_.m_252977_(140.0f));
        p_174521_.m_85837_((double)0.7f, 0.9, 0.61);
        p_174521_.m_85841_(0.9f, 0.9f, 0.9f);
        p_174521_.m_252880_(-0.45f, -1.07f, -0.535f);
        p_174521_.m_252781_(Axis.f_252436_.m_252977_(-60.0f));
        Minecraft.m_91087_().m_91290_().m_234586_().m_269530_(p_174518_, itemStack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, false, p_174521_, p_174522_, p_174523_);
        p_174521_.m_85849_();
    }

    private void renderCrossbowItem(int slot, LivingEntity p_174518_, ItemStack itemStack, HumanoidArm p_174520_, PoseStack p_174521_, MultiBufferSource p_174522_, int p_174523_) {
        p_174521_.m_85836_();
        p_174521_.m_85837_(-0.05, 0.35, 0.16);
        p_174521_.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        p_174521_.m_252781_(Axis.f_252403_.m_252977_(270.0f));
        p_174521_.m_85841_(0.8f, -0.8f, -0.8f);
        p_174521_.m_252880_(0.1f, -0.2f, 0.0f);
        p_174521_.m_252781_(Axis.f_252436_.m_252977_(0.0f));
        p_174521_.m_252781_(Axis.f_252403_.m_252977_(60.0f));
        p_174521_.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        Minecraft.m_91087_().m_91290_().m_234586_().m_269530_(p_174518_, itemStack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, false, p_174521_, p_174522_, p_174523_);
        p_174521_.m_85849_();
    }

    private void renderBowItem(int slot, LivingEntity p_174518_, ItemStack itemStack, HumanoidArm p_174520_, PoseStack p_174521_, MultiBufferSource p_174522_, int p_174523_) {
        p_174521_.m_85836_();
        p_174521_.m_85837_(0.0, 0.35, 0.16);
        p_174521_.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        p_174521_.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        p_174521_.m_85841_(0.8f, -0.8f, -0.8f);
        p_174521_.m_85837_(-0.05, 0.2, -0.07);
        p_174521_.m_252781_(Axis.f_252436_.m_252977_(97.0f));
        p_174521_.m_252781_(Axis.f_252403_.m_252977_(-6.0f));
        p_174521_.m_252781_(Axis.f_252529_.m_252977_(40.0f));
        Minecraft.m_91087_().m_91290_().m_234586_().m_269530_(p_174518_, itemStack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, false, p_174521_, p_174522_, p_174523_);
        p_174521_.m_85849_();
    }

    private void renderNormalItem(int slot, LivingEntity p_174518_, ItemStack itemStack, HumanoidArm p_174520_, PoseStack p_174521_, MultiBufferSource p_174522_, int p_174523_) {
        p_174521_.m_85836_();
        p_174521_.m_85837_(0.0, 0.35, 0.16);
        p_174521_.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        p_174521_.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        p_174521_.m_85841_(0.8f, -0.8f, -0.8f);
        p_174521_.m_252880_(0.1f, -0.1f, -0.08f);
        Minecraft.m_91087_().m_91290_().m_234586_().m_269530_(p_174518_, itemStack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, false, p_174521_, p_174522_, p_174523_);
        p_174521_.m_85849_();
    }

    private void renderTieredItem(int slot, LivingEntity p_174518_, ItemStack itemStack, HumanoidArm p_174520_, PoseStack p_174521_, MultiBufferSource p_174522_, int p_174523_) {
        p_174521_.m_85836_();
        p_174521_.m_85837_(-0.05, 0.3, 0.16);
        p_174521_.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        p_174521_.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        p_174521_.m_85841_(0.8f, -0.8f, -0.8f);
        p_174521_.m_85837_(-0.2, -0.1, -0.0);
        p_174521_.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        p_174521_.m_252781_(Axis.f_252529_.m_252977_(55.0f));
        Minecraft.m_91087_().m_91290_().m_234586_().m_269530_(p_174518_, itemStack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, false, p_174521_, p_174522_, p_174523_);
        p_174521_.m_85849_();
    }
}

