/*
 * Decompiled with CFR 0.152.
 */
package portb.chatcolours.mixin.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.StringDecomposer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import portb.chatcolours.ClientConfig;

@Mixin(value={StringDecomposer.class})
public class TextProcessingMixin {
    private static final Pattern FORMAT_SYNTAX_PATTERN = Pattern.compile("^\\[([^]]+)]");
    private static final Map<String, ChatFormatting> FORMAT_CODES = new HashMap<String, ChatFormatting>();

    private static void generateNamesForColour(String colourName, ChatFormatting dark, ChatFormatting light) {
        FORMAT_CODES.put("deep " + colourName, dark);
        FORMAT_CODES.put("deep" + colourName, dark);
        FORMAT_CODES.put("deep_" + colourName, dark);
        FORMAT_CODES.put("dark " + colourName, dark);
        FORMAT_CODES.put("dark" + colourName, dark);
        FORMAT_CODES.put("dark_" + colourName, dark);
        FORMAT_CODES.put("d_" + colourName, dark);
        FORMAT_CODES.put("d " + colourName, dark);
        FORMAT_CODES.put("d" + colourName, dark);
        FORMAT_CODES.put(colourName + " dark", dark);
        FORMAT_CODES.put(colourName + "_dark", dark);
        FORMAT_CODES.put(colourName + "dark", dark);
        FORMAT_CODES.put(colourName + " deep", dark);
        FORMAT_CODES.put(colourName + "_deep", dark);
        FORMAT_CODES.put(colourName + "deep", dark);
        FORMAT_CODES.put(colourName + "_d", dark);
        FORMAT_CODES.put(colourName + " d", dark);
        FORMAT_CODES.put(colourName + "d", dark);
        FORMAT_CODES.put(colourName, light);
        FORMAT_CODES.put("light_" + colourName, light);
        FORMAT_CODES.put("light " + colourName, light);
        FORMAT_CODES.put("light" + colourName, light);
        FORMAT_CODES.put("bright_" + colourName, light);
        FORMAT_CODES.put("bright " + colourName, light);
        FORMAT_CODES.put("bright" + colourName, light);
        FORMAT_CODES.put(colourName + "_light", light);
        FORMAT_CODES.put(colourName + " light", light);
        FORMAT_CODES.put(colourName + "light", light);
        FORMAT_CODES.put(colourName + "_bright", light);
        FORMAT_CODES.put(colourName + " bright", light);
        FORMAT_CODES.put(colourName + "bright", light);
    }

    @Overwrite
    public static boolean m_14311_(String string, int startIndex, Style initialStyle, Style resetStyle, FormattedCharSink consumer) {
        int strLen = string.length();
        int starCount = 0;
        for (int charIndex = startIndex; charIndex < strLen; ++charIndex) {
            char nextChar;
            char currentChar = string.charAt(charIndex);
            char c = nextChar = charIndex == strLen - 1 ? (char)'\u0000' : string.charAt(charIndex + 1);
            if (((Boolean)ClientConfig.enableMarkdown.get()).booleanValue()) {
                if (currentChar == '*') {
                    ++starCount;
                    if (nextChar == '*') continue;
                    if (starCount == 1) {
                        initialStyle = initialStyle.m_131155_(Boolean.valueOf(!initialStyle.m_131161_()));
                    } else if (starCount == 2) {
                        initialStyle = initialStyle.m_131136_(Boolean.valueOf(!initialStyle.m_131154_()));
                    } else if (starCount == 3) {
                        initialStyle = initialStyle.m_131136_(Boolean.valueOf(!initialStyle.m_131154_())).m_131155_(Boolean.valueOf(!initialStyle.m_131161_()));
                    }
                    starCount = 0;
                    continue;
                }
                if (nextChar == '~' && currentChar == '~') {
                    initialStyle = initialStyle.m_178522_(Boolean.valueOf(!initialStyle.m_131168_()));
                    ++charIndex;
                    continue;
                }
                if (nextChar == '_' && currentChar == '_') {
                    initialStyle = initialStyle.m_131162_(Boolean.valueOf(!initialStyle.m_131171_()));
                    ++charIndex;
                    continue;
                }
            }
            if (currentChar == '\\' && nextChar == '[') {
                if (!TextProcessingMixin.feedChar(initialStyle, consumer, charIndex, nextChar)) {
                    return false;
                }
                ++charIndex;
                continue;
            }
            if (currentChar == '[') {
                if (charIndex + 8 < strLen && string.substring(charIndex, charIndex + 9).matches("\\[#[a-fA-F0-9]{6}]")) {
                    TextColor color = TextColor.m_131268_((String)string.substring(charIndex + 1, charIndex + 8));
                    if (color == null) continue;
                    if (((Boolean)ClientConfig.enableHexcodes.get()).booleanValue()) {
                        initialStyle = initialStyle.m_131148_(color);
                    }
                    charIndex += 8;
                    continue;
                }
                if (TextProcessingMixin.feedChar(initialStyle, consumer, charIndex, '[')) continue;
                return false;
            }
            if (((Boolean)ClientConfig.enableExtendedSyntax.get()).booleanValue() && currentChar == '\u00a7' && nextChar == '[') {
                List<MatchResult> results = TextProcessingMixin.consumeAll(string.substring(charIndex + 1), FORMAT_SYNTAX_PATTERN);
                if (results.isEmpty()) {
                    if (TextProcessingMixin.feedChars(initialStyle, consumer, charIndex, charIndex + 1, string)) continue;
                    return false;
                }
                for (MatchResult result : results) {
                    String code = result.group(1);
                    if (FORMAT_CODES.containsKey(code)) {
                        initialStyle = initialStyle.m_131157_(FORMAT_CODES.get(code));
                    } else if (!TextProcessingMixin.feedChars(initialStyle, consumer, result.group(0), charIndex)) {
                        return false;
                    }
                    charIndex += result.end();
                }
                continue;
            }
            if (currentChar == '\u00a7') {
                if (charIndex + 1 >= strLen) break;
                ChatFormatting textformatting = ChatFormatting.m_126645_((char)nextChar);
                if (textformatting != null) {
                    initialStyle = textformatting == ChatFormatting.RESET ? resetStyle : initialStyle.m_131164_(textformatting);
                }
                ++charIndex;
                continue;
            }
            if (Character.isHighSurrogate(currentChar)) {
                if (charIndex + 1 >= strLen) {
                    if (consumer.m_6411_(charIndex, initialStyle, 65533)) break;
                    return false;
                }
                if (Character.isLowSurrogate(nextChar)) {
                    if (!consumer.m_6411_(charIndex, initialStyle, Character.toCodePoint(currentChar, nextChar))) {
                        return false;
                    }
                    ++charIndex;
                    continue;
                }
                if (consumer.m_6411_(charIndex, initialStyle, 65533)) continue;
                return false;
            }
            if (TextProcessingMixin.feedChar(initialStyle, consumer, charIndex, currentChar)) continue;
            return false;
        }
        return true;
    }

    private static boolean feedChars(Style style, FormattedCharSink consumer, String string, int offset) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isSurrogate(c) ? consumer.m_6411_(offset + i, style, (int)c) : consumer.m_6411_(offset + i, style, 65533)) continue;
            return false;
        }
        return true;
    }

    private static boolean feedChars(Style style, FormattedCharSink consumer, int start, int end, String string) {
        for (int i = start; i < end; ++i) {
            char c = string.charAt(i);
            if (!Character.isSurrogate(c) ? consumer.m_6411_(i, style, (int)c) : consumer.m_6411_(i, style, 65533)) continue;
            return false;
        }
        return true;
    }

    private static boolean feedChar(Style style, FormattedCharSink consumer, int index, char character) {
        return Character.isSurrogate(character) ? consumer.m_6411_(index, style, 65533) : consumer.m_6411_(index, style, (int)character);
    }

    private static List<MatchResult> consumeAll(String text, Pattern pattern) {
        StringBuilder buf = new StringBuilder(text);
        ArrayList<MatchResult> results = new ArrayList<MatchResult>();
        Matcher matcher = pattern.matcher(buf);
        while (matcher.find()) {
            results.add(matcher.toMatchResult());
            buf.delete(0, matcher.end());
            matcher = pattern.matcher(buf);
        }
        return results;
    }

    static {
        FORMAT_CODES.put("black", ChatFormatting.BLACK);
        FORMAT_CODES.put("white", ChatFormatting.WHITE);
        FORMAT_CODES.put("blood", ChatFormatting.DARK_RED);
        FORMAT_CODES.put("orange", ChatFormatting.GOLD);
        FORMAT_CODES.put("gold", ChatFormatting.GOLD);
        TextProcessingMixin.generateNamesForColour("blue", ChatFormatting.DARK_BLUE, ChatFormatting.BLUE);
        TextProcessingMixin.generateNamesForColour("green", ChatFormatting.DARK_GREEN, ChatFormatting.GREEN);
        TextProcessingMixin.generateNamesForColour("aqua", ChatFormatting.DARK_AQUA, ChatFormatting.AQUA);
        TextProcessingMixin.generateNamesForColour("cyan", ChatFormatting.DARK_AQUA, ChatFormatting.AQUA);
        TextProcessingMixin.generateNamesForColour("red", ChatFormatting.DARK_RED, ChatFormatting.RED);
        TextProcessingMixin.generateNamesForColour("purple", ChatFormatting.DARK_PURPLE, ChatFormatting.LIGHT_PURPLE);
        TextProcessingMixin.generateNamesForColour("gray", ChatFormatting.DARK_GRAY, ChatFormatting.GRAY);
        TextProcessingMixin.generateNamesForColour("yellow", ChatFormatting.GOLD, ChatFormatting.YELLOW);
        FORMAT_CODES.put("bold", ChatFormatting.BOLD);
        FORMAT_CODES.put("strong", ChatFormatting.BOLD);
        FORMAT_CODES.put("heavy", ChatFormatting.BOLD);
        FORMAT_CODES.put("b", ChatFormatting.BOLD);
        FORMAT_CODES.put("strikeout", ChatFormatting.STRIKETHROUGH);
        FORMAT_CODES.put("strikethrough", ChatFormatting.STRIKETHROUGH);
        FORMAT_CODES.put("strike", ChatFormatting.STRIKETHROUGH);
        FORMAT_CODES.put("s", ChatFormatting.STRIKETHROUGH);
        FORMAT_CODES.put("u", ChatFormatting.UNDERLINE);
        FORMAT_CODES.put("underline", ChatFormatting.UNDERLINE);
        FORMAT_CODES.put("i", ChatFormatting.ITALIC);
        FORMAT_CODES.put("italic", ChatFormatting.ITALIC);
        FORMAT_CODES.put("slanted", ChatFormatting.ITALIC);
        FORMAT_CODES.put("slant", ChatFormatting.ITALIC);
        FORMAT_CODES.put("obfuscated", ChatFormatting.OBFUSCATED);
        FORMAT_CODES.put("o", ChatFormatting.OBFUSCATED);
        FORMAT_CODES.put("reset", ChatFormatting.RESET);
        FORMAT_CODES.put("clear", ChatFormatting.RESET);
        FORMAT_CODES.put("default", ChatFormatting.RESET);
        FORMAT_CODES.put("r", ChatFormatting.RESET);
    }
}

