/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.manager;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.recipe.SmithingRecipeManager")
@Document(value="vanilla/api/recipe/manager/SmithingRecipeManager")
public enum SmithingRecipeManager implements IRecipeManager<SmithingRecipe>
{
    INSTANCE;


    @ZenCodeType.Method
    public void addTrimRecipe(String recipeName, IIngredient template, IIngredient base, IIngredient addition) {
        recipeName = this.fixRecipeName(recipeName);
        SmithingTrimRecipe smithing = new SmithingTrimRecipe(CraftTweakerConstants.rl(recipeName), template.asVanillaIngredient(), base.asVanillaIngredient(), addition.asVanillaIngredient());
        CraftTweakerAPI.apply(new ActionAddRecipe<SmithingTrimRecipe>(this, smithing, ""));
    }

    @ZenCodeType.Method
    public void addTransformRecipe(String recipeName, IItemStack result, IIngredient template, IIngredient base, IIngredient addition) {
        recipeName = this.fixRecipeName(recipeName);
        SmithingTransformRecipe smithing = new SmithingTransformRecipe(CraftTweakerConstants.rl(recipeName), template.asVanillaIngredient(), base.asVanillaIngredient(), addition.asVanillaIngredient(), result.getInternal());
        CraftTweakerAPI.apply(new ActionAddRecipe<SmithingTransformRecipe>(this, smithing, ""));
    }

    @Override
    public RecipeType<SmithingRecipe> getRecipeType() {
        return RecipeType.f_44113_;
    }
}

