/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.component;

import com.blamejared.crafttweaker.api.recipe.component.DecomposedRecipeBuilder;
import com.blamejared.crafttweaker.api.recipe.component.IRecipeComponent;
import java.util.List;
import java.util.Set;

public interface IDecomposedRecipe {
    public static DecomposedRecipeBuilder builder() {
        return DecomposedRecipeBuilder.of();
    }

    public <C> List<C> get(IRecipeComponent<C> var1);

    default public <C> List<C> getOrThrow(IRecipeComponent<C> component) {
        List<C> list = this.get(component);
        if (list == null) {
            throw new IllegalArgumentException("Missing " + component.getCommandString());
        }
        return list;
    }

    default public <C> C getOrThrowSingle(IRecipeComponent<C> component) {
        List<C> list = this.getOrThrow(component);
        if (list.size() != 1) {
            String message = String.format("Expected a list with a single element for %s, but got %d-sized list: %s", component.getCommandString(), list.size(), list);
            throw new IllegalArgumentException(message);
        }
        return list.get(0);
    }

    public <C> void set(IRecipeComponent<C> var1, List<C> var2);

    default public <C> void set(IRecipeComponent<C> component, C object) {
        this.set(component, (C)List.of(object));
    }

    public Set<IRecipeComponent<?>> components();
}

