/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.network.PacketGetListFromServer;
import mcjty.lib.network.PacketSendServerCommand;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolscontrol.CommandHandler;
import mcjty.rftoolscontrol.modules.processor.ProcessorModule;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.network.PacketGetLog;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOp;
import mcjty.rftoolscontrol.setup.RFToolsCtrlMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public class ProcessorRenderer
implements BlockEntityRenderer<ProcessorTileEntity> {
    public ProcessorRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ProcessorTileEntity te, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (te.getShowHud() == 0) {
            return;
        }
        BlockState state = te.m_58904_().m_8055_(te.m_58899_());
        Block block = state.m_60734_();
        if (!(block instanceof BaseBlock)) {
            return;
        }
        BaseBlock baseBlock = (BaseBlock)block;
        matrixStack.m_85836_();
        Direction facing = BaseBlock.getFrontDirection((RotationType)baseBlock.getRotationType(), (BlockState)state);
        matrixStack.m_252880_(0.5f, 1.5f, 0.5f);
        if (facing == Direction.UP) {
            RenderHelper.rotateXP((PoseStack)matrixStack, (float)-90.0f);
        } else if (facing == Direction.DOWN) {
            RenderHelper.rotateXP((PoseStack)matrixStack, (float)90.0f);
        } else {
            float rotY = switch (facing) {
                case Direction.NORTH -> 180.0f;
                case Direction.WEST -> 90.0f;
                case Direction.EAST -> -90.0f;
                default -> 0.0f;
            };
            RenderHelper.rotateYP((PoseStack)matrixStack, (float)(-rotY));
        }
        if (te.m_58904_().m_46859_(te.m_58899_().m_7494_())) {
            matrixStack.m_252880_(0.0f, 0.0f, -0.037499994f);
        } else {
            matrixStack.m_252880_(0.0f, 0.0f, 0.46249998f);
        }
        GuiGraphics graphics = new GuiGraphics(Minecraft.m_91087_(), Minecraft.m_91087_().m_91269_().m_110104_());
        graphics.m_280168_().m_85850_().m_252922_().set((Matrix4fc)matrixStack.m_85850_().m_252922_());
        graphics.m_280168_().m_85850_().m_252943_().set((Matrix3fc)matrixStack.m_85850_().m_252943_());
        this.renderHud(graphics, buffer, Minecraft.m_91087_().f_91062_, te);
        matrixStack.m_85849_();
    }

    private void renderHud(GuiGraphics graphics, MultiBufferSource buffer, Font fontrenderer, ProcessorTileEntity tileEntity) {
        float factor = 1.0f;
        int currenty = 7;
        PoseStack matrixStack = graphics.m_280168_();
        matrixStack.m_252880_(-0.5f, 0.5f, 0.07f);
        float f3 = 0.0075f;
        matrixStack.m_85841_(f3 * factor, -f3 * factor, f3);
        if (tileEntity.getShowHud() == 3) {
            this.renderGfx(graphics, buffer, tileEntity);
        } else {
            this.renderLog(matrixStack, buffer, fontrenderer, tileEntity, currenty);
        }
    }

    private void renderLog(PoseStack matrixStack, MultiBufferSource buffer, Font fontrenderer, ProcessorTileEntity tileEntity, int currenty) {
        List<String> log = tileEntity.getShowHud() == 2 ? tileEntity.getClientDebugLog() : tileEntity.getClientLog();
        long t = System.currentTimeMillis();
        if (t - tileEntity.clientTime > 250L) {
            if (tileEntity.getShowHud() == 2) {
                RFToolsCtrlMessages.INSTANCE.sendToServer((Object)new PacketGetListFromServer(tileEntity.m_58899_(), ProcessorTileEntity.CMD_GETDEBUGLOG.name()));
            } else {
                RFToolsCtrlMessages.INSTANCE.sendToServer((Object)new PacketGetLog(tileEntity.getDimension(), tileEntity.m_58899_(), false));
            }
            tileEntity.clientTime = t;
        }
        int height = 10;
        int logsize = log.size();
        int i = 0;
        for (String s : log) {
            if (i >= logsize - 11 && currenty + height <= 124) {
                RenderHelper.renderText((Font)fontrenderer, (String)fontrenderer.m_92834_(s, 115), (int)7, (int)currenty, (int)-1, (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)0xF000F0);
                currenty += height;
            }
            ++i;
        }
    }

    private void renderGfx(GuiGraphics graphics, MultiBufferSource buffer, ProcessorTileEntity tileEntity) {
        List<GfxOp> ops;
        long t = System.currentTimeMillis();
        if (t - tileEntity.clientTime > 250L) {
            RFToolsCtrlMessages.INSTANCE.sendToServer((Object)new PacketSendServerCommand("rftoolscontrol", "getGraphics", TypedMap.builder().put(CommandHandler.PARAM_POS, (Object)tileEntity.m_58899_()).build()));
            tileEntity.clientTime = t;
        }
        if ((ops = tileEntity.getClientGfxOps()) != null) {
            for (GfxOp op : ops) {
                op.render(graphics, buffer);
            }
        }
    }

    public static void register() {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ProcessorModule.TYPE_PROCESSOR.get()), ProcessorRenderer::new);
    }
}

