/*
 * Decompiled with CFR 0.152.
 */
package com.diontryban.transparent.mixin.client;

import com.diontryban.transparent.Transparent;
import com.diontryban.transparent.client.TransparentClient;
import com.diontryban.transparent.client.render.TransparentRenderTypes;
import com.diontryban.transparent.mixin.client.accessor.TextureAtlasHolderAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.PaintingRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.decoration.Painting;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PaintingRenderer.class})
public abstract class PaintingRendererMixin
extends EntityRenderer<Painting> {
    private MultiBufferSource multiBufferSource;

    protected PaintingRendererMixin(EntityRendererProvider.Context context) {
        super(context);
    }

    @Inject(method={"render(Lnet/minecraft/world/entity/decoration/Painting;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")})
    private void onRender(Painting painting, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, CallbackInfo ci) {
        this.multiBufferSource = multiBufferSource;
    }

    @ModifyVariable(method={"renderPainting"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private VertexConsumer modifyVertexConsumerInRenderPainting(VertexConsumer originalVertexConsumer, PoseStack poseStack, VertexConsumer vertexConsumer, Painting painting, int width, int height, TextureAtlasSprite paintingSprite) {
        if (!Transparent.CONFIG.painting || this.multiBufferSource == null) {
            return originalVertexConsumer;
        }
        MultiBufferSource multiBufferSource = this.multiBufferSource;
        this.multiBufferSource = null;
        return multiBufferSource.m_6299_(TransparentRenderTypes.entitySolid(paintingSprite.m_247685_()));
    }

    @ModifyVariable(method={"renderPainting"}, at=@At(value="HEAD"), argsOnly=true, ordinal=1)
    private TextureAtlasSprite modifyBackSpriteInRenderPainting(TextureAtlasSprite originalBackSprite, PoseStack poseStack, VertexConsumer vertexConsumer, Painting painting, int width, int height, TextureAtlasSprite paintingSprite) {
        TextureAtlasHolderAccessor accessor;
        TextureAtlasSprite blankSprite;
        if (Transparent.CONFIG.painting && TransparentClient.isSpriteContentsTransparent(paintingSprite.m_245424_()) && (blankSprite = (accessor = (TextureAtlasHolderAccessor)Minecraft.m_91087_().m_91305_()).callGetSprite(new ResourceLocation("transparent", "blank"))).m_247685_().equals((Object)paintingSprite.m_247685_())) {
            return blankSprite;
        }
        return originalBackSprite;
    }
}

