/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules;

import com.google.gson.JsonElement;
import java.util.function.Consumer;
import mcjty.incontrol.InControl;
import mcjty.incontrol.compat.ModRuleCompatibilityLayer;
import mcjty.incontrol.rules.support.GenericRuleEvaluator;
import mcjty.incontrol.rules.support.RuleKeys;
import mcjty.incontrol.tools.rules.IEventQuery;
import mcjty.incontrol.tools.rules.IModRuleCompatibilityLayer;
import mcjty.incontrol.tools.rules.RuleBase;
import mcjty.incontrol.tools.typed.Attribute;
import mcjty.incontrol.tools.typed.AttributeMap;
import mcjty.incontrol.tools.typed.GenericAttributeMapFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;

public class LeftClickRule
extends RuleBase<RuleBase.EventGetter> {
    private static final GenericAttributeMapFactory FACTORY = new GenericAttributeMapFactory();
    public static final IEventQuery<PlayerInteractEvent.LeftClickBlock> EVENT_QUERY = new IEventQuery<PlayerInteractEvent.LeftClickBlock>(){

        public Level getWorld(PlayerInteractEvent.LeftClickBlock o) {
            return o.getLevel();
        }

        @Override
        public BlockPos getPos(PlayerInteractEvent.LeftClickBlock o) {
            return o.getPos();
        }

        @Override
        public BlockPos getValidBlockPos(PlayerInteractEvent.LeftClickBlock o) {
            return o.getPos();
        }

        @Override
        public int getY(PlayerInteractEvent.LeftClickBlock o) {
            return o.getPos().m_123342_();
        }

        @Override
        public Entity getEntity(PlayerInteractEvent.LeftClickBlock o) {
            return o.getEntity();
        }

        @Override
        public DamageSource getSource(PlayerInteractEvent.LeftClickBlock o) {
            return null;
        }

        @Override
        public Entity getAttacker(PlayerInteractEvent.LeftClickBlock o) {
            return null;
        }

        @Override
        public Player getPlayer(PlayerInteractEvent.LeftClickBlock o) {
            return o.getEntity();
        }

        @Override
        public ItemStack getItem(PlayerInteractEvent.LeftClickBlock o) {
            return o.getItemStack();
        }
    };
    private Event.Result result;
    private final GenericRuleEvaluator ruleEvaluator;

    private LeftClickRule(AttributeMap map) {
        super(InControl.setup.getLogger());
        this.ruleEvaluator = new GenericRuleEvaluator(map);
        this.addActions(map, new ModRuleCompatibilityLayer());
    }

    @Override
    protected void addActions(AttributeMap map, IModRuleCompatibilityLayer layer) {
        String br;
        super.addActions(map, layer);
        this.result = map.has(RuleKeys.ACTION_RESULT) ? ("default".equals(br = (String)map.get(RuleKeys.ACTION_RESULT)) || br.startsWith("def") ? Event.Result.DEFAULT : ("allow".equals(br) || "true".equals(br) ? Event.Result.ALLOW : Event.Result.DENY)) : Event.Result.DEFAULT;
    }

    public boolean match(PlayerInteractEvent.LeftClickBlock event) {
        return this.ruleEvaluator.match(event, EVENT_QUERY);
    }

    public void action(final PlayerInteractEvent.LeftClickBlock event) {
        RuleBase.EventGetter getter = new RuleBase.EventGetter(){

            @Override
            public LivingEntity getEntityLiving() {
                return event.getEntity();
            }

            @Override
            public Player getPlayer() {
                return event.getEntity();
            }

            public Level getWorld() {
                return event.getLevel();
            }

            @Override
            public BlockPos getPosition() {
                return event.getPos();
            }
        };
        for (Consumer action : this.actions) {
            action.accept(getter);
        }
    }

    public Event.Result getResult() {
        return this.result;
    }

    public static LeftClickRule parse(JsonElement element) {
        if (element == null) {
            return null;
        }
        AttributeMap map = null;
        try {
            map = FACTORY.parse(element, "leftclicks.json");
        }
        catch (Exception e) {
            InControl.setup.getLogger().log(org.apache.logging.log4j.Level.ERROR, (Object)e);
            return null;
        }
        return new LeftClickRule(map);
    }

    static {
        FACTORY.attribute(Attribute.create(RuleKeys.MINTIME)).attribute(Attribute.create(RuleKeys.MAXTIME)).attribute(Attribute.create(RuleKeys.MINLIGHT)).attribute(Attribute.create(RuleKeys.MAXLIGHT)).attribute(Attribute.create(RuleKeys.MINHEIGHT)).attribute(Attribute.create(RuleKeys.MAXHEIGHT)).attribute(Attribute.create(RuleKeys.MINDIFFICULTY)).attribute(Attribute.create(RuleKeys.MAXDIFFICULTY)).attribute(Attribute.create(RuleKeys.MINSPAWNDIST)).attribute(Attribute.create(RuleKeys.MAXSPAWNDIST)).attribute(Attribute.create(RuleKeys.RANDOM)).attribute(Attribute.create(RuleKeys.SEESKY)).attribute(Attribute.create(RuleKeys.WEATHER)).attribute(Attribute.createMulti(RuleKeys.BIOMETAGS)).attribute(Attribute.create(RuleKeys.DIFFICULTY)).attribute(Attribute.create(RuleKeys.STRUCTURE)).attribute(Attribute.createMulti(RuleKeys.MOD)).attribute(Attribute.create(RuleKeys.GAMESTAGE)).attribute(Attribute.create(RuleKeys.WINTER)).attribute(Attribute.create(RuleKeys.SUMMER)).attribute(Attribute.create(RuleKeys.SPRING)).attribute(Attribute.create(RuleKeys.AUTUMN)).attribute(Attribute.create(RuleKeys.INBUILDING)).attribute(Attribute.create(RuleKeys.INCITY)).attribute(Attribute.create(RuleKeys.INSTREET)).attribute(Attribute.create(RuleKeys.INSPHERE)).attribute(Attribute.createMulti(RuleKeys.AMULET)).attribute(Attribute.createMulti(RuleKeys.RING)).attribute(Attribute.createMulti(RuleKeys.BELT)).attribute(Attribute.createMulti(RuleKeys.TRINKET)).attribute(Attribute.createMulti(RuleKeys.HEAD)).attribute(Attribute.createMulti(RuleKeys.BODY)).attribute(Attribute.createMulti(RuleKeys.CHARM)).attribute(Attribute.createMulti(RuleKeys.BLOCK)).attribute(Attribute.create(RuleKeys.BLOCKOFFSET)).attribute(Attribute.createMulti(RuleKeys.HELMET)).attribute(Attribute.createMulti(RuleKeys.CHESTPLATE)).attribute(Attribute.createMulti(RuleKeys.LEGGINGS)).attribute(Attribute.createMulti(RuleKeys.BOOTS)).attribute(Attribute.createMulti(RuleKeys.LACKHELMET)).attribute(Attribute.createMulti(RuleKeys.LACKCHESTPLATE)).attribute(Attribute.createMulti(RuleKeys.LACKLEGGINGS)).attribute(Attribute.createMulti(RuleKeys.LACKBOOTS)).attribute(Attribute.createMulti(RuleKeys.HELDITEM)).attribute(Attribute.createMulti(RuleKeys.PLAYER_HELDITEM)).attribute(Attribute.createMulti(RuleKeys.LACKHELDITEM)).attribute(Attribute.createMulti(RuleKeys.OFFHANDITEM)).attribute(Attribute.createMulti(RuleKeys.LACKOFFHANDITEM)).attribute(Attribute.createMulti(RuleKeys.BOTHHANDSITEM)).attribute(Attribute.createMulti(RuleKeys.BIOME)).attribute(Attribute.createMulti(RuleKeys.BIOMETYPE)).attribute(Attribute.createMulti(RuleKeys.DIMENSION)).attribute(Attribute.createMulti(RuleKeys.DIMENSION_MOD)).attribute(Attribute.create(RuleKeys.ACTION_COMMAND)).attribute(Attribute.create(RuleKeys.ACTION_ADDSTAGE)).attribute(Attribute.create(RuleKeys.ACTION_REMOVESTAGE)).attribute(Attribute.create(RuleKeys.ACTION_MESSAGE)).attribute(Attribute.create(RuleKeys.ACTION_FIRE)).attribute(Attribute.create(RuleKeys.ACTION_EXPLOSION)).attribute(Attribute.create(RuleKeys.ACTION_CLEAR)).attribute(Attribute.create(RuleKeys.ACTION_DAMAGE)).attribute(Attribute.create(RuleKeys.ACTION_SETBLOCK)).attribute(Attribute.create(RuleKeys.ACTION_SETHELDITEM)).attribute(Attribute.create(RuleKeys.ACTION_SETHELDAMOUNT)).attribute(Attribute.create(RuleKeys.ACTION_RESULT)).attribute(Attribute.create(RuleKeys.ACTION_SETSTATE)).attribute(Attribute.create(RuleKeys.ACTION_SETPSTATE)).attribute(Attribute.createMulti(RuleKeys.ACTION_POTION)).attribute(Attribute.createMulti(RuleKeys.ACTION_GIVE)).attribute(Attribute.createMulti(RuleKeys.ACTION_DROP));
    }
}

