/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.data;

import java.util.ArrayList;
import java.util.List;
import mcjty.incontrol.InControl;

public class Statistics {
    private static final List<SpawnStat> SPAWN_STATS = new ArrayList<SpawnStat>();
    private static final List<SpawnerStat> SPAWNER_STATS = new ArrayList<SpawnerStat>();

    public static void addSpawnerStat(int rule) {
        while (rule >= SPAWNER_STATS.size()) {
            SPAWNER_STATS.add(new SpawnerStat());
        }
        SpawnerStat stat = SPAWNER_STATS.get(rule);
        ++stat.counter;
    }

    public static void addSpawnStat(int rule, boolean deny) {
        while (rule >= SPAWN_STATS.size()) {
            SPAWN_STATS.add(new SpawnStat());
        }
        SpawnStat stat = SPAWN_STATS.get(rule);
        ++stat.counter;
        stat.deny = deny;
    }

    public static void clear() {
        SPAWN_STATS.clear();
        SPAWNER_STATS.clear();
    }

    public static void dump() {
        Object stat;
        int i;
        InControl.setup.getLogger().info("### Spawner ###");
        for (i = 0; i < SPAWNER_STATS.size(); ++i) {
            stat = SPAWNER_STATS.get(i);
            InControl.setup.getLogger().info("Rule " + i + " spawned " + ((SpawnerStat)stat).counter + " mobs");
        }
        InControl.setup.getLogger().info("### Spawn ###");
        for (i = 0; i < SPAWN_STATS.size(); ++i) {
            stat = SPAWN_STATS.get(i);
            InControl.setup.getLogger().info("Rule " + i + " fired " + ((SpawnStat)stat).counter + " times (" + (((SpawnStat)stat).deny ? "deny)" : "allow)"));
        }
    }

    private static class SpawnerStat {
        private int counter;

        private SpawnerStat() {
        }
    }

    private static class SpawnStat {
        private int counter;
        private boolean deny;

        private SpawnStat() {
        }
    }
}

