/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol;

import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import mcjty.incontrol.InControl;
import mcjty.incontrol.commands.ModCommands;
import mcjty.incontrol.data.DataStorage;
import mcjty.incontrol.data.Statistics;
import mcjty.incontrol.rules.EffectRule;
import mcjty.incontrol.rules.ExperienceRule;
import mcjty.incontrol.rules.HarvestRule;
import mcjty.incontrol.rules.LeftClickRule;
import mcjty.incontrol.rules.LootRule;
import mcjty.incontrol.rules.PlaceRule;
import mcjty.incontrol.rules.RightClickRule;
import mcjty.incontrol.rules.RulesManager;
import mcjty.incontrol.rules.SpawnRule;
import mcjty.incontrol.rules.SpawnWhen;
import mcjty.incontrol.rules.SummonAidRule;
import mcjty.incontrol.spawner.SpawnerSystem;
import mcjty.incontrol.tools.varia.Tools;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeEventHandlers {
    public static boolean debug = false;
    public static Map<Integer, Integer> tickCounters = new HashMap<Integer, Integer>();

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinWorld(EntityJoinLevelEvent event) {
        int i = 0;
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            return;
        }
        if (event.getLevel().f_46443_) {
            return;
        }
        for (SpawnRule rule : RulesManager.getFilteredRules(event.getLevel(), SpawnWhen.ONJOIN)) {
            if (rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    InControl.setup.getLogger().log(org.apache.logging.log4j.Level.INFO, "Join Rule " + i + ": " + result + " entity: " + event.getEntity().m_7755_() + " y: " + event.getEntity().m_20183_().m_123342_());
                }
                if (result != Event.Result.DENY) {
                    Statistics.addSpawnStat(i, false);
                    rule.action(event);
                } else {
                    Statistics.addSpawnStat(i, true);
                    event.setCanceled(true);
                }
                if (!rule.isDoContinue()) {
                    return;
                }
            }
            ++i;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityJoinWorldLast(EntityJoinLevelEvent event) {
        if (!event.getLevel().m_5776_() && event.getEntity() instanceof LivingEntity && !(event.getEntity() instanceof Player)) {
            InControl.setup.cache.registerSpawn((LevelAccessor)event.getLevel(), event.getEntity().m_6095_());
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.level.f_46443_) {
            InControl.setup.cache.performCount((LevelAccessor)event.level);
            if (!event.level.m_6907_().isEmpty()) {
                SpawnerSystem.checkRules(event);
            }
            if (event.level.m_46472_().equals((Object)Level.f_46428_)) {
                DataStorage.getData(event.level).tick(event.level);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntitySpawnEvent(MobSpawnEvent.FinalizeSpawn event) {
        int i = 0;
        for (SpawnRule rule : RulesManager.getFilteredRules(event.getEntity().m_20193_(), SpawnWhen.FINALIZE)) {
            if (rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    Holder biome = event.getLevel().m_204166_(new BlockPos((int)event.getX(), (int)event.getY(), (int)event.getZ()));
                    String biomeId = Tools.getBiomeId((Holder<Biome>)biome);
                    InControl.setup.getLogger().log(org.apache.logging.log4j.Level.INFO, "Finalize Rule " + i + ": " + result + " entity: " + event.getEntity().m_7755_() + " y: " + event.getY() + " biome: " + biomeId);
                }
                if (result == Event.Result.ALLOW) {
                    rule.action(event);
                    event.setCanceled(true);
                } else if (result == Event.Result.DENY) {
                    event.setCanceled(true);
                    event.setSpawnCancelled(true);
                } else {
                    rule.action(event);
                }
                if (!rule.isDoContinue()) {
                    return;
                }
            }
            ++i;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPositionCheck(MobSpawnEvent.PositionCheck event) {
        int i = 0;
        for (SpawnRule rule : RulesManager.getFilteredRules(event.getEntity().m_20193_(), SpawnWhen.POSITION)) {
            if (rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    Holder biome = event.getLevel().m_204166_(new BlockPos((int)event.getX(), (int)event.getY(), (int)event.getZ()));
                    String biomeId = Tools.getBiomeId((Holder<Biome>)biome);
                    InControl.setup.getLogger().log(org.apache.logging.log4j.Level.INFO, "Position Rule " + i + ": " + result + " entity: " + event.getEntity().m_7755_() + " y: " + event.getY() + " biome: " + biomeId);
                }
                if (result != null) {
                    event.setResult(result);
                }
                if (result != Event.Result.DENY) {
                    Statistics.addSpawnStat(i, false);
                    rule.action(event);
                } else {
                    Statistics.addSpawnStat(i, true);
                }
                if (!rule.isDoContinue()) {
                    return;
                }
            }
            ++i;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onCheckDespawn(MobSpawnEvent.AllowDespawn event) {
        int i = 0;
        for (SpawnRule rule : RulesManager.getFilteredRules(event.getEntity().m_20193_(), SpawnWhen.DESPAWN)) {
            if (rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    Holder biome = event.getLevel().m_204166_(new BlockPos((int)event.getX(), (int)event.getY(), (int)event.getZ()));
                    String biomeId = Tools.getBiomeId((Holder<Biome>)biome);
                    InControl.setup.getLogger().log(org.apache.logging.log4j.Level.INFO, "Despawn Rule " + i + ": " + result + " entity: " + event.getEntity().m_7755_() + " y: " + event.getY() + " biome: " + biomeId);
                }
                if (result != null) {
                    event.setResult(result);
                }
                if (result != Event.Result.DENY) {
                    rule.action(event);
                }
                if (!rule.isDoContinue()) {
                    return;
                }
            }
            ++i;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSummonAidEvent(ZombieEvent.SummonAidEvent event) {
        int i = 0;
        for (SummonAidRule rule : RulesManager.getFilteredSummonAidRules(event.getLevel())) {
            if (rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    Holder biome = event.getLevel().m_204166_(new BlockPos(event.getX(), event.getY(), event.getZ()));
                    String biomeId = Tools.getBiomeId((Holder<Biome>)biome);
                    InControl.setup.getLogger().log(org.apache.logging.log4j.Level.INFO, "SummonAid " + i + ": " + result + " entity: " + event.getEntity().m_7755_() + " y: " + event.getY() + " biome: " + biomeId);
                }
                event.setResult(result);
                if (result != Event.Result.DENY) {
                    rule.action(event);
                }
                return;
            }
            ++i;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        int i = 0;
        for (ExperienceRule rule : RulesManager.getFilteredExperienceRuiles(event.getEntity().m_9236_())) {
            if (rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    InControl.setup.getLogger().log(org.apache.logging.log4j.Level.INFO, "Experience Rule " + i + ": " + result + " entity: " + event.getEntity().m_7755_() + " y: " + event.getEntity().m_20183_().m_123342_());
                }
                if (result != Event.Result.DENY) {
                    int newxp = rule.modifyXp(event.getDroppedExperience());
                    event.setDroppedExperience(newxp);
                } else {
                    event.setCanceled(true);
                }
                return;
            }
            ++i;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDrops(LivingDropsEvent event) {
        Level world = event.getEntity().m_20193_();
        int i = 0;
        for (LootRule rule : RulesManager.getFilteredLootRules(world)) {
            if (rule.match(event)) {
                if (debug) {
                    InControl.setup.getLogger().log(org.apache.logging.log4j.Level.INFO, "Loot " + i + ":  entity: " + event.getEntity().m_7755_());
                }
                if (rule.isRemoveAll()) {
                    event.getDrops().clear();
                } else {
                    ArrayList<ItemEntity> toRemove = null;
                    for (Predicate<ItemStack> predicate : rule.getToRemoveItems()) {
                        Collection drops = event.getDrops();
                        for (ItemEntity drop : drops) {
                            ItemStack stack = drop.m_32055_();
                            if (!predicate.test(stack)) continue;
                            if (toRemove == null) {
                                toRemove = new ArrayList<ItemEntity>();
                            }
                            toRemove.add(drop);
                        }
                    }
                    if (toRemove != null) {
                        Collection drops = event.getDrops();
                        for (ItemEntity entity : toRemove) {
                            drops.remove(entity);
                        }
                    }
                }
                for (Pair<ItemStack, Function<Integer, Integer>> pair : rule.getToAddItems()) {
                    ItemStack copy;
                    int amount;
                    ItemStack itemStack = (ItemStack)pair.getLeft();
                    int fortune = event.getLootingLevel();
                    BlockPos pos = event.getEntity().m_20183_();
                    for (amount = ((Integer)((Function)pair.getValue()).apply(fortune)).intValue(); amount > itemStack.m_41741_(); amount -= itemStack.m_41741_()) {
                        copy = itemStack.m_41777_();
                        copy.m_41764_(itemStack.m_41741_());
                        event.getDrops().add(new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), copy));
                    }
                    if (amount <= 0) continue;
                    copy = itemStack.m_41777_();
                    copy.m_41764_(amount);
                    event.getDrops().add(new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), copy));
                }
            }
            ++i;
        }
    }

    @SubscribeEvent
    public void onRightClickEvent(PlayerInteractEvent.RightClickBlock event) {
        if (event.getLevel().f_46443_) {
            return;
        }
        int i = 0;
        for (RightClickRule rule : RulesManager.rightclickRules) {
            if (rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    Holder biome = event.getLevel().m_204166_(event.getPos());
                    String biomeId = Tools.getBiomeId((Holder<Biome>)biome);
                    InControl.setup.getLogger().log(org.apache.logging.log4j.Level.INFO, "Rule " + i + ": " + result + " entity: " + event.getEntity().m_7755_() + " y: " + event.getPos().m_123342_() + " biome: " + biomeId);
                }
                rule.action(event);
                event.setUseBlock(result);
                if (result == Event.Result.DENY) {
                    event.setCanceled(true);
                }
                return;
            }
            ++i;
        }
    }

    @SubscribeEvent
    public void onLeftClickEvent(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getLevel().f_46443_) {
            return;
        }
        int i = 0;
        for (LeftClickRule rule : RulesManager.leftclickRules) {
            if (rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    Holder biome = event.getLevel().m_204166_(event.getPos());
                    String biomeId = Tools.getBiomeId((Holder<Biome>)biome);
                    InControl.setup.getLogger().log(org.apache.logging.log4j.Level.INFO, "Rule " + i + ": " + result + " entity: " + event.getEntity().m_7755_() + " y: " + event.getPos().m_123342_() + " biome: " + biomeId);
                }
                rule.action(event);
                event.setUseBlock(result);
                if (result == Event.Result.DENY) {
                    event.setCanceled(true);
                }
                return;
            }
            ++i;
        }
    }

    @SubscribeEvent
    public void onBlockPaceEvent(BlockEvent.EntityPlaceEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        int i = 0;
        for (PlaceRule rule : RulesManager.placeRules) {
            if (rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    Holder biome = event.getLevel().m_204166_(event.getPos());
                    String biomeId = Tools.getBiomeId((Holder<Biome>)biome);
                    InControl.setup.getLogger().log(org.apache.logging.log4j.Level.INFO, "Rule " + i + ": " + result + " entity: " + event.getEntity().m_7755_() + " y: " + event.getPos().m_123342_() + " biome: " + biomeId);
                }
                rule.action(event);
                if (result == Event.Result.DENY) {
                    event.setCanceled(true);
                }
                return;
            }
            ++i;
        }
    }

    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        int i = 0;
        for (HarvestRule rule : RulesManager.harvestRules) {
            if (rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    Holder biome = event.getLevel().m_204166_(event.getPos());
                    String biomeId = Tools.getBiomeId((Holder<Biome>)biome);
                    InControl.setup.getLogger().log(org.apache.logging.log4j.Level.INFO, "Rule " + i + ": " + result + " entity: " + event.getPlayer().m_7755_() + " y: " + event.getPos().m_123342_() + " biome: " + biomeId);
                }
                rule.action(event);
                if (result == Event.Result.DENY) {
                    event.setCanceled(true);
                }
                return;
            }
            ++i;
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        int id = event.player.m_19879_();
        if (!tickCounters.containsKey(id)) {
            tickCounters.put(id, 0);
        }
        int tickCounter = tickCounters.get(id) + 1;
        tickCounters.put(id, tickCounter);
        int i = 0;
        for (EffectRule rule : RulesManager.effectRules) {
            if (tickCounter % rule.getTimeout() == 0 && rule.match(event)) {
                if (debug) {
                    InControl.setup.getLogger().log(org.apache.logging.log4j.Level.INFO, "Join Rule " + i + " entity: " + event.player.m_7755_() + " y: " + event.player.m_20183_().m_123342_());
                }
                rule.action(event);
                return;
            }
            ++i;
        }
    }
}

