/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.screen.menu;

import earth.terrarium.ad_astra.common.block.machine.entity.AbstractMachineBlockEntity;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMachineMenu<T extends AbstractMachineBlockEntity>
extends AbstractContainerMenu {
    protected final T machine;
    protected final Level level;
    protected final Player player;
    protected long energyAmount;
    protected List<FluidHolder> fluids;

    public AbstractMachineMenu(MenuType<?> type, int syncId, Inventory inventory, T entity) {
        this(type, syncId, inventory, entity, new Slot[0]);
    }

    public AbstractMachineMenu(MenuType<?> type, int syncId, Inventory inventory, T entity, Slot[] slots) {
        super(type, syncId);
        this.machine = entity;
        this.level = entity.m_58904_();
        this.player = inventory.f_35978_;
        AbstractMachineMenu.m_38869_((Container)inventory, (int)((AbstractMachineBlockEntity)this.machine).getInventorySize());
        this.machine.m_5856_(inventory.f_35978_);
        for (Slot slot : slots) {
            this.m_38897_(slot);
        }
        this.setPlayerInventory(inventory);
    }

    public T getMachine() {
        return this.machine;
    }

    public boolean m_6875_(@NotNull Player player) {
        return this.machine.m_6542_(player);
    }

    protected void setPlayerInventory(Inventory inventory) {
        int m;
        for (m = 0; m < 3; ++m) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)inventory, l + m * 9 + 9, 8 + l * 18, 84 + this.getPlayerInventoryOffset() + m * 18));
            }
        }
        for (m = 0; m < 9; ++m) {
            this.m_38897_(new Slot((Container)inventory, m, 8 + m * 18, 142 + this.getPlayerInventoryOffset()));
        }
    }

    public int getPlayerInventoryOffset() {
        return 0;
    }

    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack newStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack originalStack = slot.m_7993_();
            newStack = originalStack.m_41777_();
            if (index < this.machine.m_6643_() ? !this.m_38903_(originalStack, this.machine.m_6643_(), this.f_38839_.size(), true) : !this.m_38903_(originalStack, 0, this.machine.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (originalStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return newStack;
    }

    public long getEnergyAmount() {
        return this.energyAmount;
    }

    public void setEnergyAmount(long energyAmount) {
        this.energyAmount = energyAmount;
    }

    public List<FluidHolder> getFluids() {
        return this.fluids == null ? List.of(FluidHooks.emptyFluid(), FluidHooks.emptyFluid()) : this.fluids;
    }

    public void setFluids(List<FluidHolder> fluids) {
        this.fluids = fluids;
    }

    public void m_150399_(int slotIndex, int button, @NotNull ClickType actionType, @NotNull Player player) {
        super.m_150399_(slotIndex, button, actionType, player);
        this.m_182423_();
    }

    public void m_38946_() {
        super.m_38946_();
        this.syncClientScreen();
    }

    public void onRecipeTransfer(Recipe<?> recipe) {
    }

    public abstract void syncClientScreen();
}

