/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.item;

import earth.terrarium.ad_astra.common.config.AdAstraConfig;
import earth.terrarium.ad_astra.common.item.FluidContainingItem;
import earth.terrarium.ad_astra.common.registry.ModFluids;
import earth.terrarium.ad_astra.common.registry.ModItems;
import earth.terrarium.ad_astra.common.registry.ModTags;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;

public class OxygenTankItem
extends Item
implements FluidContainingItem {
    public OxygenTankItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack createOxygenatedTank() {
        ItemStackHolder oxygenTank = new ItemStackHolder(((Item)ModItems.OXYGEN_TANK.get()).m_7968_());
        ((OxygenTankItem)oxygenTank.getStack().m_41720_()).insert(oxygenTank, FluidHooks.newFluidHolder((Fluid)((Fluid)ModFluids.OXYGEN.get()), (long)Long.MAX_VALUE, null));
        return oxygenTank.getStack();
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag context) {
        long oxygen = FluidHooks.toMillibuckets((long)FluidHooks.getItemFluidManager((ItemStack)stack).getFluidInTank(0).getFluidAmount());
        tooltip.add((Component)Component.m_237115_((String)"tooltip.ad_astra.consumable"));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.ad_astra.space_suit", (Object[])new Object[]{oxygen, FluidHooks.toMillibuckets((long)this.getTankSize())}).m_6270_(Style.f_131099_.m_131140_(oxygen > 0L ? ChatFormatting.GREEN : ChatFormatting.RED)));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player user, InteractionHand hand) {
        if (!level.f_46443_) {
            FluidHolder fromFluidHolder;
            ItemStackHolder to;
            ItemStackHolder from;
            ItemStack tank = user.m_21120_(hand);
            ItemStack chest = user.m_6844_(EquipmentSlot.CHEST);
            if ((chest.m_150930_((Item)ModItems.SPACE_SUIT.get()) || chest.m_150930_((Item)ModItems.NETHERITE_SPACE_SUIT.get()) || chest.m_150930_((Item)ModItems.JET_SUIT.get())) && FluidHooks.moveItemToItemFluid((ItemStackHolder)(from = new ItemStackHolder(tank)), (ItemStackHolder)(to = new ItemStackHolder(user.m_150109_().m_36052_(2))), (FluidHolder)(fromFluidHolder = FluidHooks.getItemFluidManager((ItemStack)from.getStack()).getFluidInTank(0))) > 0L) {
                if (from.isDirty()) {
                    user.m_21008_(hand, from.getStack());
                }
                if (to.isDirty()) {
                    user.m_8061_(EquipmentSlot.CHEST, to.getStack());
                }
                level.m_5594_(null, user.m_20183_(), SoundEvents.f_11911_, SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResultHolder.m_19096_((Object)tank);
            }
        }
        return super.m_7203_(level, user, hand);
    }

    @Override
    public BiPredicate<Integer, FluidHolder> getFilter() {
        return (i, f) -> f.getFluid().m_205067_(ModTags.OXYGEN);
    }

    @Override
    public long getTankSize() {
        return AdAstraConfig.oxygenTankSize;
    }
}

