/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.launchpad;

import earth.terrarium.ad_astra.common.block.door.LocationState;
import java.util.List;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
public class LaunchPad
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<LocationState> LOCATION = EnumProperty.m_61587_((String)"location", LocationState.class);

    public LaunchPad(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(LOCATION, (Comparable)((Object)LocationState.CENTER)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.m_60824_(level, pos);
        return Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[0]).m_83216_(offset.m_7096_(), offset.m_7098_(), offset.m_7094_());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, LOCATION});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (!level.f_46443_) {
            level.m_7731_(pos.m_122012_(), (BlockState)this.m_49966_().m_61124_(LOCATION, (Comparable)((Object)LocationState.TOP)), 3);
            level.m_7731_(pos.m_122029_(), (BlockState)this.m_49966_().m_61124_(LOCATION, (Comparable)((Object)LocationState.RIGHT)), 3);
            level.m_7731_(pos.m_122019_(), (BlockState)this.m_49966_().m_61124_(LOCATION, (Comparable)((Object)LocationState.BOTTOM)), 3);
            level.m_7731_(pos.m_122024_(), (BlockState)this.m_49966_().m_61124_(LOCATION, (Comparable)((Object)LocationState.LEFT)), 3);
            level.m_7731_(pos.m_122012_().m_122029_(), (BlockState)this.m_49966_().m_61124_(LOCATION, (Comparable)((Object)LocationState.TOP_RIGHT)), 3);
            level.m_7731_(pos.m_122012_().m_122024_(), (BlockState)this.m_49966_().m_61124_(LOCATION, (Comparable)((Object)LocationState.TOP_LEFT)), 3);
            level.m_7731_(pos.m_122019_().m_122029_(), (BlockState)this.m_49966_().m_61124_(LOCATION, (Comparable)((Object)LocationState.BOTTOM_RIGHT)), 3);
            level.m_7731_(pos.m_122019_().m_122024_(), (BlockState)this.m_49966_().m_61124_(LOCATION, (Comparable)((Object)LocationState.BOTTOM_LEFT)), 3);
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(level, pos, state, player);
        this.breakPad(level, level.m_8055_(pos), pos, !player.m_7500_());
    }

    public void m_7592_(Level level, BlockPos pos, Explosion explosion) {
        if (!level.f_46443_) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos offset = pos.m_121945_(direction);
                BlockState state = level.m_8055_(offset);
                if (!state.m_60734_().equals((Object)this)) continue;
                this.breakPad(level, state, offset, true);
                break;
            }
        }
        super.m_7592_(level, pos, explosion);
    }

    public void breakPad(Level level, BlockState state, BlockPos pos, boolean drop) {
        if (!level.f_46443_ && state.m_60734_().equals((Object)this)) {
            BlockPos mainPos = this.getMainPos(state, pos);
            this.getBlockPosAround(mainPos).forEach(blockPos -> level.m_46961_(blockPos, drop));
            level.m_46961_(mainPos, drop);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos mainPos = this.getMainPos(state, pos);
        if (level.m_8055_(pos.m_7495_()).m_60734_() instanceof LaunchPad) {
            return false;
        }
        return this.canReplace((BlockGetter)level, mainPos) && this.getBlockPosAround(mainPos).stream().allMatch(blockPos -> this.canReplace((BlockGetter)level, (BlockPos)blockPos));
    }

    private boolean canReplace(BlockGetter world, BlockPos pos) {
        return world.m_8055_(pos).m_247087_();
    }

    public List<BlockPos> getBlockPosAround(BlockPos pos) {
        return List.of(pos, pos.m_122012_(), pos.m_122029_(), pos.m_122019_(), pos.m_122024_(), pos.m_122012_().m_122029_(), pos.m_122012_().m_122024_(), pos.m_122019_().m_122029_(), pos.m_122019_().m_122024_());
    }

    public BlockPos getMainPos(BlockState state, BlockPos from) {
        return switch ((LocationState)((Object)state.m_61143_(LOCATION))) {
            default -> throw new IncompatibleClassChangeError();
            case LocationState.TOP_LEFT -> from.m_122019_().m_122029_();
            case LocationState.TOP -> from.m_122019_();
            case LocationState.TOP_RIGHT -> from.m_122019_().m_122024_();
            case LocationState.LEFT -> from.m_122029_();
            case LocationState.CENTER -> from;
            case LocationState.RIGHT -> from.m_122024_();
            case LocationState.BOTTOM_LEFT -> from.m_122012_().m_122029_();
            case LocationState.BOTTOM -> from.m_122012_();
            case LocationState.BOTTOM_RIGHT -> from.m_122012_().m_122024_();
        };
    }
}

