/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.door;

import earth.terrarium.ad_astra.common.block.door.LocationState;
import earth.terrarium.ad_astra.common.block.door.SlidingDoorBlockEntity;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
public class SlidingDoorBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<LocationState> LOCATION = EnumProperty.m_61587_((String)"location", LocationState.class);
    protected static final VoxelShape X_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape Z_SHAPE = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape GIANT_X_SHAPE = Block.m_49796_((double)-16.0, (double)-16.0, (double)0.0, (double)32.0, (double)32.0, (double)3.0);
    protected static final VoxelShape GIANT_Z_SHAPE = Block.m_49796_((double)0.0, (double)-16.0, (double)-16.0, (double)3.0, (double)32.0, (double)32.0);

    public SlidingDoorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(LOCATION, (Comparable)((Object)LocationState.BOTTOM)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN, POWERED, LOCATION});
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (!level.f_46443_) {
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            Direction offset = direction.m_122427_();
            level.m_7731_(pos, (BlockState)((BlockState)this.m_49966_().m_61124_(LOCATION, (Comparable)((Object)LocationState.BOTTOM))).m_61124_((Property)FACING, (Comparable)direction), 3);
            level.m_7731_(pos.m_121945_(offset), (BlockState)((BlockState)this.m_49966_().m_61124_(LOCATION, (Comparable)((Object)LocationState.BOTTOM_LEFT))).m_61124_((Property)FACING, (Comparable)direction), 3);
            level.m_7731_(pos.m_121945_(offset.m_122424_()), (BlockState)((BlockState)this.m_49966_().m_61124_(LOCATION, (Comparable)((Object)LocationState.BOTTOM_RIGHT))).m_61124_((Property)FACING, (Comparable)direction), 3);
            level.m_7731_(pos.m_7494_(), (BlockState)((BlockState)this.m_49966_().m_61124_(LOCATION, (Comparable)((Object)LocationState.CENTER))).m_61124_((Property)FACING, (Comparable)direction), 3);
            level.m_7731_(pos.m_7494_().m_121945_(offset), (BlockState)((BlockState)this.m_49966_().m_61124_(LOCATION, (Comparable)((Object)LocationState.LEFT))).m_61124_((Property)FACING, (Comparable)direction), 3);
            level.m_7731_(pos.m_7494_().m_121945_(offset.m_122424_()), (BlockState)((BlockState)this.m_49966_().m_61124_(LOCATION, (Comparable)((Object)LocationState.RIGHT))).m_61124_((Property)FACING, (Comparable)direction), 3);
            level.m_7731_(pos.m_7494_().m_7494_(), (BlockState)((BlockState)this.m_49966_().m_61124_(LOCATION, (Comparable)((Object)LocationState.TOP))).m_61124_((Property)FACING, (Comparable)direction), 3);
            level.m_7731_(pos.m_7494_().m_7494_().m_121945_(offset), (BlockState)((BlockState)this.m_49966_().m_61124_(LOCATION, (Comparable)((Object)LocationState.TOP_LEFT))).m_61124_((Property)FACING, (Comparable)direction), 3);
            level.m_7731_(pos.m_7494_().m_7494_().m_121945_(offset.m_122424_()), (BlockState)((BlockState)this.m_49966_().m_61124_(LOCATION, (Comparable)((Object)LocationState.TOP_RIGHT))).m_61124_((Property)FACING, (Comparable)direction), 3);
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(level, pos, state, player);
        this.breakDoor(level, level.m_8055_(pos), pos, !player.m_7500_());
    }

    public void m_7592_(Level level, BlockPos pos, Explosion explosion) {
        for (Direction direction : Direction.values()) {
            BlockPos offset = pos.m_121945_(direction);
            BlockState state = level.m_8055_(offset);
            if (!state.m_60734_().equals((Object)this)) continue;
            this.breakDoor(level, state, offset, true);
            break;
        }
        super.m_7592_(level, pos, explosion);
    }

    public void breakDoor(Level level, BlockState state, BlockPos pos, boolean drop) {
        BlockPos mainPos;
        if (!level.f_46443_ && state.m_60734_().equals((Object)this) && level.m_8055_(mainPos = this.getMainPos(state, pos)).m_60734_().equals((Object)this)) {
            Direction direction = ((Direction)state.m_61143_((Property)FACING)).m_122428_();
            level.m_46961_(mainPos, drop);
            level.m_46961_(mainPos.m_121945_(direction), false);
            level.m_46961_(mainPos.m_121945_(direction.m_122424_()), false);
            level.m_46961_(mainPos.m_7494_(), false);
            level.m_46961_(mainPos.m_7494_().m_121945_(direction), false);
            level.m_46961_(mainPos.m_7494_().m_121945_(direction.m_122424_()), false);
            level.m_46961_(mainPos.m_7494_().m_7494_(), false);
            level.m_46961_(mainPos.m_7494_().m_7494_().m_121945_(direction), false);
            level.m_46961_(mainPos.m_7494_().m_7494_().m_121945_(direction.m_122424_()), false);
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND -> (Boolean)state.m_61143_((Property)OPEN);
            case PathComputationType.WATER -> false;
            case PathComputationType.AIR -> (Boolean)state.m_61143_((Property)OPEN);
        };
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            BlockPos main = this.getMainPos(state, pos);
            BlockEntity blockEntity = level.m_7702_(this.getMainPos(state, pos));
            if (blockEntity instanceof SlidingDoorBlockEntity) {
                SlidingDoorBlockEntity entity = (SlidingDoorBlockEntity)blockEntity;
                if (entity.getSlideTicks() > 0 && entity.getSlideTicks() < 100) {
                    return InteractionResult.PASS;
                }
                level.m_7731_(main, (BlockState)level.m_8055_(main).m_61122_((Property)OPEN), 10);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        LocationState location = (LocationState)((Object)state.m_61143_(LOCATION));
        return switch (location) {
            case LocationState.TOP -> this.getFacingOutlineShape(state, -1.0);
            case LocationState.CENTER -> this.getFacingOutlineShape(state, 0.0);
            case LocationState.BOTTOM -> this.getFacingOutlineShape(state, 1.0);
            default -> {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    case NORTH: {
                        yield X_SHAPE.m_83216_(0.0, 0.0, 0.42);
                    }
                    case EAST: {
                        yield Z_SHAPE.m_83216_(-0.38, 0.0, 0.0);
                    }
                    case SOUTH: {
                        yield X_SHAPE.m_83216_(0.0, 0.0, 0.38);
                    }
                    case WEST: {
                        yield Z_SHAPE.m_83216_(-0.42, 0.0, 0.0);
                    }
                }
                yield Shapes.m_83040_();
            }
        };
    }

    private VoxelShape getFacingOutlineShape(BlockState state, double offset) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> GIANT_X_SHAPE.m_83216_(0.0, offset, 0.42);
            case Direction.EAST -> GIANT_Z_SHAPE.m_83216_(0.38, offset, 0.0);
            case Direction.SOUTH -> GIANT_X_SHAPE.m_83216_(0.0, offset, 0.38);
            case Direction.WEST -> GIANT_Z_SHAPE.m_83216_(0.42, offset, 0.0);
            default -> Shapes.m_83040_();
        };
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos mainPos = this.getMainPos(state, pos);
        Direction direction = ((Direction)state.m_61143_((Property)FACING)).m_122427_();
        return level.m_8055_(mainPos).m_60795_() && level.m_8055_(mainPos.m_121945_(direction)).m_60795_() && level.m_8055_(mainPos.m_121945_(direction.m_122424_())).m_60795_() && level.m_8055_(mainPos.m_7494_()).m_60795_() && level.m_8055_(mainPos.m_7494_().m_121945_(direction)).m_60795_() && level.m_8055_(mainPos.m_7494_().m_121945_(direction.m_122424_())).m_60795_() && level.m_8055_(mainPos.m_7494_().m_7494_()).m_60795_() && level.m_8055_(mainPos.m_7494_().m_7494_().m_121945_(direction)).m_60795_() && level.m_8055_(mainPos.m_7494_().m_7494_().m_121945_(direction.m_122424_())).m_60795_();
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(ctx.m_43725_().m_276867_(ctx.m_8083_())))).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        super.m_6861_(state, level, pos, block, fromPos, notify);
        if (!level.f_46443_) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(level.m_276867_(pos))));
        }
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BlockState main = level.m_8055_(this.getMainPos(state, pos));
        if (main.m_61138_((Property)OPEN) && !((Boolean)main.m_61143_((Property)OPEN)).booleanValue() && !((Boolean)main.m_61143_((Property)POWERED)).booleanValue()) {
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            return switch (direction) {
                case Direction.NORTH -> X_SHAPE.m_83216_(0.0, 0.0, 0.42);
                case Direction.EAST -> Z_SHAPE.m_83216_(-0.38, 0.0, 0.0);
                case Direction.SOUTH -> X_SHAPE.m_83216_(0.0, 0.0, 0.38);
                case Direction.WEST -> Z_SHAPE.m_83216_(-0.42, 0.0, 0.0);
                default -> Shapes.m_83040_();
            };
        }
        return Shapes.m_83040_();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (((LocationState)((Object)state.m_61143_(LOCATION))).equals((Object)LocationState.BOTTOM)) {
            return new SlidingDoorBlockEntity(pos, state);
        }
        return null;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (state.m_61143_(LOCATION) != LocationState.BOTTOM) {
            return null;
        }
        return (entityWorld, pos, entityState, blockEntity) -> {
            if (blockEntity instanceof SlidingDoorBlockEntity) {
                SlidingDoorBlockEntity door = (SlidingDoorBlockEntity)blockEntity;
                door.tick();
            }
        };
    }

    public BlockPos getMainPos(BlockState state, BlockPos from) {
        BlockPos target = from;
        Direction facing = ((Direction)state.m_61143_((Property)FACING)).m_122428_();
        if (((LocationState)((Object)state.m_61143_(LOCATION))).equals((Object)LocationState.TOP_LEFT)) {
            target = from.m_7495_().m_7495_().m_121945_(facing);
        } else if (((LocationState)((Object)state.m_61143_(LOCATION))).equals((Object)LocationState.TOP)) {
            target = from.m_7495_().m_7495_();
        } else if (((LocationState)((Object)state.m_61143_(LOCATION))).equals((Object)LocationState.TOP_RIGHT)) {
            target = from.m_7495_().m_7495_().m_121945_(facing.m_122424_());
        } else if (((LocationState)((Object)state.m_61143_(LOCATION))).equals((Object)LocationState.RIGHT)) {
            target = from.m_7495_().m_121945_(facing.m_122424_());
        } else if (((LocationState)((Object)state.m_61143_(LOCATION))).equals((Object)LocationState.CENTER)) {
            target = from.m_7495_();
        } else if (((LocationState)((Object)state.m_61143_(LOCATION))).equals((Object)LocationState.LEFT)) {
            target = from.m_7495_().m_121945_(facing);
        } else if (((LocationState)((Object)state.m_61143_(LOCATION))).equals((Object)LocationState.BOTTOM_LEFT)) {
            target = from.m_121945_(facing);
        } else if (((LocationState)((Object)state.m_61143_(LOCATION))).equals((Object)LocationState.BOTTOM_RIGHT)) {
            target = from.m_121945_(facing.m_122424_());
        }
        return target;
    }
}

