/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.dimension.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import earth.terrarium.ad_astra.mixin.client.LevelRendererAccessor;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class VenusCloudRenderer {
    private static final ResourceLocation VENUS_CLOUD_TEXTURE = new ResourceLocation("ad_astra", "textures/sky/venus/clouds.png");

    public static void render(ClientLevel level, int ticks, float tickDelta, PoseStack poseStack, double cameraX, double cameraY, double cameraZ, Matrix4f projectionMatrix) {
        Minecraft minecraft = Minecraft.m_91087_();
        LevelRendererAccessor renderer = (LevelRendererAccessor)minecraft.f_91060_;
        float f = level.m_104583_().m_108871_();
        if (!Float.isNaN(f)) {
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.depthMask((boolean)true);
            double e = ((float)ticks + tickDelta) * 0.03f;
            double i = (cameraX + e) / 12.0;
            double j = f - (float)cameraY + 0.33f;
            double k = cameraZ / 12.0 + (double)0.33f;
            i -= (double)(Mth.m_14107_((double)(i / 2048.0)) * 2048);
            k -= (double)(Mth.m_14107_((double)(k / 2048.0)) * 2048);
            float l = (float)(i - (double)Mth.m_14107_((double)i));
            float m = (float)(j / 4.0 - (double)Mth.m_14107_((double)(j / 4.0))) * 4.0f;
            float n = (float)(k - (double)Mth.m_14107_((double)k));
            Vec3 colour = level.m_104808_(tickDelta);
            int o = (int)Math.floor(i);
            int p = (int)Math.floor(j / 4.0);
            int q = (int)Math.floor(k);
            if (o != renderer.getPrevCloudX() || p != renderer.getPrevCloudY() || q != renderer.getPrevCloudZ() || minecraft.f_91066_.m_92174_() != renderer.getPrevCloudsType() || renderer.getPrevCloudColor().m_82557_(colour) > 2.0E-4) {
                renderer.setPrevCloudX(o);
                renderer.setPrevCloudY(p);
                renderer.setPrevCloudZ(q);
                renderer.setPrevCloudColor(colour);
                renderer.setPrevCloudsType(minecraft.f_91066_.m_92174_());
                renderer.setGenerateClouds(true);
            }
            if (renderer.getGenerateClouds()) {
                renderer.setGenerateClouds(false);
                BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
                if (renderer.getCloudBuffer() != null) {
                    renderer.getCloudBuffer().close();
                }
                renderer.setCloudBuffer(new VertexBuffer(VertexBuffer.Usage.STATIC));
                BufferBuilder.RenderedBuffer renderedBuffer = renderer.invokeBuildClouds(bufferBuilder, i, j, k, colour);
                renderer.getCloudBuffer().m_85921_();
                renderer.getCloudBuffer().m_231221_(renderedBuffer);
                VertexBuffer.m_85931_();
            }
            RenderSystem.setShader(GameRenderer::m_172838_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)VENUS_CLOUD_TEXTURE);
            FogRenderer.m_109036_();
            poseStack.m_85836_();
            poseStack.m_85841_(12.0f, 1.0f, 12.0f);
            poseStack.m_252880_(-l, m, -n);
            if (renderer.getCloudBuffer() != null) {
                int r;
                renderer.getCloudBuffer().m_85921_();
                for (int s = r = renderer.getPrevCloudsType().equals((Object)CloudStatus.FANCY) ? 0 : 1; s < 2; ++s) {
                    if (s == 0) {
                        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                    } else {
                        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    }
                    ShaderInstance shaderProgram = RenderSystem.getShader();
                    renderer.getCloudBuffer().m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, shaderProgram);
                }
                VertexBuffer.m_85931_();
            }
            poseStack.m_85849_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
        }
    }
}

