/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.multiblock.matcher;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.modonomicon.api.multiblock.TriPredicate;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockMatcher
implements StateMatcher {
    public static final ResourceLocation TYPE = Modonomicon.loc("block");
    private final BlockState displayState;
    private final Block block;
    private final TriPredicate<BlockGetter, BlockPos, BlockState> predicate;

    protected BlockMatcher(BlockState displayState, Block block) {
        this.displayState = displayState;
        this.block = block;
        this.predicate = (blockGetter, blockPos, blockState) -> blockState.m_60734_() == block;
    }

    public static BlockMatcher from(Block block) {
        return new BlockMatcher(null, block);
    }

    public static BlockMatcher from(BlockState displayState, Block block) {
        return new BlockMatcher(displayState, block);
    }

    public static BlockMatcher fromJson(JsonObject json) {
        BlockState displayState = null;
        if (json.has("display")) {
            try {
                displayState = BlockStateParser.m_234691_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (StringReader)new StringReader(GsonHelper.m_13906_((JsonObject)json, (String)"display")), (boolean)false).f_234748_();
            }
            catch (CommandSyntaxException e) {
                throw new IllegalArgumentException("Failed to parse BlockState from json member \"display\" for BlockMatcher.", e);
            }
        }
        try {
            ResourceLocation blockRL = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)json, (String)"block"));
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(blockRL);
            return new BlockMatcher(displayState, block);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse Block from json member \"block\" for BlockMatcher", e);
        }
    }

    public static BlockMatcher fromNetwork(FriendlyByteBuf buffer) {
        try {
            BlockState displayState = null;
            if (buffer.readBoolean()) {
                displayState = BlockStateParser.m_234691_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (StringReader)new StringReader(buffer.m_130277_()), (boolean)false).f_234748_();
            }
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(buffer.m_130281_());
            return new BlockMatcher(displayState, block);
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Failed to parse BlockMatcher from network.", e);
        }
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public BlockState getDisplayedState(long ticks) {
        return this.displayState == null ? this.block.m_49966_() : this.displayState;
    }

    @Override
    public TriPredicate<BlockGetter, BlockPos, BlockState> getStatePredicate() {
        return this.predicate;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.displayState != null);
        if (this.displayState != null) {
            buffer.m_130070_(BlockStateParser.m_116769_((BlockState)this.displayState));
        }
        buffer.m_130085_(BuiltInRegistries.f_256975_.m_7981_((Object)this.block));
    }

    public int hashCode() {
        return Objects.hash(this.block, this.displayState);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockMatcher that = (BlockMatcher)o;
        return this.block.equals(that.block) && this.displayState.equals(that.displayState);
    }
}

