/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.datagen.book;

import com.klikli_dev.modonomicon.api.datagen.BookProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookEntryReadConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookEntryUnlockedConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookBlastingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookCampfireCookingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookCraftingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookEmptyPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookEntityPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookImagePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookMultiblockPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSmeltingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSmithingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSmokingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookStonecuttingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.modonomicon.book.BookCategoryBackgroundParallaxLayer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class FeaturesCategoryProvider
extends CategoryProvider {
    public FeaturesCategoryProvider(BookProvider parent) {
        super(parent, "features");
    }

    @Override
    protected String[] generateEntryMap() {
        return new String[]{"___           _____5____________", "__(multiblock)______________d___", "___           _______r__________", "__c           __________________", "___           _______2___3___i__", "__s           _____e____________", "___           __________________", "___           _____f____________"};
    }

    @Override
    protected void generateEntries() {
        BookEntryModel multiblockEntry = this.add(this.makeMultiblockEntry("multiblock"));
        List<BookEntryModel> conditionEntries = this.add(this.makeConditionEntries('r', '1', '2'));
        BookEntryModel recipeEntry = this.add(this.makeRecipeEntry('c'));
        BookEntryModel spotlightEntry = this.add(this.makeSpotlightEntry('s'));
        spotlightEntry.withParent(this.parent(recipeEntry));
        BookEntryModel emptyEntry = this.add(this.makeEmptyPageEntry('e'));
        emptyEntry.withParent(this.parent(spotlightEntry));
        BookEntryModel commandEntry = this.add(this.makeCommandEntry('f'));
        commandEntry.withParent(emptyEntry);
        commandEntry.withCommandToRunOnFirstRead(this.modLoc("test_command"));
        BookEntryModel entityEntry = this.add(this.makeEntityEntry('d'));
        BookEntryModel imageEntry = this.add(this.makeImageEntry('i'));
        imageEntry.withParent(this.parent(emptyEntry));
        BookEntryModel redirectEntry = this.add(this.makeRedirectEntry('5'));
    }

    @Override
    protected BookCategoryModel generateCategory() {
        return BookCategoryModel.create(this.modLoc(this.context().categoryId()), this.context().categoryName()).withIcon("minecraft:nether_star").withBackgroundParallaxLayers(new BookCategoryBackgroundParallaxLayer(this.modLoc("textures/gui/parallax/flow/base.png"), 0.7f, -1.0f), new BookCategoryBackgroundParallaxLayer(this.modLoc("textures/gui/parallax/flow/1.png"), 1.0f, -1.0f), new BookCategoryBackgroundParallaxLayer(this.modLoc("textures/gui/parallax/flow/2.png"), 1.4f, -1.0f));
    }

    private BookEntryModel makeMultiblockEntry(String location) {
        this.context().entry("multiblock");
        this.context().page("intro");
        BookTextPageModel multiBlockIntroPage = BookTextPageModel.builder().withText(this.context().pageText()).withTitle(this.context().pageTitle()).build();
        this.context().page("preview");
        BookMultiblockPageModel multiblockPreviewPage = BookMultiblockPageModel.builder().withMultiblockId(this.modLoc("blockentity")).withMultiblockName("multiblocks.modonomicon.blockentity").withText(this.context().pageText()).build();
        this.context().page("preview2");
        BookMultiblockPageModel multiblockPreviewPage2 = BookMultiblockPageModel.builder().withMultiblockId(this.modLoc("tag")).build();
        return this.entry(location).withIcon("minecraft:furnace").withLocation(this.entryMap().get(location)).withPages(multiBlockIntroPage, multiblockPreviewPage, multiblockPreviewPage2);
    }

    private List<BookEntryModel> makeConditionEntries(char rootLocation, char level1Location, char level2Location) {
        ArrayList<BookEntryModel> result = new ArrayList<BookEntryModel>();
        this.context().entry("condition_root");
        this.context().page("info");
        BookTextPageModel conditionRootEntryInfoPage = BookTextPageModel.builder().withText(this.context().pageText()).withTitle(this.context().pageTitle()).build();
        BookEntryModel conditionRootEntry = this.entry(rootLocation).withIcon("minecraft:redstone_torch").withEntryBackground(1, 0).withPages(conditionRootEntryInfoPage);
        result.add(conditionRootEntry);
        this.context().entry("condition_level_1");
        this.context().page("info");
        BookTextPageModel conditionLevel1EntryInfoPage = BookTextPageModel.builder().withText(this.context().pageText()).withTitle(this.context().pageTitle()).build();
        BookEntryReadConditionModel conditionLevel1EntryCondition = BookEntryReadConditionModel.builder().withEntry(conditionRootEntry.getId()).build();
        BookEntryModel conditionLevel1Entry = this.entry(level1Location).withIcon("minecraft:lever").withPages(conditionLevel1EntryInfoPage).withCondition(conditionLevel1EntryCondition).withParent(this.parent(conditionRootEntry));
        result.add(conditionLevel1Entry);
        this.context().entry("condition_level_2");
        this.context().page("info");
        BookTextPageModel conditionLevel2EntryInfoPage = BookTextPageModel.builder().withText(this.context().pageText()).withTitle(this.context().pageTitle()).build();
        BookEntryUnlockedConditionModel conditionLevel2EntryCondition = BookEntryUnlockedConditionModel.builder().withEntry(conditionLevel1Entry.getId()).build();
        BookEntryModel conditionLevel2Entry = this.entry(level2Location).withIcon("minecraft:torch").withPages(conditionLevel2EntryInfoPage).withCondition(conditionLevel2EntryCondition).withParent(this.parent(conditionLevel1Entry));
        result.add(conditionLevel2Entry);
        return result;
    }

    private BookEntryModel makeRecipeEntry(char location) {
        this.context().entry("recipe");
        this.context().page("intro");
        BookTextPageModel introPage = BookTextPageModel.builder().withText(this.context().pageText()).withTitle(this.context().pageTitle()).build();
        this.context().page("crafting");
        BookCraftingRecipePageModel crafting = ((BookCraftingRecipePageModel.Builder)((BookCraftingRecipePageModel.Builder)((BookCraftingRecipePageModel.Builder)((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1("minecraft:crafting_table")).withRecipeId2("minecraft:oak_planks")).withText(this.context().pageText())).withTitle2("test.test.test")).build();
        this.context().page("smelting");
        BookSmeltingRecipePageModel smelting = ((BookSmeltingRecipePageModel.Builder)((BookSmeltingRecipePageModel.Builder)BookSmeltingRecipePageModel.builder().withRecipeId1("minecraft:charcoal")).withRecipeId2("minecraft:cooked_beef")).build();
        this.context().page("smoking");
        BookSmokingRecipePageModel smoking = ((BookSmokingRecipePageModel.Builder)((BookSmokingRecipePageModel.Builder)BookSmokingRecipePageModel.builder().withRecipeId1("minecraft:cooked_beef_from_smoking")).withText(this.context().pageText())).build();
        this.context().page("blasting");
        BookBlastingRecipePageModel blasting = ((BookBlastingRecipePageModel.Builder)BookBlastingRecipePageModel.builder().withRecipeId2("minecraft:iron_ingot_from_blasting_iron_ore")).build();
        this.context().page("campfire_cooking");
        BookCampfireCookingRecipePageModel campfireCooking = ((BookCampfireCookingRecipePageModel.Builder)BookCampfireCookingRecipePageModel.builder().withRecipeId1("minecraft:cooked_beef_from_campfire_cooking")).build();
        this.context().page("stonecutting");
        BookStonecuttingRecipePageModel stonecutting = ((BookStonecuttingRecipePageModel.Builder)BookStonecuttingRecipePageModel.builder().withRecipeId1("minecraft:andesite_slab_from_andesite_stonecutting")).build();
        this.context().page("smithing");
        BookSmithingRecipePageModel smithing = ((BookSmithingRecipePageModel.Builder)((BookSmithingRecipePageModel.Builder)((BookSmithingRecipePageModel.Builder)BookSmithingRecipePageModel.builder().withRecipeId1("minecraft:netherite_axe_smithing")).withTitle1(this.context().pageTitle())).withRecipeId2("minecraft:netherite_chestplate_smithing")).build();
        this.add(this.context().pageTitle(), "1.20+ Smithing Recipe");
        this.context().page("missing");
        BookSmithingRecipePageModel missing = ((BookSmithingRecipePageModel.Builder)BookSmithingRecipePageModel.builder().withRecipeId1("minecraft:netherite_axe_smithing_does_not_exist")).build();
        return this.entry(location).withIcon("minecraft:crafting_table").withLocation(this.entryMap().get(Character.valueOf(location))).withPages(introPage, crafting, smelting, smoking, blasting, campfireCooking, stonecutting, smithing, missing);
    }

    private BookEntryModel makeSpotlightEntry(char location) {
        this.context().entry("spotlight");
        this.context().page("intro");
        BookTextPageModel introPage = BookTextPageModel.builder().withText(this.context().pageText()).withTitle(this.context().pageTitle()).build();
        this.context().page("spotlight1");
        BookSpotlightPageModel spotlight1 = BookSpotlightPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42410_})).build();
        this.context().page("spotlight2");
        BookSpotlightPageModel spotlight2 = BookSpotlightPageModel.builder().withText(this.context().pageText()).withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})).build();
        return this.entry(location).withIcon("minecraft:beacon").withLocation(this.entryMap().get(Character.valueOf(location))).withPages(introPage, spotlight1, spotlight2);
    }

    private BookEntryModel makeEmptyPageEntry(char location) {
        this.context().entry("empty");
        this.context().page("intro");
        BookTextPageModel introPage = BookTextPageModel.builder().withText(this.context().pageText()).withTitle(this.context().pageTitle()).build();
        this.context().page("empty");
        BookEmptyPageModel empty = BookEmptyPageModel.builder().build();
        this.context().page("empty2");
        BookEmptyPageModel empty2 = BookEmptyPageModel.builder().build();
        return this.entry(location).withIcon("minecraft:obsidian").withLocation(this.entryMap().get(Character.valueOf(location))).withPages(introPage, empty, empty2);
    }

    private BookEntryModel makeCommandEntry(char location) {
        this.context().entry("command");
        this.add(this.context().entryName(), "Entry Read Commands");
        this.add(this.context().entryDescription(), "This entry runs a command when you first read it.");
        this.context().page("intro");
        BookTextPageModel introPage = BookTextPageModel.builder().withText(this.context().pageText()).withTitle(this.context().pageTitle()).build();
        this.add(this.context().pageTitle(), "Entry Read Commands");
        this.add(this.context().pageText(), "This entry just ran a command when you first read it. Look into your chat!");
        this.context().page("command_link");
        BookTextPageModel commandLink = BookTextPageModel.builder().withText(this.context().pageText()).withTitle(this.context().pageTitle()).build();
        this.add(this.context().pageTitle(), "Command Link");
        this.add(this.context().pageText(), "{0}", this.commandLink("Click me to run the command!", "test_command2"));
        return this.entry(location).withIcon("minecraft:oak_sign").withLocation(this.entryMap().get(Character.valueOf(location))).withPages(introPage, commandLink);
    }

    private BookEntryModel makeEntityEntry(char location) {
        this.context().entry("entity");
        this.context().page("intro");
        BookTextPageModel introPage = BookTextPageModel.builder().withText(this.context().pageText()).withTitle(this.context().pageTitle()).build();
        this.context().page("entity1");
        BookEntityPageModel entity1 = BookEntityPageModel.builder().withEntityName(this.context().pageTitle()).withEntityId("minecraft:ender_dragon").withScale(0.5f).build();
        this.context().page("entity2");
        BookEntityPageModel entity2 = BookEntityPageModel.builder().withText(this.context().pageText()).withEntityId("minecraft:spider").withScale(1.0f).build();
        return this.entry(location).withIcon("minecraft:spider_eye").withLocation(this.entryMap().get(Character.valueOf(location))).withPages(introPage, entity1, entity2);
    }

    private BookEntryModel makeImageEntry(char location) {
        this.context().entry("image");
        this.context().page("intro");
        BookTextPageModel introPage = BookTextPageModel.builder().withText(this.context().pageText()).withTitle(this.context().pageTitle()).build();
        this.context().page("image");
        BookImagePageModel imagePage = BookImagePageModel.builder().withText(this.context().pageText()).withTitle(this.context().pageTitle()).withImages(new ResourceLocation("modonomicon:textures/gui/default_background.png"), new ResourceLocation("modonomicon:textures/gui/dark_slate_seamless.png")).build();
        this.context().page("test_spotlight");
        BookSpotlightPageModel testSpotlight = BookSpotlightPageModel.builder().withText(this.context().pageText()).withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50085_})).build();
        this.context().page("test_image");
        BookImagePageModel testImage = BookImagePageModel.builder().withText(this.context().pageText()).withTitle(this.context().pageTitle()).withImages(new ResourceLocation("modonomicon:textures/gui/default_background.png"), new ResourceLocation("modonomicon:textures/gui/dark_slate_seamless.png")).build();
        return this.entry(location).withIcon("minecraft:item_frame").withLocation(this.entryMap().get(Character.valueOf(location))).withPages(introPage, imagePage, testSpotlight, testImage);
    }

    private BookEntryModel makeRedirectEntry(char location) {
        this.context().entry("redirect");
        return this.entry(location).withIcon("minecraft:ender_pearl").withLocation(this.entryMap().get(Character.valueOf(location))).withCategoryToOpen(new ResourceLocation("modonomicon:hidden"));
    }
}

