/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.datagen.book;

import com.klikli_dev.modonomicon.api.datagen.BookContextHelper;
import com.klikli_dev.modonomicon.api.datagen.BookProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryEntryMap;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookCommandModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookEntryReadConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookFalseConditionModel;
import com.klikli_dev.modonomicon.datagen.book.FeaturesCategoryProvider;
import com.klikli_dev.modonomicon.datagen.book.FormattingCategoryProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.LanguageProvider;

public class DemoBookProvider
extends BookProvider {
    public DemoBookProvider(PackOutput packOutput, String modid, LanguageProvider lang, LanguageProvider ... translations) {
        super("demo", packOutput, modid, lang, translations);
    }

    @Override
    protected BookModel generateBook() {
        this.lang().add(this.context().bookName(), "Demo Book");
        this.lang().add(this.context().bookTooltip(), "A book to showcase & test Modonomicon features.");
        this.lang("ru_ru").add(this.context().bookName(), "\u0414\u0435\u043c\u043e\u043d\u0441\u0442\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u0430\u044f \u043a\u043d\u0438\u0433\u0430");
        this.lang("ru_ru").add(this.context().bookTooltip(), "\u041a\u043d\u0438\u0433\u0430 \u0434\u043b\u044f \u0434\u0435\u043c\u043e\u043d\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0438 \u0442\u0435\u0441\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0444\u0443\u043d\u043a\u0446\u0438\u0439 \"\u041c\u043e\u0434\u043e\u043d\u043e\u043c\u0438\u043a\u043e\u043d\u0430\".");
        BookCategoryModel featuresCategory = new FeaturesCategoryProvider(this).generate();
        BookCategoryModel formattingCategory = new FormattingCategoryProvider(this).generate();
        BookCategoryModel hiddenCategory = this.makeHiddenCategory(this.context());
        BookCategoryModel conditionalCategory = this.makeConditionalCategory(this.context());
        conditionalCategory.withCondition(BookEntryReadConditionModel.builder().withEntry(this.modLoc("features/condition_root")).build());
        BookCommandModel commandEntryCommand = BookCommandModel.create(this.modLoc("test_command"), "/give @s minecraft:apple 1").withPermissionLevel(2).withSuccessMessage("modonomicon.command.test_command.success");
        this.lang.add(commandEntryCommand.getSuccessMessage(), "You got an apple, because reading is cool!");
        BookCommandModel commandEntryLinkCommand = BookCommandModel.create(this.modLoc("test_command2"), "/give @s minecraft:wheat 1").withPermissionLevel(2).withSuccessMessage("modonomicon.command.test_command2.success");
        this.lang.add(commandEntryLinkCommand.getSuccessMessage(), "You got wheat, because clicking is cool!");
        BookModel demoBook = BookModel.create(this.modLoc("demo"), this.context().bookName()).withTooltip(this.context().bookTooltip()).withModel(new ResourceLocation("modonomicon:modonomicon_green")).withBookTextOffsetX(5).withBookTextOffsetY(0).withBookTextOffsetWidth(-5).withCategory(featuresCategory).withCategory(formattingCategory).withCategory(hiddenCategory).withCategory(conditionalCategory).withCommand(commandEntryCommand).withCommand(commandEntryLinkCommand);
        return demoBook;
    }

    @Override
    protected void registerDefaultMacros() {
    }

    private BookCategoryModel makeHiddenCategory(BookContextHelper helper) {
        this.context().category("hidden");
        CategoryEntryMap entryHelper = new CategoryEntryMap();
        entryHelper.setMap("_____________________", "_____________________", "__________l__________", "_____________________", "_____________________");
        this.context().entry("always_locked");
        BookEntryModel entry = BookEntryModel.create(this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), this.context().entryName()).withDescription(this.context().entryDescription()).withIcon("minecraft:nether_star").withLocation(entryHelper.get(Character.valueOf('l'))).withEntryBackground(0, 1).withCondition(BookFalseConditionModel.builder().build());
        return BookCategoryModel.create(this.modLoc(this.context().categoryId()), this.context().categoryName()).withIcon("minecraft:book").withShowCategoryButton(false).withEntry(entry);
    }

    private BookCategoryModel makeConditionalCategory(BookContextHelper helper) {
        this.context().category("conditional");
        CategoryEntryMap entryHelper = new CategoryEntryMap();
        entryHelper.setMap("_____________________", "_____________________", "__________l__________", "_____________________", "_____________________");
        this.context().entry("always_locked");
        BookEntryModel entry = BookEntryModel.create(this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), this.context().entryName()).withDescription(this.context().entryDescription()).withIcon("minecraft:nether_star").withLocation(entryHelper.get(Character.valueOf('l'))).withEntryBackground(0, 1).withCondition(BookFalseConditionModel.builder().build());
        return BookCategoryModel.create(this.modLoc(this.context().categoryId()), this.context().categoryName()).withIcon("minecraft:chest").withEntry(entry);
    }
}

