/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.multiblock.AbstractMultiblock;
import com.klikli_dev.modonomicon.multiblock.matcher.DisplayOnlyMatcher;
import com.klikli_dev.modonomicon.multiblock.matcher.Matchers;
import com.klikli_dev.modonomicon.util.GuiGraphicsExt;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.joml.Matrix4f;

public class MultiblockPreviewRenderer {
    public static boolean hasMultiblock;
    private static Map<BlockPos, BlockEntity> blockEntityCache;
    private static Set<BlockEntity> erroredBlockEntities;
    private static Multiblock multiblock;
    private static Component name;
    private static BlockPos pos;
    private static boolean isAnchored;
    private static Rotation facingRotation;
    private static Function<BlockPos, BlockPos> offsetApplier;
    private static int blocks;
    private static int blocksDone;
    private static int airFilled;
    private static int timeComplete;
    private static BlockState lookingState;
    private static BlockPos lookingPos;
    private static MultiBufferSource.BufferSource buffers;

    public static void setMultiblock(Multiblock multiblock, Component name, boolean flip) {
        MultiblockPreviewRenderer.setMultiblock(multiblock, name, flip, pos -> pos);
    }

    public static void setMultiblock(Multiblock multiblock, Component name, boolean flip, Function<BlockPos, BlockPos> offsetApplier) {
        if (flip && hasMultiblock) {
            hasMultiblock = false;
        } else {
            MultiblockPreviewRenderer.multiblock = multiblock;
            blockEntityCache = new HashMap<BlockPos, BlockEntity>();
            erroredBlockEntities = Collections.newSetFromMap(new WeakHashMap());
            MultiblockPreviewRenderer.name = name;
            MultiblockPreviewRenderer.offsetApplier = offsetApplier;
            pos = null;
            hasMultiblock = multiblock != null;
            isAnchored = false;
        }
    }

    public static void onRenderHUD(GuiGraphics guiGraphics, float partialTicks) {
        if (hasMultiblock) {
            int fullAnimTime;
            int waitTime = 40;
            int fadeOutSpeed = 4;
            float animTime = (float)timeComplete + (timeComplete == 0 ? 0.0f : partialTicks);
            if (animTime > (float)(fullAnimTime = waitTime + 10)) {
                hasMultiblock = false;
                return;
            }
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, -Math.max(0.0f, animTime - (float)waitTime) * (float)fadeOutSpeed, 0.0f);
            Minecraft mc = Minecraft.m_91087_();
            int x = mc.m_91268_().m_85445_() / 2;
            int y = 12;
            GuiGraphicsExt.drawString(guiGraphics, mc.f_91062_, name, (float)x - (float)mc.f_91062_.m_92852_((FormattedText)name) / 2.0f, (float)y, 0xFFFFFF, false);
            int width = 180;
            int height = 9;
            int left = x - width / 2;
            int top = y + 10;
            if (timeComplete > 0) {
                String s = I18n.m_118938_((String)"modonomicon.multiblock.complete", (Object[])new Object[0]);
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_(0.0f, Math.min((float)(height + 5), animTime), 0.0f);
                guiGraphics.m_280056_(mc.f_91062_, s, (int)((float)x - (float)mc.f_91062_.m_92895_(s) / 2.0f), top + height - 10, 65280, false);
                guiGraphics.m_280168_().m_85849_();
            }
            guiGraphics.m_280509_(left - 1, top - 1, left + width + 1, top + height + 1, -16777216);
            MultiblockPreviewRenderer.drawGradientRect(guiGraphics, left, top, left + width, top + height, -10066330, -11184811);
            float fract = (float)blocksDone / (float)Math.max(1, blocks);
            int progressWidth = (int)((float)width * fract);
            int color = Mth.m_14169_((float)(fract / 3.0f), (float)1.0f, (float)1.0f) | 0xFF000000;
            int color2 = new Color(color).darker().getRGB();
            MultiblockPreviewRenderer.drawGradientRect(guiGraphics, left, top, left + progressWidth, top + height, color, color2);
            if (!isAnchored) {
                String s = I18n.m_118938_((String)"modonomicon.multiblock.not_anchored", (Object[])new Object[0]);
                guiGraphics.m_280056_(mc.f_91062_, s, (int)((float)x - (float)mc.f_91062_.m_92895_(s) / 2.0f), top + height + 8, 0xFFFFFF, false);
            } else {
                if (lookingState != null) {
                    try {
                        Block block = lookingState.m_60734_();
                        ItemStack stack = block.m_7397_((BlockGetter)mc.f_91073_, lookingPos, lookingState);
                        if (!stack.m_41619_()) {
                            guiGraphics.m_280614_(mc.f_91062_, stack.m_41786_(), left + 20, top + height + 8, 0xFFFFFF, false);
                            guiGraphics.m_280480_(stack, left, top + height + 2);
                        }
                    }
                    catch (Exception block) {
                        // empty catch block
                    }
                }
                if (timeComplete == 0) {
                    color = 0xFFFFFF;
                    int posx = left + width;
                    int posy = top + height + 2;
                    float mult = 1.0f;
                    Object progress = blocksDone + "/" + blocks;
                    if (blocksDone == blocks && airFilled > 0) {
                        progress = I18n.m_118938_((String)"modonomicon.multiblock.remove_blocks", (Object[])new Object[0]);
                        color = 14306879;
                        mult *= 2.0f;
                        posx -= width / 2;
                        posy += 2;
                    }
                    guiGraphics.m_280056_(mc.f_91062_, (String)progress, (int)((float)posx - (float)mc.f_91062_.m_92895_((String)progress) / mult), posy, color, true);
                }
            }
            guiGraphics.m_280168_().m_85849_();
        }
    }

    public static void onRenderLevelLastEvent(PoseStack poseStack) {
        if (hasMultiblock && multiblock != null) {
            MultiblockPreviewRenderer.renderMultiblock((Level)Minecraft.m_91087_().f_91073_, poseStack);
        }
    }

    public static void anchorTo(BlockPos target, Rotation rot) {
        pos = target;
        facingRotation = rot;
        isAnchored = true;
    }

    public static InteractionResult onPlayerInteract(Player player, Level world, InteractionHand hand, BlockHitResult hit) {
        if (hasMultiblock && !isAnchored && player == Minecraft.m_91087_().f_91074_) {
            MultiblockPreviewRenderer.anchorTo(hit.m_82425_(), MultiblockPreviewRenderer.getRotation((Entity)player));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static void onClientTick(Minecraft mc) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            hasMultiblock = false;
        } else if (isAnchored && blocks == blocksDone && airFilled == 0) {
            if (++timeComplete == 14) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11871_, (float)1.0f));
            }
        } else {
            timeComplete = 0;
        }
    }

    public static void renderMultiblock(Level world, PoseStack ms) {
        Minecraft mc = Minecraft.m_91087_();
        if (!isAnchored) {
            facingRotation = MultiblockPreviewRenderer.getRotation((Entity)mc.f_91074_);
            if (mc.f_91077_ instanceof BlockHitResult) {
                pos = ((BlockHitResult)mc.f_91077_).m_82425_();
            }
        } else if (pos.m_203193_((Position)mc.f_91074_.m_20182_()) > 4096.0) {
            return;
        }
        if (pos == null) {
            return;
        }
        if (multiblock.isSymmetrical()) {
            facingRotation = Rotation.NONE;
        }
        EntityRenderDispatcher erd = mc.m_91290_();
        double renderPosX = erd.f_114358_.m_90583_().m_7096_();
        double renderPosY = erd.f_114358_.m_90583_().m_7098_();
        double renderPosZ = erd.f_114358_.m_90583_().m_7094_();
        ms.m_85836_();
        ms.m_85837_(-renderPosX, -renderPosY, -renderPosZ);
        if (buffers == null) {
            buffers = MultiblockPreviewRenderer.initBuffers(mc.m_91269_().m_110104_());
        }
        BlockPos checkPos = null;
        HitResult hitResult = mc.f_91077_;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockRes = (BlockHitResult)hitResult;
            checkPos = blockRes.m_82425_().m_121945_(blockRes.m_82434_());
        }
        airFilled = 0;
        blocksDone = 0;
        blocks = 0;
        lookingState = null;
        lookingPos = checkPos;
        Pair<BlockPos, Collection<Multiblock.SimulateResult>> sim = multiblock.simulate(world, MultiblockPreviewRenderer.getStartPos(), MultiblockPreviewRenderer.getFacingRotation(), true, false);
        for (Multiblock.SimulateResult r : (Collection)sim.getSecond()) {
            float alpha = 0.3f;
            if (r.getWorldPosition().equals((Object)checkPos)) {
                lookingState = r.getStateMatcher().getDisplayedState(ClientTicks.ticks);
                alpha = 0.6f + (float)(Math.sin(ClientTicks.total * 0.3f) + 1.0) * 0.1f;
            }
            if (r.getStateMatcher().equals(Matchers.ANY) || r.getStateMatcher().getType() == DisplayOnlyMatcher.TYPE) continue;
            boolean air = r.getStateMatcher().equals(Matchers.AIR);
            if (!air) {
                ++blocks;
            }
            if (!r.test(world, facingRotation)) {
                BlockState renderState = r.getStateMatcher().getDisplayedState(ClientTicks.ticks).m_60717_(facingRotation);
                MultiblockPreviewRenderer.renderBlock(world, renderState, r.getWorldPosition(), alpha, ms);
                Block block = renderState.m_60734_();
                if (block instanceof EntityBlock) {
                    EntityBlock eb = (EntityBlock)block;
                    BlockEntity be = blockEntityCache.computeIfAbsent(r.getWorldPosition().m_7949_(), p -> eb.m_142194_(p, renderState));
                    if (be != null && !erroredBlockEntities.contains(be)) {
                        be.m_142339_((Level)mc.f_91073_);
                        be.m_155250_(renderState);
                        ms.m_85836_();
                        BlockPos bePos = r.getWorldPosition();
                        ms.m_252880_((float)bePos.m_123341_(), (float)bePos.m_123342_(), (float)bePos.m_123343_());
                        try {
                            BlockEntityRenderer renderer = Minecraft.m_91087_().m_167982_().m_112265_(be);
                            if (renderer != null) {
                                renderer.m_6922_(be, ClientTicks.partialTicks, ms, (MultiBufferSource)buffers, 0xF000F0, OverlayTexture.f_118083_);
                            }
                        }
                        catch (Exception e) {
                            erroredBlockEntities.add(be);
                            Modonomicon.LOG.error("Error rendering block entity", (Throwable)e);
                        }
                        ms.m_85849_();
                    }
                }
                if (!air) continue;
                ++airFilled;
                continue;
            }
            if (air) continue;
            ++blocksDone;
        }
        buffers.m_109911_();
        ms.m_85849_();
        if (!isAnchored) {
            blocksDone = 0;
            blocks = 0;
        }
    }

    public static void renderBlock(Level world, BlockState state, BlockPos pos, float alpha, PoseStack ms) {
        if (pos != null) {
            ms.m_85836_();
            ms.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            if (state.m_60734_() == Blocks.f_50016_) {
                float scale = 0.3f;
                float off = (1.0f - scale) / 2.0f;
                ms.m_252880_(off, off, off);
                ms.m_85841_(scale, scale, scale);
                state = Blocks.f_50504_.m_49966_();
            }
            Minecraft.m_91087_().m_91289_().m_110912_(state, ms, (MultiBufferSource)buffers, 0xF000F0, OverlayTexture.f_118083_);
            ms.m_85849_();
        }
    }

    public static Multiblock getMultiblock() {
        return multiblock;
    }

    public static boolean isAnchored() {
        return isAnchored;
    }

    public static Rotation getFacingRotation() {
        return multiblock.isSymmetrical() ? Rotation.NONE : facingRotation;
    }

    public static BlockPos getStartPos() {
        return offsetApplier.apply(pos);
    }

    private static void drawGradientRect(GuiGraphics guiGraphics, int left, int top, int right, int bottom, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f mat = guiGraphics.m_280168_().m_85850_().m_252922_();
        bufferbuilder.m_252986_(mat, (float)right, (float)top, 0.0f).m_85950_(f1, f2, f3, f).m_5752_();
        bufferbuilder.m_252986_(mat, (float)left, (float)top, 0.0f).m_85950_(f1, f2, f3, f).m_5752_();
        bufferbuilder.m_252986_(mat, (float)left, (float)bottom, 0.0f).m_85950_(f5, f6, f7, f4).m_5752_();
        bufferbuilder.m_252986_(mat, (float)right, (float)bottom, 0.0f).m_85950_(f5, f6, f7, f4).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    private static Rotation getRotation(Entity entity) {
        return AbstractMultiblock.rotationFromFacing(entity.m_6350_());
    }

    private static MultiBufferSource.BufferSource initBuffers(MultiBufferSource.BufferSource original) {
        BufferBuilder fallback = original.f_109904_;
        Map layerBuffers = original.f_109905_;
        Object2ObjectLinkedOpenHashMap remapped = new Object2ObjectLinkedOpenHashMap();
        for (Map.Entry e : layerBuffers.entrySet()) {
            remapped.put(GhostRenderLayer.remap((RenderType)e.getKey()), (BufferBuilder)e.getValue());
        }
        return new GhostBuffers(fallback, (Map<RenderType, BufferBuilder>)remapped);
    }

    static {
        blockEntityCache = new HashMap<BlockPos, BlockEntity>();
        erroredBlockEntities = Collections.newSetFromMap(new WeakHashMap());
        buffers = null;
    }

    private static class GhostRenderLayer
    extends RenderType {
        private static final Map<RenderType, RenderType> remappedTypes = new IdentityHashMap<RenderType, RenderType>();

        private GhostRenderLayer(RenderType original) {
            super(String.format("%s_%s_ghost", original.toString(), "modonomicon"), original.m_110508_(), original.m_173186_(), original.m_110507_(), original.m_110405_(), true, () -> {
                original.m_110185_();
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            }, () -> {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                RenderSystem.enableDepthTest();
                original.m_110188_();
            });
        }

        public static RenderType remap(RenderType in) {
            if (in instanceof GhostRenderLayer) {
                return in;
            }
            return remappedTypes.computeIfAbsent(in, GhostRenderLayer::new);
        }
    }

    private static class GhostBuffers
    extends MultiBufferSource.BufferSource {
        protected GhostBuffers(BufferBuilder fallback, Map<RenderType, BufferBuilder> layerBuffers) {
            super(fallback, layerBuffers);
        }

        public VertexConsumer m_6299_(RenderType type) {
            return super.m_6299_(GhostRenderLayer.remap(type));
        }
    }
}

