/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.markdown;

import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ComponentNodeRendererContext;
import com.klikli_dev.modonomicon.client.gui.book.markdown.LinkRenderer;
import com.klikli_dev.modonomicon.util.ItemStackUtil;
import java.util.function.Consumer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.ItemStack;
import org.commonmark.node.Link;
import org.commonmark.node.Node;
import org.commonmark.node.Text;

public class ItemLinkRenderer
implements LinkRenderer {
    public static final String PROTOCOL_ITEM = "item://";
    public static final int PROTOCOL_ITEM_LENGTH = "item://".length();
    public static final TextColor ITEM_LINK_COLOR = TextColor.m_131266_((int)261264);

    public static boolean isItemLink(String linkText) {
        return linkText.toLowerCase().startsWith(PROTOCOL_ITEM);
    }

    @Override
    public boolean visit(Link link, Consumer<Node> visitChildren, ComponentNodeRendererContext context) {
        if (link.getDestination().startsWith(PROTOCOL_ITEM)) {
            BookErrorManager.get().setContext("Item Link: {}, \n{}", link.getDestination(), BookErrorManager.get().getContextHelper());
            TextColor currentColor = context.getCurrentStyle().m_131135_();
            String itemId = link.getDestination().substring(PROTOCOL_ITEM_LENGTH);
            ItemStack itemStack = ItemStackUtil.loadFromParsed(ItemStackUtil.parseItemStackString(itemId));
            context.setCurrentStyle(context.getCurrentStyle().m_131148_(currentColor == null ? ITEM_LINK_COLOR : currentColor).m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(itemStack))).m_131142_(new ClickEvent(ClickEvent.Action.CHANGE_PAGE, link.getDestination())));
            if (link.getLastChild() == null) {
                link.appendChild((Node)new Text(Component.m_237115_((String)itemStack.m_41720_().m_5524_()).getString()));
            }
            visitChildren.accept((Node)link);
            context.setCurrentStyle(context.getCurrentStyle().m_131148_(currentColor).m_131144_(null));
            BookErrorManager.get().setContext(null, new Object[0]);
            return true;
        }
        return false;
    }
}

