/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.button;

import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.gui.book.BookContentScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookSearchScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class EntryListButton
extends Button {
    private static final int ANIM_TIME = 5;
    private final BookSearchScreen parent;
    private final BookEntry entry;
    private float timeHovered;

    public EntryListButton(BookSearchScreen parent, BookEntry entry, int pX, int pY, Button.OnPress pOnPress) {
        super(pX, pY, 124, 10, (Component)Component.m_237115_((String)entry.getName()), pOnPress, Button.f_252438_);
        this.parent = parent;
        this.entry = entry;
    }

    public BookEntry getEntry() {
        return this.entry;
    }

    private int getEntryColor() {
        return 0;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93623_) {
            this.timeHovered = this.m_274382_() ? Math.min(5.0f, this.timeHovered + ClientTicks.delta) : Math.max(0.0f, this.timeHovered - ClientTicks.delta);
            float time = Math.max(0.0f, Math.min(5.0f, this.timeHovered + (this.m_274382_() ? partialTicks : -partialTicks)));
            float widthFract = time / 5.0f;
            boolean locked = !BookUnlockStateManager.get().isUnlockedFor((Player)Minecraft.m_91087_().f_91074_, this.entry);
            guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
            guiGraphics.m_280509_(this.m_252754_() * 2, this.m_252907_() * 2, (this.m_252754_() + (int)((float)this.f_93618_ * widthFract)) * 2, (this.m_252907_() + this.f_93619_) * 2, 0x22000000);
            RenderSystem.enableBlend();
            if (locked) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
                BookContentScreen.drawLock(guiGraphics, this.parent.getParentScreen().getBook(), this.m_252754_() * 2 + 2, this.m_252907_() * 2 + 2);
            } else {
                this.entry.getIcon().render(guiGraphics, this.m_252754_() * 2 + 2, this.m_252907_() * 2 + 2);
            }
            guiGraphics.m_280168_().m_85841_(2.0f, 2.0f, 2.0f);
            MutableComponent name = locked ? Component.m_237115_((String)"modonomicon.gui.search.entry.locked") : Component.m_237115_((String)this.entry.getName());
            guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)name, this.m_252754_() + 12, this.m_252907_(), this.getEntryColor(), false);
        }
    }

    public void m_7435_(SoundManager soundHandlerIn) {
        if (this.entry != null) {
            // empty if block
        }
    }
}

