/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.bookstate;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookEntryUnlockedCondition;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionCategoryContext;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionEntryContext;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.util.Codecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class BookUnlockStates {
    public static final Codec<BookUnlockStates> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.concurrentMap(ResourceLocation.f_135803_, Codecs.set(ResourceLocation.f_135803_)).fieldOf("readEntries").forGetter(s -> s.readEntries), (App)Codecs.concurrentMap(ResourceLocation.f_135803_, Codecs.set(ResourceLocation.f_135803_)).fieldOf("unlockedEntries").forGetter(s -> s.unlockedEntries), (App)Codecs.concurrentMap(ResourceLocation.f_135803_, Codecs.set(ResourceLocation.f_135803_)).fieldOf("unlockedCategories").forGetter(s -> s.unlockedCategories), (App)Codecs.concurrentMap(ResourceLocation.f_135803_, Codecs.mutableMap(ResourceLocation.f_135803_, Codec.INT)).fieldOf("usedCommands").forGetter(s -> s.usedCommands)).apply((Applicative)instance, BookUnlockStates::new));
    public ConcurrentMap<ResourceLocation, Set<ResourceLocation>> readEntries;
    public ConcurrentMap<ResourceLocation, Set<ResourceLocation>> unlockedEntries;
    public ConcurrentMap<ResourceLocation, Set<ResourceLocation>> unlockedCategories;
    public ConcurrentMap<ResourceLocation, Map<ResourceLocation, Integer>> usedCommands;

    public BookUnlockStates() {
        this(new ConcurrentHashMap<ResourceLocation, Set<ResourceLocation>>(), new ConcurrentHashMap<ResourceLocation, Set<ResourceLocation>>(), new ConcurrentHashMap<ResourceLocation, Set<ResourceLocation>>(), new ConcurrentHashMap<ResourceLocation, Map<ResourceLocation, Integer>>());
    }

    public BookUnlockStates(ConcurrentMap<ResourceLocation, Set<ResourceLocation>> readEntries, ConcurrentMap<ResourceLocation, Set<ResourceLocation>> unlockedEntries, ConcurrentMap<ResourceLocation, Set<ResourceLocation>> unlockedCategories, ConcurrentMap<ResourceLocation, Map<ResourceLocation, Integer>> usedCommands) {
        this.readEntries = readEntries;
        this.unlockedEntries = unlockedEntries;
        this.unlockedCategories = unlockedCategories;
        this.usedCommands = usedCommands;
    }

    public void update(ServerPlayer owner) {
        BookConditionContext categoryContext;
        ArrayList<Map.Entry<BookEntryUnlockedCondition, BookConditionContext>> unlockedConditions = new ArrayList<Map.Entry<BookEntryUnlockedCondition, BookConditionContext>>();
        for (Book book : BookDataManager.get().getBooks().values()) {
            BookErrorManager.get().reset();
            BookErrorManager.get().setCurrentBookId(book.getId());
            for (BookCategory category : book.getCategories().values()) {
                BookErrorManager.get().setContext("Category to perform condition test on: {}", category.getId().toString());
                try {
                    categoryContext = BookConditionContext.of(book, category);
                    if (category.getCondition().test(categoryContext, (Player)owner)) {
                        this.unlockedCategories.computeIfAbsent(book.getId(), k -> new HashSet()).add(category.getId());
                    } else {
                        BookCondition bookCondition = category.getCondition();
                        if (bookCondition instanceof BookEntryUnlockedCondition) {
                            BookEntryUnlockedCondition bookEntryUnlockedCondition = (BookEntryUnlockedCondition)bookCondition;
                            unlockedConditions.add(Map.entry(bookEntryUnlockedCondition, categoryContext));
                        }
                    }
                }
                catch (Exception e) {
                    BookErrorManager.get().error("Error while testing category condition", e);
                }
                for (BookEntry entry : category.getEntries().values()) {
                    BookErrorManager.get().setContext("Entry to perform condition test on: {}", entry.getId().toString());
                    try {
                        BookConditionContext entryContext = BookConditionContext.of(book, entry);
                        if (entry.getCondition().test(entryContext, (Player)owner)) {
                            this.unlockedEntries.computeIfAbsent(book.getId(), k -> new HashSet()).add(entry.getId());
                            continue;
                        }
                        BookCondition bookCondition = entry.getCondition();
                        if (!(bookCondition instanceof BookEntryUnlockedCondition)) continue;
                        BookEntryUnlockedCondition bookEntryUnlockedCondition = (BookEntryUnlockedCondition)bookCondition;
                        unlockedConditions.add(Map.entry(bookEntryUnlockedCondition, entryContext));
                    }
                    catch (Exception e) {
                        BookErrorManager.get().error("Error while testing entry condition", e);
                    }
                }
            }
        }
        BookErrorManager.get().reset();
        boolean unlockedAny = false;
        do {
            unlockedAny = false;
            Iterator iter = unlockedConditions.iterator();
            while (iter.hasNext()) {
                Map.Entry condition = (Map.Entry)iter.next();
                BookErrorManager.get().setCurrentBookId(((BookConditionContext)condition.getValue()).getBook().getId());
                BookErrorManager.get().setContext("Context to perform unlockedConditions test on: {}", ((BookConditionContext)condition.getValue()).toString());
                if (!((BookEntryUnlockedCondition)condition.getKey()).test((BookConditionContext)condition.getValue(), (Player)owner)) continue;
                try {
                    Object v = condition.getValue();
                    if (v instanceof BookConditionEntryContext) {
                        BookConditionEntryContext entryContext = (BookConditionEntryContext)v;
                        this.unlockedEntries.computeIfAbsent(entryContext.getBook().getId(), k -> new HashSet()).add(entryContext.getEntry().getId());
                    } else {
                        v = condition.getValue();
                        if (v instanceof BookConditionCategoryContext) {
                            categoryContext = (BookConditionCategoryContext)v;
                            this.unlockedCategories.computeIfAbsent(categoryContext.getBook().getId(), k -> new HashSet()).add(((BookConditionCategoryContext)categoryContext).getCategory().getId());
                        }
                    }
                    unlockedAny = true;
                    iter.remove();
                }
                catch (Exception e) {
                    BookErrorManager.get().error("Error while testing entry condition", e);
                }
            }
        } while (unlockedAny);
        BookErrorManager.get().reset();
    }

    public boolean read(BookEntry entry, ServerPlayer player) {
        if (this.isRead(entry)) {
            return false;
        }
        this.readEntries.computeIfAbsent(entry.getBook().getId(), k -> new HashSet()).add(entry.getId());
        BookCommand command = entry.getCommandToRunOnFirstRead();
        if (command != null) {
            command.execute(player);
        }
        return true;
    }

    public void setRun(BookCommand command) {
        if (command.getBook() == null) {
            return;
        }
        Integer uses = ((Map)this.usedCommands.getOrDefault(command.getBook().getId(), new HashMap())).getOrDefault(command.getId(), 0);
        this.usedCommands.computeIfAbsent(command.getBook().getId(), k -> new HashMap()).put(command.getId(), uses + 1);
    }

    public boolean canRun(BookCommand command) {
        if (command.getBook() == null) {
            return false;
        }
        if (command.getMaxUses() == -1) {
            return true;
        }
        return ((Map)this.usedCommands.getOrDefault(command.getBook().getId(), new HashMap())).getOrDefault(command.getId(), 0) < command.getMaxUses();
    }

    public boolean isRead(BookEntry entry) {
        if (entry.getBook() == null) {
            return false;
        }
        return ((Set)this.readEntries.getOrDefault(entry.getBook().getId(), new HashSet())).contains(entry.getId());
    }

    public boolean isUnlocked(BookEntry entry) {
        if (entry.getBook() == null) {
            return false;
        }
        return ((Set)this.unlockedEntries.getOrDefault(entry.getBook().getId(), new HashSet())).contains(entry.getId());
    }

    public boolean isUnlocked(BookCategory category) {
        if (category.getBook() == null) {
            return false;
        }
        return ((Set)this.unlockedCategories.getOrDefault(category.getBook().getId(), new HashSet())).contains(category.getId());
    }

    public void reset(Book book) {
        this.readEntries.remove(book.getId());
        this.unlockedEntries.remove(book.getId());
        this.unlockedCategories.remove(book.getId());
    }

    public List<ResourceLocation> getBooks() {
        HashSet books = new HashSet();
        books.addAll(this.readEntries.keySet());
        books.addAll(this.unlockedEntries.keySet());
        books.addAll(this.unlockedCategories.keySet());
        return books.stream().toList();
    }

    public String getUnlockCode(Book book) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130085_(book.getId());
        Set unlockedCategories = this.unlockedCategories.getOrDefault(book.getId(), Set.of());
        buf.m_130130_(unlockedCategories.size());
        unlockedCategories.forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130085_(arg_0));
        Set unlockedEntries = this.unlockedEntries.getOrDefault(book.getId(), Set.of());
        buf.m_130130_(unlockedEntries.size());
        unlockedEntries.forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130085_(arg_0));
        Set readEntries = this.readEntries.getOrDefault(book.getId(), Set.of());
        buf.m_130130_(readEntries.size());
        readEntries.forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130085_(arg_0));
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        return Base64.getEncoder().encodeToString(bytes);
    }

    public Book applyUnlockCode(String code) {
        try {
            byte[] decoded = Base64.getDecoder().decode(code);
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])decoded));
            ResourceLocation bookId = buf.m_130281_();
            Book book = BookDataManager.get().getBook(bookId);
            if (book == null) {
                return null;
            }
            HashSet<ResourceLocation> unlockedCategories = new HashSet<ResourceLocation>();
            HashSet<ResourceLocation> unlockedEntries = new HashSet<ResourceLocation>();
            HashSet<ResourceLocation> readEntries = new HashSet<ResourceLocation>();
            int unlockedCategoriesSize = buf.m_130242_();
            for (int i = 0; i < unlockedCategoriesSize; ++i) {
                unlockedCategories.add(buf.m_130281_());
            }
            int unlockedEntriesSize = buf.m_130242_();
            for (int i = 0; i < unlockedEntriesSize; ++i) {
                unlockedEntries.add(buf.m_130281_());
            }
            int readEntriesSize = buf.m_130242_();
            for (int i = 0; i < readEntriesSize; ++i) {
                readEntries.add(buf.m_130281_());
            }
            this.unlockedCategories.put(bookId, unlockedCategories);
            this.unlockedEntries.put(bookId, unlockedEntries);
            this.readEntries.put(bookId, readEntries);
            return book;
        }
        catch (Exception e) {
            return null;
        }
    }
}

